/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.validate_input;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaInpatientProviderData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hha.resources.HhaCbsaUtil;

public class ValidateCountyCode
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        String cbsa = ((HhaInpatientProviderData)((HhaClaimPricingRequest)calculationContext.getInput()).getProviderData()).getCbsaActualGeographicLocation();
        return HhaCbsaUtil.sanitizeCbsa(cbsa).length() == 2;
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        String ruralCategory = calculationContext.getDataTables().getAddOnCategory(calculationContext.getProviderData().getCountyCode());
        if (ruralCategory == null) {
            calculationContext.completeWithReturnCode(ReturnCode.INVALID_COUNTY_CODE_31);
            return;
        }
        calculationContext.setRuralCategory(ruralCategory);
    }
}

