/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@JsonDeserialize(builder=HrgEntryBuilder.class)
@JsonPropertyOrder(value={"code", "effectiveDate", "weight", "threshold"})
@Immutable
public class HrgEntry
implements Comparable<HrgEntry> {
    @Pattern(regexp="\\w{5}")
    private final @Pattern(regexp="\\w{5}") String code;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;
    @Digits(integer=2, fraction=4)
    @BigDecimalScale(scale=4)
    private final @Digits(integer=2, fraction=4) BigDecimal weight;
    private final Integer threshold;

    @Override
    public int compareTo(@Nonnull HrgEntry o) {
        return Comparator.comparing(HrgEntry::getEffectiveDate).compare(this, o);
    }

    @Generated
    HrgEntry(String code, LocalDate effectiveDate, BigDecimal weight, Integer threshold) {
        this.code = code;
        this.effectiveDate = effectiveDate;
        this.weight = weight;
        this.threshold = threshold;
    }

    @Generated
    public static HrgEntryBuilder builder() {
        return new HrgEntryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HrgEntry)) {
            return false;
        }
        HrgEntry other = (HrgEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$threshold = this.getThreshold();
        Integer other$threshold = other.getThreshold();
        if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        BigDecimal this$weight = this.getWeight();
        BigDecimal other$weight = other.getWeight();
        return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HrgEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        BigDecimal $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        return result;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getWeight() {
        return this.weight;
    }

    @Generated
    public Integer getThreshold() {
        return this.threshold;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class HrgEntryBuilder {
        @Generated
        private String code;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal weight;
        @Generated
        private Integer threshold;

        @Generated
        HrgEntryBuilder() {
        }

        @Generated
        public HrgEntryBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public HrgEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public HrgEntryBuilder weight(BigDecimal weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public HrgEntryBuilder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        @Generated
        public HrgEntry build() {
            return new HrgEntry(this.code, this.effectiveDate, this.weight, this.threshold);
        }

        @Generated
        public String toString() {
            return "HrgEntry.HrgEntryBuilder(code=" + this.code + ", effectiveDate=" + this.effectiveDate + ", weight=" + this.weight + ", threshold=" + this.threshold + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String CODE = "code";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String WEIGHT = "weight";
        public static final String THRESHOLD = "threshold";
    }
}

