/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.hha.core.tables.RevenueEntry;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class RevenueLookupProvider {
    private static final String CSV_FILE_PATTERN = "/rev-%s.csv";
    private final CsvContentReader<RevenueEntry> contentProvider = new CsvContentReader<RevenueEntry>(RevenueEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public RevenueLookupProvider(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, RevenueEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NavigableMap<LocalDate, RevenueEntry>> generate(String csvFile) {
        List<RevenueEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy(Comparator.naturalOrder());
        Collector<RevenueEntry, ?, NavigableMap> collector = Collectors.toMap(RevenueEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(RevenueEntry::getCode, content, HashMap::new, collector);
    }
}

