/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.NormalizedString;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParserOutput;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;

public class ColumnMap {
    private Map<NormalizedString, Integer> columnMap;
    private int[] enumMap;
    private int[] extractedIndexes = null;
    private final Context context;
    private final ParserOutput output;

    public ColumnMap(Context context, ParserOutput output) {
        this.context = context;
        this.output = output;
    }

    public int indexOf(String header) {
        Integer index;
        if (this.columnMap != null && this.columnMap.isEmpty()) {
            return -1;
        }
        this.validateHeader(header);
        NormalizedString normalizedHeader = NormalizedString.valueOf(header);
        if (this.columnMap == null) {
            NormalizedString[] headers = NormalizedString.toIdentifierGroupArray(this.context.headers());
            if (headers == null) {
                this.columnMap = Collections.emptyMap();
                return -1;
            }
            this.columnMap = new HashMap<NormalizedString, Integer>(headers.length);
            this.extractedIndexes = this.context.extractedFieldIndexes();
            if (this.extractedIndexes != null) {
                if (this.context.columnsReordered()) {
                    int[] selection = ArgumentUtils.removeAll(this.extractedIndexes, -1);
                    for (int i2 = 0; i2 < selection.length; ++i2) {
                        int originalIndex = selection[i2];
                        NormalizedString h2 = headers[originalIndex];
                        this.columnMap.put(h2, i2);
                    }
                } else {
                    for (int i3 = 0; i3 < this.extractedIndexes.length && i3 < headers.length; ++i3) {
                        this.columnMap.put(headers[i3], i3);
                    }
                }
            } else {
                for (int i4 = 0; i4 < headers.length; ++i4) {
                    this.columnMap.put(headers[i4], i4);
                }
            }
        }
        if ((index = this.columnMap.get(normalizedHeader)) == null) {
            return -1;
        }
        return index;
    }

    private void validateHeader(Object header) {
        if (header == null) {
            if (this.context.headers() == null) {
                throw new IllegalArgumentException("Header name cannot be null.");
            }
            throw new IllegalArgumentException("Header name cannot be null. Use one of the available column names: " + Arrays.asList(this.context.headers()));
        }
    }

    public int indexOf(Enum<?> header) {
        if (this.enumMap != null && this.enumMap.length == 0) {
            return -1;
        }
        this.validateHeader(header);
        if (this.enumMap == null) {
            FieldSelector selector;
            NormalizedString[] headers = NormalizedString.toIdentifierGroupArray(this.context.headers());
            if (headers == null) {
                this.enumMap = new int[0];
                return -1;
            }
            Enum[] constants = (Enum[])header.getClass().getEnumConstants();
            int lastOrdinal = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < constants.length; ++i2) {
                if (lastOrdinal >= constants[i2].ordinal()) continue;
                lastOrdinal = constants[i2].ordinal();
            }
            this.enumMap = new int[lastOrdinal + 1];
            FieldSelector fieldSelector = selector = this.output == null ? null : this.output.getFieldSelector();
            if (!this.context.columnsReordered()) {
                selector = null;
            }
            for (int i3 = 0; i3 < constants.length; ++i3) {
                int index;
                Enum constant = constants[i3];
                String name = constant.toString();
                this.enumMap[constant.ordinal()] = index = ArgumentUtils.indexOf(headers, NormalizedString.valueOf(name), selector);
            }
        }
        return this.enumMap[header.ordinal()];
    }

    void reset() {
        this.columnMap = null;
        this.enumMap = null;
        this.extractedIndexes = null;
    }
}

