/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.util.Arrays;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ProcessorErrorHandler;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.RetryableErrorHandler;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.core.Processor;

class Internal {
    Internal() {
    }

    public static final <C extends Context> void process(String[] row, Processor<C> processor, C context, ProcessorErrorHandler<C> errorHandler) {
        try {
            processor.rowProcessed(row, context);
        }
        catch (DataProcessingException ex) {
            ex.setContext(context);
            if (!ex.isFatal() && !ex.isHandled() && ex.getColumnIndex() > -1 && errorHandler instanceof RetryableErrorHandler) {
                RetryableErrorHandler retry = (RetryableErrorHandler)errorHandler;
                ex.markAsHandled(errorHandler);
                retry.handleError(ex, row, context);
                if (!retry.isRecordSkipped()) {
                    try {
                        processor.rowProcessed(row, context);
                        return;
                    }
                    catch (DataProcessingException e) {
                        ex = e;
                    }
                    catch (Throwable t2) {
                        Internal.throwDataProcessingException(processor, t2, row, context.errorContentLength());
                    }
                }
            }
            ex.setErrorContentLength(context.errorContentLength());
            if (ex.isFatal()) {
                throw ex;
            }
            ex.markAsHandled(errorHandler);
            errorHandler.handleError(ex, row, context);
        }
        catch (Throwable t3) {
            Internal.throwDataProcessingException(processor, t3, row, context.errorContentLength());
        }
    }

    private static final void throwDataProcessingException(Processor processor, Throwable t2, String[] row, int errorContentLength) throws DataProcessingException {
        DataProcessingException ex = new DataProcessingException("Unexpected error processing input row " + AbstractException.restrictContent(errorContentLength, Arrays.toString(row)) + " using Processor " + processor.getClass().getName() + '.', AbstractException.restrictContent(errorContentLength, row), t2);
        ex.restrictContent(errorContentLength);
        throw ex;
    }
}

