// Generated by delombok at Thu Mar 06 01:40:34 UTC 2025
package gov.cms.fiss.pricers.hha;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.hha.core.Hha2020PricerContext;
import gov.cms.fiss.pricers.hha.core.Hha2021PricerContext;
import gov.cms.fiss.pricers.hha.core.Hha2022PricerContext;
import gov.cms.fiss.pricers.hha.core.Hha2023PricerContext;
import gov.cms.fiss.pricers.hha.core.Hha2024PricerContext;
import gov.cms.fiss.pricers.hha.core.Hha2025PricerContext;
import gov.cms.fiss.pricers.hha.core.HhaPricerDispatch;
import gov.cms.fiss.pricers.hha.resources.HhaClaimPricingResource;
import gov.cms.fiss.pricers.hha.resources.HhaExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HhaPricerApplication extends OpenApiPricerApplication<HhaPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(HhaPricerApplication.class);

  public static void main(String[] args) throws Exception {
    new HhaPricerApplication().run(args);
  }

  @Override
  protected void configureApplication(HhaPricerConfiguration configuration, Environment environment) {
    final HhaClaimPricingResource v2Resource = new HhaClaimPricingResource(new HhaPricerDispatch(configuration));
    environment.jersey().register(v2Resource);
    environment.jersey().register(new CbsaWageIndexResource(configuration, HhaExtractionUtil.CBSA_EXTRACTOR));
  }

  @Override
  protected List<OpenApiCustomizer> getContractCustomizers() {
    final List<OpenApiCustomizer> customizers = new ArrayList<>(super.getContractCustomizers());
    customizers.add((configuration, environment, oas) -> oas.info(new Info().title("HHA Pricer").version("v1")));
    return customizers;
  }

  @Override
  public String getName() {
    return "hha-pricer";
  }

  @Override
  protected List<Package> getResourcePackages() {
    return Collections.singletonList(HhaClaimPricingResource.class.getPackage());
  }

  @Override
  protected Map<Integer, String> getCalculationVersions() {
    return Map.of(2020, Hha2020PricerContext.CALCULATION_VERSION_2020, 2021, Hha2021PricerContext.CALCULATION_VERSION_2021, 2022, Hha2022PricerContext.CALCULATION_VERSION_2022, 2023, Hha2023PricerContext.CALCULATION_VERSION_2023, 2024, Hha2024PricerContext.CALCULATION_VERSION_2024, 2025, Hha2025PricerContext.CALCULATION_VERSION_2025);
  }
}
