// Generated by delombok at Thu Mar 06 01:40:34 UTC 2025
package gov.cms.fiss.pricers.hha.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hha.core.models.RevenueRateEntry;
import gov.cms.fiss.pricers.hha.core.tables.DataTables;
import gov.cms.fiss.pricers.hha.core.tables.RevenueEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public abstract class HhaPricerContext extends CalculationContext<HhaClaimPricingRequest, HhaClaimPricingResponse> {
  public static final BigDecimal USABLE_RAP_MODIFIER = new BigDecimal("0.20");
  public static final int RTC_ADJUSTMENT_INDICATOR_2 = 2;
  public static final int RTC_ADJUSTMENT_INDICATOR_4 = 4;
  private static final BigDecimal RURAL_NOOP = new BigDecimal("1.000");
  @JsonIgnore
  private final DataTables dataTables;
  //
  // Calculation state (hold) variables
  //
  private final List<@NotNull RevenueRateEntry> revenueData = new ArrayList<>();
  private boolean partialEpisodePaymentCalculated = false;
  private Integer returnCodeAdjustmentIndicator = 0;
  private BigDecimal wsStdvLupaAddonFac = new BigDecimal("0.0000");
  @FixedValue
  private BigDecimal federalEpisodeRateAmount = BigDecimalUtils.ZERO;
  private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
  private BigDecimal pretotalPepPayment = BigDecimalUtils.ZERO;
  private String ruralCategory = "";
  private int hrgThreshold; // L-HRG-THRESHOLD
  private BigDecimal cbsaWageIndex = new BigDecimal("0.0000"); // WIR-CBSA-WAGEIND
  private BigDecimal temporaryPaymentTotal; // WK-9100-TOTAL-PAYMENT

  protected HhaPricerContext(HhaClaimPricingRequest input, HhaClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeContext();
  }

  protected void initializeContext() {
    for (final RevenueLineData inputRevenueData : getRevenueLines()) {
      final RevenuePaymentData outputRevenueData = new RevenuePaymentData();
      outputRevenueData.setRevenueCode(inputRevenueData.getRevenueCode());
      getRevenuePayments().add(outputRevenueData);
    }
  }

  //
  // Helper methods
  //
  public HhaClaimData getClaimData() {
    return getInput().getClaimData();
  }

  public List<RevenueLineData> getRevenueLines() {
    if (getClaimData().getRevenueLines() == null) {
      getClaimData().setRevenueLines(new ArrayList<>());
    }
    return getClaimData().getRevenueLines();
  }

  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  public HhaPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  public List<RevenuePaymentData> getRevenuePayments() {
    if (getPaymentData().getRevenuePayments() == null) {
      getPaymentData().setRevenuePayments(new ArrayList<>());
    }
    return getPaymentData().getRevenuePayments();
  }

  //
  // Constant Accessors
  //
  @FixedValue
  public abstract BigDecimal getRateAmountChecked();

  public abstract BigDecimal getThresholdAmountChecked();

  @FixedValue
  public abstract BigDecimal getRateAmountUnchecked();

  public abstract BigDecimal getThresholdAmountUnchecked();

  public abstract BigDecimal getStandardizedRuralMultiplier();

  public abstract BigDecimal getStandardValueAmount();

  public abstract BigDecimal getLaborPercent();

  public abstract BigDecimal getNonLaborPercent();

  public abstract BigDecimal getLupaAddOnSkilledNursing();

  public abstract BigDecimal getLupaAddOnPhysicalTherapy();

  public abstract BigDecimal getLupaAddOnSpeechLanguagePathology();

  public abstract BigDecimal getLupaAddOnOccupationalTherapy();

  public abstract BigDecimal getOutlierLossSharingRatio();

  public abstract String getCalculationVersion();

  @FixedValue
  protected abstract BigDecimal getRuralAddOnA();

  @FixedValue
  protected abstract BigDecimal getRuralAddOnB();

  @FixedValue
  protected abstract BigDecimal getRuralAddOnC();

  public boolean checkReturnCode(ReturnCode code) {
    return code.getCode() == Integer.parseInt(getOutput().getReturnCodeData().getCode());
  }

  public void completeWithReturnCode(ReturnCode code) {
    applyReturnCode(code);
    setCalculationCompleted();
  }

  public void applyReturnCode(ReturnCode code) {
    getOutput().setReturnCodeData(code.toReturnCodeData());
  }

  public boolean usingDataCheck() {
    return StringUtils.equalsAny(getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "1");
  }

  public boolean isPartialEpisodePaymentIndicator() {
    return StringUtils.equals(getInput().getClaimData().getPartialEpisodePaymentIndicator(), "Y");
  }

  public boolean isLateFilingPenaltyWaiverIndicator() {
    return StringUtils.equals(getInput().getClaimData().getLateFilingPenaltyWaiverIndicator(), "Y");
  }

// From 1/1/2019 through 12/31/2023, eligible FIPS county codes and 500xx CBSAs
// received a rural adjustment according to rural category.
  public boolean isRural(String revenueCode) {
    return StringUtils.equalsAny(revenueCode, "50001", "50002", "50005", "50007", "50025", "50028", "50031", "50035", "50036", "50037", "50041", "50045", "50047", "50048", "50050", "50056", "50057", "50066", "50068", "50071", "50073", "50080", "50084", "50087", "50089", "50090", "50091", "50103", "50104", "50111", "50115", "50117", "50118", "50120", "50121", "50139", "50146", "50147", "50149", "50151", "50164", "50165", "50168", "50169", "50173", "50174", "50177", "50180", "50182", "50183") || StringUtils.startsWith(revenueCode, "999");
  }

  public RevenueRateEntry getRateEntry(String code) {
    final LocalDate date = getClaimData().getServiceThroughDate();
    @FixedValue
    final RevenueEntry revenueEntry = dataTables.getRevenueEntry(code, date);
    if (revenueEntry == null) {
      return null;
    }
    final String revenueCode = revenueEntry.getCode();
    @FixedValue
    final RevenueRateEntry rateEntry = new RevenueRateEntry(revenueCode, revenueEntry.getNonruralUnitDollarRate(), revenueEntry.getNonruralDollarRate(), revenueEntry.getNonruralDollarRate());
    if (isRural(revenueCode)) {
      if (usingDataCheck()) {
        rateEntry.setDollarRate(revenueEntry.getRuralDollarRate());
        rateEntry.setDollarRateUnits(revenueEntry.getRuralUnitDollarRate());
      } else {
        rateEntry.setDollarRate(revenueEntry.getRuralUnsubmittedDollarRate());
        rateEntry.setDollarRateUnits(revenueEntry.getRuralUnsubmittedUnitDollarRate());
      }
    } else if (!usingDataCheck()) {
      rateEntry.setDollarRate(revenueEntry.getNonruralUnsubmittedDollarRate());
      rateEntry.setDollarRateUnits(revenueEntry.getNonruralUnsubmittedUnitDollarRate());
    }
    return rateEntry;
  }

  public boolean isValidPaymentIndicator() {
    return StringUtils.equalsAny(getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "1", "2", "3");
  }

  public boolean isUsablePaymentIndicator() {
    return StringUtils.equalsAny(getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "2");
  }

  public boolean isPartialEpisodePaymentCalculated() {
    return partialEpisodePaymentCalculated;
  }

  public void setPartialEpisodePaymentCalculated() {
    partialEpisodePaymentCalculated = true;
  }

  /**
   * Determines an adjusted cost based on labor and non-labor rates.
   *
   * @param initialCost the cost that needs to be adjusted for labor/non-labor rates
   * @return the adjusted cost
   */
  public BigDecimal calculateAdjustedCost(BigDecimal initialCost) {
    final BigDecimal fedLaborAdj = getCbsaWageIndex().multiply(getLaborPercent()).multiply(initialCost).setScale(2, RoundingMode.HALF_UP);
    final BigDecimal fedNonLaborAdj = getNonLaborPercent().multiply(initialCost).setScale(2, RoundingMode.HALF_UP);
    return fedLaborAdj.add(fedNonLaborAdj);
  }

  /**
   * Uses the MAC-provided weight and procedurally-determined federal episode rate to determine the
   * labor-adjusted cost basis.
   *
   * @return the cost basis on which payment is calculated
   */
  public BigDecimal calculatePaymentBasis() {
    return calculateAdjustedCost(getPaymentData().getHhrgWeight().multiply(getFederalEpisodeRateAmount()).setScale(2, RoundingMode.HALF_UP));
  }

  public boolean hasReturnCode(ReturnCode expectedCode) {
    return expectedCode.equals(ReturnCode.fromCode(Integer.parseInt(getOutput().getReturnCodeData().getCode())));
  }

  @FixedValue
  public BigDecimal getRuralAddon() {
    switch (getRuralCategory()) {
    default: 
      return getRuralAddOnA();
    default: 
      return getRuralAddOnB();
    default: 
      return getRuralAddOnC();
    default: 
      return RURAL_NOOP;
    }
  }

  public boolean isBillTypeClaim() {
    return StringUtils.equalsAny(getClaimData().getTypeOfBill(), "327", "329", "32F", "32G", "32H", "32I", "32J", "32K", "32M", "32Q", "32P");
  }

  public boolean isBillTypeRap() {
    return StringUtils.equalsAny(getClaimData().getTypeOfBill(), "322");
  }

  public boolean isBillTypeValid() {
    return isBillTypeClaim() || isBillTypeRap();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull RevenueRateEntry> getRevenueData() {
    return this.revenueData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getReturnCodeAdjustmentIndicator() {
    return this.returnCodeAdjustmentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnCodeAdjustmentIndicator(final Integer returnCodeAdjustmentIndicator) {
    this.returnCodeAdjustmentIndicator = returnCodeAdjustmentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWsStdvLupaAddonFac() {
    return this.wsStdvLupaAddonFac;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWsStdvLupaAddonFac(final BigDecimal wsStdvLupaAddonFac) {
    this.wsStdvLupaAddonFac = wsStdvLupaAddonFac;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalEpisodeRateAmount() {
    return this.federalEpisodeRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalEpisodeRateAmount(final BigDecimal federalEpisodeRateAmount) {
    this.federalEpisodeRateAmount = federalEpisodeRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierThresholdAmount() {
    return this.outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierThresholdAmount(final BigDecimal outlierThresholdAmount) {
    this.outlierThresholdAmount = outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPretotalPepPayment() {
    return this.pretotalPepPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPretotalPepPayment(final BigDecimal pretotalPepPayment) {
    this.pretotalPepPayment = pretotalPepPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRuralCategory() {
    return this.ruralCategory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralCategory(final String ruralCategory) {
    this.ruralCategory = ruralCategory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHrgThreshold() {
    return this.hrgThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHrgThreshold(final int hrgThreshold) {
    this.hrgThreshold = hrgThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCbsaWageIndex() {
    return this.cbsaWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaWageIndex(final BigDecimal cbsaWageIndex) {
    this.cbsaWageIndex = cbsaWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTemporaryPaymentTotal() {
    return this.temporaryPaymentTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTemporaryPaymentTotal(final BigDecimal temporaryPaymentTotal) {
    this.temporaryPaymentTotal = temporaryPaymentTotal;
  }
}
