// Generated by delombok at Thu Mar 06 01:40:34 UTC 2025
package gov.cms.fiss.pricers.hha.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.hha.HhaPricerConfiguration;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.core.tables.DataTables;
import java.time.LocalDate;

public class HhaPricerDispatch extends PricerDispatch<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(HhaPricerDispatch.class);

  public HhaPricerDispatch(HhaPricerConfiguration configuration) {
    super(configuration, o -> o.getReturnCodeData().getCode());
  }

  @Override
  protected void initializeReferences(HhaPricerConfiguration pricerConfiguration) {
    DataTables.loadDataTables(pricerConfiguration);
    for (final int supportedYear : pricerConfiguration.getSupportedYears()) {
      switch (supportedYear) {
      default: 
        yearReference.register(supportedYear, Hha2020RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Hha2021RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Hha2022RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Hha2023RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Hha2024RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Hha2025RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        break;
      }
    }
  }

  @Override
  protected ClaimProcessor<HhaClaimPricingRequest, HhaClaimPricingResponse> getProcessor(HhaClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
    final HhaClaimData claimData = input.getClaimData();
    final LocalDate serviceThroughDate = claimData.getServiceThroughDate();
    if (serviceThroughDate.getYear() > 2020) {
      return yearReference.fromCalendarYear(serviceThroughDate, "serviceThroughDate");
    } else {
      return yearReference.fromCalendarYear(claimData.getServiceFromDate(), "serviceFromDate");
    }
  }

  @Override
  protected boolean isErrorOutput(HhaClaimPricingResponse output) {
    final int resultCode = Integer.parseInt(output.getReturnCodeData().getCode());
    return resultCode >= 15 || resultCode == 10;
  }
}
