// Generated by delombok at Thu Mar 06 01:40:35 UTC 2025
package gov.cms.fiss.pricers.hha.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("unused")
public enum ReturnCode {
  PAYMENT_WITHOUT_OUTLIER_0(0, "FINAL PAYMENT WHERE NO OUTLIER APPLIES", "Final payment where no outlier applies"), PAYMENT_WITH_OUTLIER_1(1, "FINAL PAYMENT WHERE OUTLIER APPLIES", "Final payment where outlier applies"), PAYMENT_WITH_OUTLIER_LIMITATION_2(2, "FINAL PAYMENT WHERE OUTLIER APPLIES, BUT IS NOT PAYABLE DUE TO LIMITATION", "Final payment where outlier applies, but is not payable due to limitation"), NOT_USED_INDICATOR_3(3, "THIS PAYMENT INDICATOR IS NOT USED", "This payment indicator is not used"), NOT_USED_INDICATOR_4(4, "THIS PAYMENT INDICATOR IS NOT USED", "This payment indicator is not used"), LUPA_PAYMENT_6(6, "LUPA PAYMENT ONLY", "LUPA payment only"), PAYMENT_PARTIAL_PERIOD_9(9, "FINAL PAYMENT, PARTIAL PERIOD PAYMENT", "Final payment, partial period payment"), INVALID_TYPE_OF_BILL_10(10, "INVALID TYPE OF BILL", "Invalid type of bill"), PAYMENT_PARTIAL_PERIOD_OUTLIER_11(11, "FINAL PAYMENT, PARTIAL PERIOD PAYMENT WITH OUTLIER", "Final payment, partial period payment with outlier"), LUPA_PAYMENT_WITH_ADDON_14(14, "LUPA PAYMENT, ADD-ON PAYMENT APPLIES", "LUPA payment, add-on payment applies"), NUMBER_OF_DAYS_IS_ZERO_15(15, "NUMBER OF DAYS IS ZERO", "Number of days is zero"), NUMBER_OF_DAYS_EXCEEDS_LIMIT_16(16, "NUMBER OF DAYS EXCEEDS LIMIT", "Number of days exceeds limit"), INVALID_PEP_INDICATOR_20(20, "INVALID PEP INDICATOR", "Invalid PEP indicator"), INVALID_CBSA_CODE_30(30, "INVALID CBSA CODE", "Invalid CBSA code"), INVALID_COUNTY_CODE_31(31, "INVALID COUNTY CODE", "Invalid county code"), INVALID_PAYMENT_INDICATOR_35(35, "INVALID PAYMENT INDICATOR", "Invalid payment indicator"), ADMITTED_AFTER_SERVICE_STARTED_40(40, "ADMITTED AFTER SERVICE STARTED", "Admitted after service started"), INVALID_INPUT_CODE_70(70, "INVALID INPUT CODE", "Invalid input code"), REVENUE_CODE_NOT_FOUND_80(80, "REVENUE CODE NOT FOUND", "Revenue code not found"), REVENUE_CODE_NOT_SET_85(85, "REVENUE CODE NOT SET", "Revenue code not set");
  private final int code;
  private final String desc;
  private final String exp;

  ReturnCode(int code, String desc, String exp) {
    this.code = code;
    this.desc = desc;
    this.exp = exp;
  }

  public static ReturnCode fromCode(int code) {
    return Arrays.stream(ReturnCode.values()).filter(resultCode -> resultCode.getCode() == code).findFirst().orElse(null);
  }

  @Override
  public String toString() {
    return String.valueOf(code);
  }

  public boolean is(int code) {
    return this.code == code;
  }

  public ReturnCodeData toReturnCodeData() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    final String paddedCode = StringUtils.leftPad(String.valueOf(this.code), 2, "0");
    returnCodeData.setCode(paddedCode);
    returnCodeData.setDescription(this.desc);
    returnCodeData.setExplanation(this.exp);
    return returnCodeData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDesc() {
    return this.desc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExp() {
    return this.exp;
  }
}
