/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.final_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.util.List;

public class CheckLupaPaymentValues
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        return !calculationContext.isPartialEpisodePaymentCalculated();
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        HhaClaimData input = calculationContext.getClaimData();
        List<RevenuePaymentData> revenueData = calculationContext.getRevenuePayments();
        if (!input.getAdmissionDate().isEqual(input.getServiceFromDate()) || input.getLupaSourceAdmissionIndicator().equals("B") || input.getAdjustmentIndicator().equals("2") || calculationContext.getPaymentData().getTotalQuantityOfCoveredVisits() == 0) {
            for (int i2 = 0; i2 < 5; ++i2) {
                revenueData.get(i2).setAddOnVisitAmount(BigDecimalUtils.ZERO);
            }
        }
    }
}

