/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.hha.HhaPricerConfiguration;
import gov.cms.fiss.pricers.hha.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.hha.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.hha.core.tables.HrgEntry;
import gov.cms.fiss.pricers.hha.core.tables.HrgLookupProvider;
import gov.cms.fiss.pricers.hha.core.tables.RevenueEntry;
import gov.cms.fiss.pricers.hha.core.tables.RevenueLookupProvider;
import gov.cms.fiss.pricers.hha.core.tables.StateCountyCodeEntry;
import gov.cms.fiss.pricers.hha.core.tables.StateCountyCodeLookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, StateCountyCodeEntry> addOnMap;
    private final Map<String, StateCountyCodeEntry> extraAddonMap;
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<String, HrgEntry> hrgMap;
    private final Map<String, NavigableMap<LocalDate, RevenueEntry>> revenueMap;

    public DataTables(Map<String, StateCountyCodeEntry> addOnMap, Map<String, StateCountyCodeEntry> extraAddOnMap, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaMap, Map<String, HrgEntry> hrgMap, Map<String, NavigableMap<LocalDate, RevenueEntry>> revenueMap) {
        this.addOnMap = addOnMap;
        this.extraAddonMap = extraAddOnMap;
        this.cbsaTable = cbsaMap;
        this.revenueMap = revenueMap;
        this.hrgMap = hrgMap;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(HhaPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        Map<String, StateCountyCodeEntry> addOnMap = new StateCountyCodeLookupGenerator(csvIngestionConfiguration).generate("/add-on-table.csv");
        Map<String, StateCountyCodeEntry> extraAddOnMap = new StateCountyCodeLookupGenerator(csvIngestionConfiguration).generate("/extra-add-on-table.csv");
        CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        HrgLookupProvider hrgLookupProvider = new HrgLookupProvider(csvIngestionConfiguration);
        RevenueLookupProvider revenueLookupProvider = new RevenueLookupProvider(csvIngestionConfiguration);
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(pricerYear, new DataTables(addOnMap, extraAddOnMap, cbsaLookupProvider.generate(pricerYear), hrgLookupProvider.generate(pricerYear), revenueLookupProvider.generate(pricerYear)));
        }
    }

    public String getAddOnCategory(String code) {
        StateCountyCodeEntry entry = this.addOnMap.get(code);
        return entry == null ? null : entry.getCategory();
    }

    public String getExtraAddOnCategory(String code) {
        StateCountyCodeEntry entry = this.extraAddonMap.get(code);
        return entry == null ? null : entry.getCategory();
    }

    private CbsaWageIndexEntry getCbsaWageIndexEntry(String code, LocalDate date) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> map = this.cbsaTable.get(code);
        if (map == null) {
            return null;
        }
        Map.Entry<LocalDate, CbsaWageIndexEntry> kvPair = map.floorEntry(date);
        if (kvPair == null) {
            return null;
        }
        return map.floorEntry(date).getValue();
    }

    public RevenueEntry getRevenueEntry(String code, LocalDate date) {
        NavigableMap<LocalDate, RevenueEntry> map = this.revenueMap.get(code);
        if (map == null) {
            return null;
        }
        Map.Entry<LocalDate, RevenueEntry> kvPair = map.floorEntry(date);
        if (kvPair == null) {
            return null;
        }
        return map.floorEntry(date).getValue();
    }

    public BigDecimal getGeographicWageIndex(String code, LocalDate date) {
        CbsaWageIndexEntry entry = this.getCbsaWageIndexEntry(StringUtils.leftPad(code, 5, "9"), date);
        if (entry == null) {
            return null;
        }
        return entry.getGeographicWageIndex();
    }

    public BigDecimal getHrgWeight(String code) {
        HrgEntry entry = this.hrgMap.get(code);
        if (entry == null) {
            return null;
        }
        return entry.getWeight();
    }

    public Integer getHrgThreshold(String code) {
        HrgEntry entry = this.hrgMap.get(code);
        if (entry == null) {
            return null;
        }
        return entry.getThreshold();
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

