/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.ArrayTernaryTrie;

public class ContextRoutingHandler
extends AbstractHandlerContainer {
    private final ArrayTernaryTrie<Handler> handlers = new ArrayTernaryTrie(false);

    public ContextRoutingHandler(Map<String, ? extends Handler> handlers) {
        for (Map.Entry<String, ? extends Handler> entry : handlers.entrySet()) {
            if (!this.handlers.put(entry.getKey(), entry.getValue())) {
                throw new IllegalStateException("Too many handlers");
            }
            this.addBean(entry.getValue());
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = this.handlers.getBest(baseRequest.getRequestURI());
        if (handler != null) {
            handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).stop();
        }
    }

    @Override
    public Handler[] getHandlers() {
        return (Handler[])this.handlers.entrySet().stream().map(Map.Entry::getValue).toArray(Handler[]::new);
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray != null) {
            for (Handler h2 : handlerArray) {
                this.expandHandler(h2, list, byClass);
            }
        }
    }
}

