/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.dropwizard.logging.json.EventAttribute;
import io.dropwizard.logging.json.layout.AbstractJsonLayout;
import io.dropwizard.logging.json.layout.JsonFormatter;
import io.dropwizard.logging.json.layout.MapBuilder;
import io.dropwizard.logging.json.layout.TimestampFormatter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class EventJsonLayout
extends AbstractJsonLayout<ILoggingEvent> {
    private Set<EventAttribute> includes;
    @Nullable
    private String jsonProtocolVersion;
    private final ThrowableHandlingConverter throwableProxyConverter;
    private final TimestampFormatter timestampFormatter;
    private final Map<String, Object> additionalFields;
    private final Map<String, String> customFieldNames;
    private Set<String> includesMdcKeys;
    private final boolean flattenMdc;

    public EventJsonLayout(JsonFormatter jsonFormatter, TimestampFormatter timestampFormatter, ThrowableHandlingConverter throwableProxyConverter, Set<EventAttribute> includes, Map<String, String> customFieldNames, Map<String, Object> additionalFields, Set<String> includesMdcKeys, boolean flattenMdc) {
        super(jsonFormatter);
        this.timestampFormatter = timestampFormatter;
        this.additionalFields = new HashMap<String, Object>(additionalFields);
        this.customFieldNames = new HashMap<String, String>(customFieldNames);
        this.throwableProxyConverter = throwableProxyConverter;
        this.includes = new HashSet<EventAttribute>(includes);
        this.includesMdcKeys = new HashSet<String>(includesMdcKeys);
        this.flattenMdc = flattenMdc;
    }

    @Override
    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    @Override
    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        MapBuilder mapBuilder = new MapBuilder(this.timestampFormatter, this.customFieldNames, this.additionalFields, this.includes.size()).addTimestamp("timestamp", this.isIncluded(EventAttribute.TIMESTAMP), event.getTimeStamp()).add("level", this.isIncluded(EventAttribute.LEVEL), () -> String.valueOf(event.getLevel())).add("thread", this.isIncluded(EventAttribute.THREAD_NAME), event::getThreadName).add("marker", this.isIncluded(EventAttribute.MARKER) && event.getMarker() != null, () -> event.getMarker().getName()).add("logger", this.isIncluded(EventAttribute.LOGGER_NAME), event::getLoggerName).add("message", this.isIncluded(EventAttribute.MESSAGE), event::getFormattedMessage).add("context", this.isIncluded(EventAttribute.CONTEXT_NAME), () -> event.getLoggerContextVO().getName()).add("version", this.jsonProtocolVersion != null, this.jsonProtocolVersion).add("exception", this.isIncluded(EventAttribute.EXCEPTION) && event.getThrowableProxy() != null, () -> this.throwableProxyConverter.convert(event));
        boolean includeMdc = this.isIncluded(EventAttribute.MDC);
        if (this.flattenMdc) {
            this.filterMdc(event.getMDCPropertyMap()).forEach((k, v) -> mapBuilder.add((String)k, includeMdc, (String)v));
        } else {
            mapBuilder.addMap("mdc", includeMdc, () -> this.filterMdc(event.getMDCPropertyMap()));
        }
        boolean includeCallerData = this.isIncluded(EventAttribute.CALLER_DATA);
        StackTraceElement[] callerData = event.getCallerData();
        if (includeCallerData && callerData.length >= 1) {
            StackTraceElement stackTraceElement = callerData[0];
            mapBuilder.add("caller_class_name", includeCallerData, stackTraceElement.getClassName());
            mapBuilder.add("caller_method_name", includeCallerData, stackTraceElement.getMethodName());
            mapBuilder.add("caller_file_name", includeCallerData, stackTraceElement.getFileName());
            mapBuilder.addNumber("caller_line_number", includeCallerData, stackTraceElement.getLineNumber());
        }
        return mapBuilder.build();
    }

    private Map<String, String> filterMdc(Map<String, String> mdcPropertyMap) {
        if (this.includesMdcKeys.isEmpty()) {
            return mdcPropertyMap;
        }
        return mdcPropertyMap.entrySet().stream().filter(e -> this.includesMdcKeys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isIncluded(EventAttribute include) {
        return this.includes.contains((Object)include);
    }

    public Set<EventAttribute> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<EventAttribute> includes) {
        this.includes = EnumSet.copyOf(includes);
    }

    @Nullable
    public String getJsonProtocolVersion() {
        return this.jsonProtocolVersion;
    }

    public void setJsonProtocolVersion(@Nullable String jsonProtocolVersion) {
        this.jsonProtocolVersion = jsonProtocolVersion;
    }

    public Set<String> getIncludesMdcKeys() {
        return this.includesMdcKeys;
    }

    public void setIncludesMdcKeys(Set<String> includesMdcKeys) {
        this.includesMdcKeys = new HashSet<String>(includesMdcKeys);
    }
}

