/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseFormattedReporterFactory;
import java.io.PrintStream;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="console")
public class ConsoleReporterFactory
extends BaseFormattedReporterFactory {
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @NotNull
    private ConsoleStream output = ConsoleStream.STDOUT;

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty
    public ConsoleStream getOutput() {
        return this.output;
    }

    @JsonProperty
    public void setOutput(ConsoleStream stream) {
        this.output = stream;
    }

    @Override
    public ScheduledReporter build(MetricRegistry registry) {
        return ConsoleReporter.forRegistry(registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).formattedFor(this.getLocale()).formattedFor(this.getTimeZone()).outputTo(this.getOutput().get()).disabledMetricAttributes(this.getDisabledAttributes()).build();
    }

    public static enum ConsoleStream {
        STDOUT,
        STDERR;


        public PrintStream get() {
            if (this == STDERR) {
                return System.err;
            }
            return System.out;
        }
    }
}

