/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;
    private static final Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !MethodArgumentsProvider.isTestMethod(method);

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Class<?> testClass = context.getRequiredTestClass();
        Method testMethod = context.getRequiredTestMethod();
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> MethodArgumentsProvider.findFactoryMethod(testClass, testMethod, factoryMethodName)).map(factoryMethod -> context.getExecutableInvoker().invoke((Method)factoryMethod, (Object)testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private static Method findFactoryMethod(Class<?> testClass, Method testMethod, String factoryMethodName) {
        String originalFactoryMethodName = factoryMethodName;
        if (StringUtils.isBlank(factoryMethodName)) {
            factoryMethodName = testMethod.getName();
            return MethodArgumentsProvider.findFactoryMethodBySimpleName(testClass, testMethod, factoryMethodName);
        }
        if (!MethodArgumentsProvider.looksLikeAFullyQualifiedMethodName(factoryMethodName)) {
            factoryMethodName = testClass.getName() + "#" + factoryMethodName;
        }
        Method factoryMethod = MethodArgumentsProvider.findFactoryMethodByFullyQualifiedName(testMethod, factoryMethodName);
        Preconditions.condition(isFactoryMethod.test(factoryMethod), () -> String.format("Could not find valid factory method [%s] for test class [%s] but found the following invalid candidate: %s", originalFactoryMethodName, testClass.getName(), factoryMethod));
        return factoryMethod;
    }

    private static boolean looksLikeAFullyQualifiedMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            return true;
        }
        int indexOfDot = factoryMethodName.indexOf(".");
        if (indexOfDot == -1) {
            return false;
        }
        int indexOfOpeningParenthesis = factoryMethodName.indexOf("(");
        if (indexOfOpeningParenthesis > 0) {
            return indexOfDot < indexOfOpeningParenthesis;
        }
        return true;
    }

    private static Method findFactoryMethodByFullyQualifiedName(Method testMethod, String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        Class<?> clazz = MethodArgumentsProvider.loadRequiredClass(className);
        Method factoryMethod = ReflectionUtils.findMethod(clazz, methodName, methodParameters).orElse(null);
        if (factoryMethod != null) {
            return factoryMethod;
        }
        boolean explicitParameterListSpecified = StringUtils.isNotBlank(methodParameters) || fullyQualifiedMethodName.endsWith("()");
        Preconditions.condition(!explicitParameterListSpecified, () -> String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className));
        return MethodArgumentsProvider.findFactoryMethodBySimpleName(clazz, testMethod, methodName);
    }

    private static Method findFactoryMethodBySimpleName(Class<?> clazz, Method testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !testMethod.equals(candidate);
        List<Method> candidates = ReflectionUtils.findMethods(clazz, isCandidate);
        List factoryMethods = candidates.stream().filter(isFactoryMethod).collect(Collectors.toList());
        Preconditions.condition(factoryMethods.size() > 0, () -> {
            if (candidates.size() > 0) {
                return String.format("Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s", factoryMethodName, clazz.getName(), candidates);
            }
            return String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, clazz.getName());
        });
        Preconditions.condition(factoryMethods.size() == 1, () -> String.format("%d factory methods named [%s] were found in class [%s]: %s", factoryMethods.size(), factoryMethodName, clazz.getName(), factoryMethods));
        return (Method)factoryMethods.get(0);
    }

    private static boolean isTestMethod(Method candidate) {
        return AnnotationUtils.isAnnotated(candidate, Test.class) || AnnotationUtils.isAnnotated(candidate, TestTemplate.class) || AnnotationUtils.isAnnotated(candidate, TestFactory.class);
    }

    private static Class<?> loadRequiredClass(String className) {
        return ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray(item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

