/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import gov.cms.fiss.pricers.common.api.validation.ValidProviderCcn;
import gov.cms.fiss.pricers.common.api.validation.ValidWageIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="Defines common provider-specific content.")
public abstract class BasicProviderData {
    @Schema(description="The core-based statistical area (CBSA) in which a facility is physically located.", example="10380")
    @ValidInputCbsa
    private String cbsaActualGeographicLocation;
    @Schema(description="The core-based statistical area (CBSA) to which a hospital has been reclassified due to its prevailing wage rates.", example="35")
    @ValidInputCbsa
    private String cbsaWageIndexLocation;
    @BigDecimalScale(scale=3)
    @DecimalMax(value="9.999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=3)
    @Schema(description="The provider's payment-to-cost ratio.", example="5.654")
    private @DecimalMax(value="9.999") @DecimalMin(value="0") @Digits(integer=1, fraction=3) BigDecimal costOfLivingAdjustment;
    @Pattern(regexp="\\d{5}", message="must be five digits")
    @Schema(description="The county code for the provider.", example="31153")
    private @Pattern(regexp="\\d{5}", message="must be five digits") String countyCode;
    @NotNull
    @Schema(description="The effective date of the provider's first payment system period, or for subsequent payment system periods, the effective date of a change to the PROV file. If a termination date is present for this record, the effective date must be equal to or less than the termination date.", example="2020-05-04")
    @StrictLocalDate
    private LocalDate effectiveDate;
    @Schema(description="The start date of the provider's fiscal year. Will be less than or equal to the effective date.", example="2019-10-01")
    @StrictLocalDate
    private LocalDate fiscalYearBeginDate;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate that a hospital meets criteria to receive higher payment per Medicare Modernization Act (MMA) or Hospital Outpatient Program (HOP) Quality Data Reporting Program (QDRP) quality requirements.", example="1")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String hospitalQualityIndicator;
    @Pattern(regexp="\\d{5}", message="must be five digits")
    @Schema(description="The provider's assigned intermediary number.", example="72934")
    private @Pattern(regexp="\\d{5}", message="must be five digits") String intermediaryNumber;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The Medicare Performance Adjustment (MPA) percentage calculated and published by the Centers for Medicare & Medicaid Services (CMS).", example="0.9876")
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal medicarePerformanceAdjustment;
    @BigDecimalScale(scale=3)
    @DecimalMax(value="9.999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=3)
    @Schema(description="The cost-to-charge ratio derived from the latest settled cost report and corresponding charge data from the billing file.", example="0.234")
    private @DecimalMax(value="9.999") @DecimalMin(value="0") @Digits(integer=1, fraction=3) BigDecimal operatingCostToChargeRatio;
    @ValidProviderCcn
    @Schema(description="The provider's CMS certification number.", example="32D125A874235")
    private String providerCcn;
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="This identifies providers that require special handling.", example="41")
    private @Pattern(regexp="\\d{2}", message="must be two digits") String providerType;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code that indicates the type of special payment provision that applies.", example="1")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String specialPaymentIndicator;
    @BigDecimalScale(scale=4)
    @Schema(description="The special wage index that certain providers may be assigned.", example="1.3452")
    @ValidWageIndex
    private BigDecimal specialWageIndex;
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The state code for the provider.", example="13")
    private @Pattern(regexp="\\d{2}", message="must be two digits") String stateCode;
    @BigDecimalScale(scale=4)
    @Schema(description="The supplemental wage index that certain providers may be assigned.", example="27.8972")
    @ValidWageIndex
    private BigDecimal supplementalWageIndex;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate the expected usage of the supplemental wage index.", example="2")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String supplementalWageIndexIndicator;
    @Schema(description="The date on which the reporting MAC ceased servicing the provider. Will be equal to or greater than the effective date.", example="2020-10-01")
    @StrictLocalDate
    private LocalDate terminationDate;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="If `Y`, indicates that the state is a waiver state, and that pricing is not calculated by PPS.", example="N")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String waiverIndicator;

    @Generated
    public String getCbsaActualGeographicLocation() {
        return this.cbsaActualGeographicLocation;
    }

    @Generated
    public String getCbsaWageIndexLocation() {
        return this.cbsaWageIndexLocation;
    }

    @Generated
    public BigDecimal getCostOfLivingAdjustment() {
        return this.costOfLivingAdjustment;
    }

    @Generated
    public String getCountyCode() {
        return this.countyCode;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public LocalDate getFiscalYearBeginDate() {
        return this.fiscalYearBeginDate;
    }

    @Generated
    public String getHospitalQualityIndicator() {
        return this.hospitalQualityIndicator;
    }

    @Generated
    public String getIntermediaryNumber() {
        return this.intermediaryNumber;
    }

    @Generated
    public BigDecimal getMedicarePerformanceAdjustment() {
        return this.medicarePerformanceAdjustment;
    }

    @Generated
    public BigDecimal getOperatingCostToChargeRatio() {
        return this.operatingCostToChargeRatio;
    }

    @Generated
    public String getProviderCcn() {
        return this.providerCcn;
    }

    @Generated
    public String getProviderType() {
        return this.providerType;
    }

    @Generated
    public String getSpecialPaymentIndicator() {
        return this.specialPaymentIndicator;
    }

    @Generated
    public BigDecimal getSpecialWageIndex() {
        return this.specialWageIndex;
    }

    @Generated
    public String getStateCode() {
        return this.stateCode;
    }

    @Generated
    public BigDecimal getSupplementalWageIndex() {
        return this.supplementalWageIndex;
    }

    @Generated
    public String getSupplementalWageIndexIndicator() {
        return this.supplementalWageIndexIndicator;
    }

    @Generated
    public LocalDate getTerminationDate() {
        return this.terminationDate;
    }

    @Generated
    public String getWaiverIndicator() {
        return this.waiverIndicator;
    }

    @Generated
    public void setCbsaActualGeographicLocation(String cbsaActualGeographicLocation) {
        this.cbsaActualGeographicLocation = cbsaActualGeographicLocation;
    }

    @Generated
    public void setCbsaWageIndexLocation(String cbsaWageIndexLocation) {
        this.cbsaWageIndexLocation = cbsaWageIndexLocation;
    }

    @Generated
    public void setCostOfLivingAdjustment(BigDecimal costOfLivingAdjustment) {
        this.costOfLivingAdjustment = costOfLivingAdjustment;
    }

    @Generated
    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    @Generated
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Generated
    public void setFiscalYearBeginDate(LocalDate fiscalYearBeginDate) {
        this.fiscalYearBeginDate = fiscalYearBeginDate;
    }

    @Generated
    public void setHospitalQualityIndicator(String hospitalQualityIndicator) {
        this.hospitalQualityIndicator = hospitalQualityIndicator;
    }

    @Generated
    public void setIntermediaryNumber(String intermediaryNumber) {
        this.intermediaryNumber = intermediaryNumber;
    }

    @Generated
    public void setMedicarePerformanceAdjustment(BigDecimal medicarePerformanceAdjustment) {
        this.medicarePerformanceAdjustment = medicarePerformanceAdjustment;
    }

    @Generated
    public void setOperatingCostToChargeRatio(BigDecimal operatingCostToChargeRatio) {
        this.operatingCostToChargeRatio = operatingCostToChargeRatio;
    }

    @Generated
    public void setProviderCcn(String providerCcn) {
        this.providerCcn = providerCcn;
    }

    @Generated
    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    @Generated
    public void setSpecialPaymentIndicator(String specialPaymentIndicator) {
        this.specialPaymentIndicator = specialPaymentIndicator;
    }

    @Generated
    public void setSpecialWageIndex(BigDecimal specialWageIndex) {
        this.specialWageIndex = specialWageIndex;
    }

    @Generated
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    @Generated
    public void setSupplementalWageIndex(BigDecimal supplementalWageIndex) {
        this.supplementalWageIndex = supplementalWageIndex;
    }

    @Generated
    public void setSupplementalWageIndexIndicator(String supplementalWageIndexIndicator) {
        this.supplementalWageIndexIndicator = supplementalWageIndexIndicator;
    }

    @Generated
    public void setTerminationDate(LocalDate terminationDate) {
        this.terminationDate = terminationDate;
    }

    @Generated
    public void setWaiverIndicator(String waiverIndicator) {
        this.waiverIndicator = waiverIndicator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicProviderData)) {
            return false;
        }
        BasicProviderData other = (BasicProviderData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cbsaActualGeographicLocation = this.getCbsaActualGeographicLocation();
        String other$cbsaActualGeographicLocation = other.getCbsaActualGeographicLocation();
        if (this$cbsaActualGeographicLocation == null ? other$cbsaActualGeographicLocation != null : !this$cbsaActualGeographicLocation.equals(other$cbsaActualGeographicLocation)) {
            return false;
        }
        String this$cbsaWageIndexLocation = this.getCbsaWageIndexLocation();
        String other$cbsaWageIndexLocation = other.getCbsaWageIndexLocation();
        if (this$cbsaWageIndexLocation == null ? other$cbsaWageIndexLocation != null : !this$cbsaWageIndexLocation.equals(other$cbsaWageIndexLocation)) {
            return false;
        }
        BigDecimal this$costOfLivingAdjustment = this.getCostOfLivingAdjustment();
        BigDecimal other$costOfLivingAdjustment = other.getCostOfLivingAdjustment();
        if (this$costOfLivingAdjustment == null ? other$costOfLivingAdjustment != null : !((Object)this$costOfLivingAdjustment).equals(other$costOfLivingAdjustment)) {
            return false;
        }
        String this$countyCode = this.getCountyCode();
        String other$countyCode = other.getCountyCode();
        if (this$countyCode == null ? other$countyCode != null : !this$countyCode.equals(other$countyCode)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        LocalDate this$fiscalYearBeginDate = this.getFiscalYearBeginDate();
        LocalDate other$fiscalYearBeginDate = other.getFiscalYearBeginDate();
        if (this$fiscalYearBeginDate == null ? other$fiscalYearBeginDate != null : !((Object)this$fiscalYearBeginDate).equals(other$fiscalYearBeginDate)) {
            return false;
        }
        String this$hospitalQualityIndicator = this.getHospitalQualityIndicator();
        String other$hospitalQualityIndicator = other.getHospitalQualityIndicator();
        if (this$hospitalQualityIndicator == null ? other$hospitalQualityIndicator != null : !this$hospitalQualityIndicator.equals(other$hospitalQualityIndicator)) {
            return false;
        }
        String this$intermediaryNumber = this.getIntermediaryNumber();
        String other$intermediaryNumber = other.getIntermediaryNumber();
        if (this$intermediaryNumber == null ? other$intermediaryNumber != null : !this$intermediaryNumber.equals(other$intermediaryNumber)) {
            return false;
        }
        BigDecimal this$medicarePerformanceAdjustment = this.getMedicarePerformanceAdjustment();
        BigDecimal other$medicarePerformanceAdjustment = other.getMedicarePerformanceAdjustment();
        if (this$medicarePerformanceAdjustment == null ? other$medicarePerformanceAdjustment != null : !((Object)this$medicarePerformanceAdjustment).equals(other$medicarePerformanceAdjustment)) {
            return false;
        }
        BigDecimal this$operatingCostToChargeRatio = this.getOperatingCostToChargeRatio();
        BigDecimal other$operatingCostToChargeRatio = other.getOperatingCostToChargeRatio();
        if (this$operatingCostToChargeRatio == null ? other$operatingCostToChargeRatio != null : !((Object)this$operatingCostToChargeRatio).equals(other$operatingCostToChargeRatio)) {
            return false;
        }
        String this$providerCcn = this.getProviderCcn();
        String other$providerCcn = other.getProviderCcn();
        if (this$providerCcn == null ? other$providerCcn != null : !this$providerCcn.equals(other$providerCcn)) {
            return false;
        }
        String this$providerType = this.getProviderType();
        String other$providerType = other.getProviderType();
        if (this$providerType == null ? other$providerType != null : !this$providerType.equals(other$providerType)) {
            return false;
        }
        String this$specialPaymentIndicator = this.getSpecialPaymentIndicator();
        String other$specialPaymentIndicator = other.getSpecialPaymentIndicator();
        if (this$specialPaymentIndicator == null ? other$specialPaymentIndicator != null : !this$specialPaymentIndicator.equals(other$specialPaymentIndicator)) {
            return false;
        }
        BigDecimal this$specialWageIndex = this.getSpecialWageIndex();
        BigDecimal other$specialWageIndex = other.getSpecialWageIndex();
        if (this$specialWageIndex == null ? other$specialWageIndex != null : !((Object)this$specialWageIndex).equals(other$specialWageIndex)) {
            return false;
        }
        String this$stateCode = this.getStateCode();
        String other$stateCode = other.getStateCode();
        if (this$stateCode == null ? other$stateCode != null : !this$stateCode.equals(other$stateCode)) {
            return false;
        }
        BigDecimal this$supplementalWageIndex = this.getSupplementalWageIndex();
        BigDecimal other$supplementalWageIndex = other.getSupplementalWageIndex();
        if (this$supplementalWageIndex == null ? other$supplementalWageIndex != null : !((Object)this$supplementalWageIndex).equals(other$supplementalWageIndex)) {
            return false;
        }
        String this$supplementalWageIndexIndicator = this.getSupplementalWageIndexIndicator();
        String other$supplementalWageIndexIndicator = other.getSupplementalWageIndexIndicator();
        if (this$supplementalWageIndexIndicator == null ? other$supplementalWageIndexIndicator != null : !this$supplementalWageIndexIndicator.equals(other$supplementalWageIndexIndicator)) {
            return false;
        }
        LocalDate this$terminationDate = this.getTerminationDate();
        LocalDate other$terminationDate = other.getTerminationDate();
        if (this$terminationDate == null ? other$terminationDate != null : !((Object)this$terminationDate).equals(other$terminationDate)) {
            return false;
        }
        String this$waiverIndicator = this.getWaiverIndicator();
        String other$waiverIndicator = other.getWaiverIndicator();
        return !(this$waiverIndicator == null ? other$waiverIndicator != null : !this$waiverIndicator.equals(other$waiverIndicator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicProviderData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cbsaActualGeographicLocation = this.getCbsaActualGeographicLocation();
        result = result * 59 + ($cbsaActualGeographicLocation == null ? 43 : $cbsaActualGeographicLocation.hashCode());
        String $cbsaWageIndexLocation = this.getCbsaWageIndexLocation();
        result = result * 59 + ($cbsaWageIndexLocation == null ? 43 : $cbsaWageIndexLocation.hashCode());
        BigDecimal $costOfLivingAdjustment = this.getCostOfLivingAdjustment();
        result = result * 59 + ($costOfLivingAdjustment == null ? 43 : ((Object)$costOfLivingAdjustment).hashCode());
        String $countyCode = this.getCountyCode();
        result = result * 59 + ($countyCode == null ? 43 : $countyCode.hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        LocalDate $fiscalYearBeginDate = this.getFiscalYearBeginDate();
        result = result * 59 + ($fiscalYearBeginDate == null ? 43 : ((Object)$fiscalYearBeginDate).hashCode());
        String $hospitalQualityIndicator = this.getHospitalQualityIndicator();
        result = result * 59 + ($hospitalQualityIndicator == null ? 43 : $hospitalQualityIndicator.hashCode());
        String $intermediaryNumber = this.getIntermediaryNumber();
        result = result * 59 + ($intermediaryNumber == null ? 43 : $intermediaryNumber.hashCode());
        BigDecimal $medicarePerformanceAdjustment = this.getMedicarePerformanceAdjustment();
        result = result * 59 + ($medicarePerformanceAdjustment == null ? 43 : ((Object)$medicarePerformanceAdjustment).hashCode());
        BigDecimal $operatingCostToChargeRatio = this.getOperatingCostToChargeRatio();
        result = result * 59 + ($operatingCostToChargeRatio == null ? 43 : ((Object)$operatingCostToChargeRatio).hashCode());
        String $providerCcn = this.getProviderCcn();
        result = result * 59 + ($providerCcn == null ? 43 : $providerCcn.hashCode());
        String $providerType = this.getProviderType();
        result = result * 59 + ($providerType == null ? 43 : $providerType.hashCode());
        String $specialPaymentIndicator = this.getSpecialPaymentIndicator();
        result = result * 59 + ($specialPaymentIndicator == null ? 43 : $specialPaymentIndicator.hashCode());
        BigDecimal $specialWageIndex = this.getSpecialWageIndex();
        result = result * 59 + ($specialWageIndex == null ? 43 : ((Object)$specialWageIndex).hashCode());
        String $stateCode = this.getStateCode();
        result = result * 59 + ($stateCode == null ? 43 : $stateCode.hashCode());
        BigDecimal $supplementalWageIndex = this.getSupplementalWageIndex();
        result = result * 59 + ($supplementalWageIndex == null ? 43 : ((Object)$supplementalWageIndex).hashCode());
        String $supplementalWageIndexIndicator = this.getSupplementalWageIndexIndicator();
        result = result * 59 + ($supplementalWageIndexIndicator == null ? 43 : $supplementalWageIndexIndicator.hashCode());
        LocalDate $terminationDate = this.getTerminationDate();
        result = result * 59 + ($terminationDate == null ? 43 : ((Object)$terminationDate).hashCode());
        String $waiverIndicator = this.getWaiverIndicator();
        result = result * 59 + ($waiverIndicator == null ? 43 : $waiverIndicator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BasicProviderData(cbsaActualGeographicLocation=" + this.getCbsaActualGeographicLocation() + ", cbsaWageIndexLocation=" + this.getCbsaWageIndexLocation() + ", costOfLivingAdjustment=" + this.getCostOfLivingAdjustment() + ", countyCode=" + this.getCountyCode() + ", effectiveDate=" + this.getEffectiveDate() + ", fiscalYearBeginDate=" + this.getFiscalYearBeginDate() + ", hospitalQualityIndicator=" + this.getHospitalQualityIndicator() + ", intermediaryNumber=" + this.getIntermediaryNumber() + ", medicarePerformanceAdjustment=" + this.getMedicarePerformanceAdjustment() + ", operatingCostToChargeRatio=" + this.getOperatingCostToChargeRatio() + ", providerCcn=" + this.getProviderCcn() + ", providerType=" + this.getProviderType() + ", specialPaymentIndicator=" + this.getSpecialPaymentIndicator() + ", specialWageIndex=" + this.getSpecialWageIndex() + ", stateCode=" + this.getStateCode() + ", supplementalWageIndex=" + this.getSupplementalWageIndex() + ", supplementalWageIndexIndicator=" + this.getSupplementalWageIndexIndicator() + ", terminationDate=" + this.getTerminationDate() + ", waiverIndicator=" + this.getWaiverIndicator() + ")";
    }

    @Generated
    public BasicProviderData() {
    }
}

