/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.BasicProviderData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="Inpatient provider-specific data used in claim price calculations. Entries become valid on the date indicated in the `effectiveDate` field and remain in effect until superseded by an entry with a later effective date.")
public class InpatientProviderData
extends BasicProviderData {
    @Max(value=99999L)
    @Min(value=0L)
    @Schema(description="The number of adult hospital beds and pediatric beds available for lodging inpatient.", example="250")
    private @Max(value=99999L) @Min(value=0L) Integer bedSize;
    @BigDecimalScale(scale=3)
    @DecimalMax(value="9.999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=3)
    @Schema(description="The discount % for hospitals participating in Bundled Payments for Care Improvement Initiative (BPCI), Model 1.", example="0.827")
    private @DecimalMax(value="9.999") @DecimalMin(value="0") @Digits(integer=1, fraction=3) BigDecimal bundleModel1Discount;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The cost-to-charge ratio derived from the latest cost report and corresponding charge data from the billing file. For hospitals for which the MAC is unable to compute a reasonable cost-to-charge ratio, it uses the appropriate statewide average cost-to-charge ratio calculated annually by CMS and published in the 'Federal Register.'", example="1.2543")
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal capitalCostToChargeRatio;
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The per-discharge exception payment to which a hospital is entitled.", example="782.44")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal capitalExceptionPaymentRate;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The ratio of residents/interns to the hospital's average daily census.", example="2.3425")
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal capitalIndirectMedicalEducationRatio;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate the type of capital payment methodology for hospitals.", example="A")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String capitalPpsPaymentCode;
    @Schema(description="The CBSA to which a hospital has been reclassified.", example="10380")
    @ValidInputCbsa
    private String cbsaStandardizedAmountLocation;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="Indicates whether an electronic health record (EHR) reduction applies.", example="Y")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String ehrReductionIndicator;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate the federal PPS blend", example="7")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String federalPpsBlend;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="Indicates whether the provider participates in hospital-acquired condition (HAC) reduction.", example="Y")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String hacReductionParticipantIndicator;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The Hospital Readmissions Reduction adjustment factor.", example="1.0000")
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal hrrAdjustment;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate whether the provider participates in Hospital Readmissions Reduction (HRR).", example="1")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String hrrParticipantIndicator;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The provider's intern/resident to bed ratio.", example="0.2325")
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal internsToBedsRatio;
    @BigDecimalScale(scale=6)
    @DecimalMax(value="9.999999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=6)
    @Schema(description="The low-volume hospital payment adjustment factor calculated and published by the Centers for Medicare & Medicaid Services (CMS) for each eligible hospital.", example="9.872023")
    private @DecimalMax(value="9.999999") @DecimalMin(value="0") @Digits(integer=1, fraction=6) BigDecimal lowVolumeAdjustmentFactor;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate whether the discharge payment percentage should be calculated.", example="Y")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String ltchDppIndicator;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="0.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The Medicaid ratio used to determine if the hospital qualifies for a disproportionate share adjustment and to determine the size of the capital and operating DSH adjustments.", example="0.6543")
    private @DecimalMax(value="0.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal medicaidRatio;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate that a hospital is in its first two years of operation.", example="Y")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String newHospital;
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The hospital's allowable inpatient `old` capital costs per discharge incurred for assets acquired before December 31, 1990 for capital PPS.", example="782.44")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal oldCapitalHoldHarmlessRate;
    @BigDecimalScale
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital, including acquisition amounts for allogeneic stem cell transplants.", example="2789782.44")
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) BigDecimal passThroughAmountForAllogenicStemCellAcquisition;
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital for new or non-PPS hospitals.", example="234.13")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal passThroughAmountForCapital;
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital for direct medical education.", example="782.44")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal passThroughAmountForDirectMedicalEducation;
    @BigDecimalScale(scale=2, roundingMode=RoundingMode.HALF_UP)
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital. Include payment adjustments for the additional cost for procurement of wholly domestically made NIOSH-approved surgical N95 respirators.", example="12345.67")
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) BigDecimal passThroughAmountForSupplyChainCosts = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital for organ acquisition costs related to transplants.", example="234.13")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal passThroughAmountForOrganAcquisition;
    @BigDecimalScale
    @DecimalMax(value="9999.99")
    @DecimalMin(value="0")
    @Digits(integer=4, fraction=2)
    @Schema(description="The per diem amount based on the interim payments to the hospital, including standard acquisition amounts for kidney, heart, lung, pancreas, intestine and liver transplants.", example="234.13")
    private @DecimalMax(value="9999.99") @DecimalMin(value="0") @Digits(integer=4, fraction=2) BigDecimal passThroughTotalAmount;
    @BigDecimalScale
    @DecimalMax(value="99999.99")
    @DecimalMin(value="0")
    @Digits(integer=5, fraction=2)
    @Schema(description="The base year cost per discharge divided by the case mix index.", example="9872.23")
    private @DecimalMax(value="99999.99") @DecimalMin(value="0") @Digits(integer=5, fraction=2) BigDecimal ppsFacilitySpecificRate;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="0.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="The Supplemental Security Income (SSI) ratio used to determine if the hospital qualifies for a disproportionate share adjustment and to determine the size of the capital and operating DSH adjustments.", example="0.7866")
    private @DecimalMax(value="0.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal supplementalSecurityIncomeRatio;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="The code to indicate whether the provider qualifies for a payment update under the temporary relief provision.", example="Y")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String temporaryReliefIndicator;
    @BigDecimalScale
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @Schema(description="The estimated per discharge uncompensated care payment amount calculated and published by CMS for each hospital.", example="890745.23")
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) BigDecimal uncompensatedCareAmount;
    @BigDecimalScale(scale=11)
    @DecimalMax(value="9.99999999999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=11)
    @Schema(description="The Value-Based Purchasing (VBP) adjustment factor.", example="1.0000")
    private @DecimalMax(value="9.99999999999") @DecimalMin(value="0") @Digits(integer=1, fraction=11) BigDecimal vbpAdjustment;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="Indicates whether the provider participates in Value-Based Purchasing (VBP).", example="N")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String vbpParticipantIndicator;

    @Generated
    public Integer getBedSize() {
        return this.bedSize;
    }

    @Generated
    public BigDecimal getBundleModel1Discount() {
        return this.bundleModel1Discount;
    }

    @Generated
    public BigDecimal getCapitalCostToChargeRatio() {
        return this.capitalCostToChargeRatio;
    }

    @Generated
    public BigDecimal getCapitalExceptionPaymentRate() {
        return this.capitalExceptionPaymentRate;
    }

    @Generated
    public BigDecimal getCapitalIndirectMedicalEducationRatio() {
        return this.capitalIndirectMedicalEducationRatio;
    }

    @Generated
    public String getCapitalPpsPaymentCode() {
        return this.capitalPpsPaymentCode;
    }

    @Generated
    public String getCbsaStandardizedAmountLocation() {
        return this.cbsaStandardizedAmountLocation;
    }

    @Generated
    public String getEhrReductionIndicator() {
        return this.ehrReductionIndicator;
    }

    @Generated
    public String getFederalPpsBlend() {
        return this.federalPpsBlend;
    }

    @Generated
    public String getHacReductionParticipantIndicator() {
        return this.hacReductionParticipantIndicator;
    }

    @Generated
    public BigDecimal getHrrAdjustment() {
        return this.hrrAdjustment;
    }

    @Generated
    public String getHrrParticipantIndicator() {
        return this.hrrParticipantIndicator;
    }

    @Generated
    public BigDecimal getInternsToBedsRatio() {
        return this.internsToBedsRatio;
    }

    @Generated
    public BigDecimal getLowVolumeAdjustmentFactor() {
        return this.lowVolumeAdjustmentFactor;
    }

    @Generated
    public String getLtchDppIndicator() {
        return this.ltchDppIndicator;
    }

    @Generated
    public BigDecimal getMedicaidRatio() {
        return this.medicaidRatio;
    }

    @Generated
    public String getNewHospital() {
        return this.newHospital;
    }

    @Generated
    public BigDecimal getOldCapitalHoldHarmlessRate() {
        return this.oldCapitalHoldHarmlessRate;
    }

    @Generated
    public BigDecimal getPassThroughAmountForAllogenicStemCellAcquisition() {
        return this.passThroughAmountForAllogenicStemCellAcquisition;
    }

    @Generated
    public BigDecimal getPassThroughAmountForCapital() {
        return this.passThroughAmountForCapital;
    }

    @Generated
    public BigDecimal getPassThroughAmountForDirectMedicalEducation() {
        return this.passThroughAmountForDirectMedicalEducation;
    }

    @Generated
    public BigDecimal getPassThroughAmountForSupplyChainCosts() {
        return this.passThroughAmountForSupplyChainCosts;
    }

    @Generated
    public BigDecimal getPassThroughAmountForOrganAcquisition() {
        return this.passThroughAmountForOrganAcquisition;
    }

    @Generated
    public BigDecimal getPassThroughTotalAmount() {
        return this.passThroughTotalAmount;
    }

    @Generated
    public BigDecimal getPpsFacilitySpecificRate() {
        return this.ppsFacilitySpecificRate;
    }

    @Generated
    public BigDecimal getSupplementalSecurityIncomeRatio() {
        return this.supplementalSecurityIncomeRatio;
    }

    @Generated
    public String getTemporaryReliefIndicator() {
        return this.temporaryReliefIndicator;
    }

    @Generated
    public BigDecimal getUncompensatedCareAmount() {
        return this.uncompensatedCareAmount;
    }

    @Generated
    public BigDecimal getVbpAdjustment() {
        return this.vbpAdjustment;
    }

    @Generated
    public String getVbpParticipantIndicator() {
        return this.vbpParticipantIndicator;
    }

    @Generated
    public void setBedSize(Integer bedSize) {
        this.bedSize = bedSize;
    }

    @Generated
    public void setBundleModel1Discount(BigDecimal bundleModel1Discount) {
        this.bundleModel1Discount = bundleModel1Discount;
    }

    @Generated
    public void setCapitalCostToChargeRatio(BigDecimal capitalCostToChargeRatio) {
        this.capitalCostToChargeRatio = capitalCostToChargeRatio;
    }

    @Generated
    public void setCapitalExceptionPaymentRate(BigDecimal capitalExceptionPaymentRate) {
        this.capitalExceptionPaymentRate = capitalExceptionPaymentRate;
    }

    @Generated
    public void setCapitalIndirectMedicalEducationRatio(BigDecimal capitalIndirectMedicalEducationRatio) {
        this.capitalIndirectMedicalEducationRatio = capitalIndirectMedicalEducationRatio;
    }

    @Generated
    public void setCapitalPpsPaymentCode(String capitalPpsPaymentCode) {
        this.capitalPpsPaymentCode = capitalPpsPaymentCode;
    }

    @Generated
    public void setCbsaStandardizedAmountLocation(String cbsaStandardizedAmountLocation) {
        this.cbsaStandardizedAmountLocation = cbsaStandardizedAmountLocation;
    }

    @Generated
    public void setEhrReductionIndicator(String ehrReductionIndicator) {
        this.ehrReductionIndicator = ehrReductionIndicator;
    }

    @Generated
    public void setFederalPpsBlend(String federalPpsBlend) {
        this.federalPpsBlend = federalPpsBlend;
    }

    @Generated
    public void setHacReductionParticipantIndicator(String hacReductionParticipantIndicator) {
        this.hacReductionParticipantIndicator = hacReductionParticipantIndicator;
    }

    @Generated
    public void setHrrAdjustment(BigDecimal hrrAdjustment) {
        this.hrrAdjustment = hrrAdjustment;
    }

    @Generated
    public void setHrrParticipantIndicator(String hrrParticipantIndicator) {
        this.hrrParticipantIndicator = hrrParticipantIndicator;
    }

    @Generated
    public void setInternsToBedsRatio(BigDecimal internsToBedsRatio) {
        this.internsToBedsRatio = internsToBedsRatio;
    }

    @Generated
    public void setLowVolumeAdjustmentFactor(BigDecimal lowVolumeAdjustmentFactor) {
        this.lowVolumeAdjustmentFactor = lowVolumeAdjustmentFactor;
    }

    @Generated
    public void setLtchDppIndicator(String ltchDppIndicator) {
        this.ltchDppIndicator = ltchDppIndicator;
    }

    @Generated
    public void setMedicaidRatio(BigDecimal medicaidRatio) {
        this.medicaidRatio = medicaidRatio;
    }

    @Generated
    public void setNewHospital(String newHospital) {
        this.newHospital = newHospital;
    }

    @Generated
    public void setOldCapitalHoldHarmlessRate(BigDecimal oldCapitalHoldHarmlessRate) {
        this.oldCapitalHoldHarmlessRate = oldCapitalHoldHarmlessRate;
    }

    @Generated
    public void setPassThroughAmountForAllogenicStemCellAcquisition(BigDecimal passThroughAmountForAllogenicStemCellAcquisition) {
        this.passThroughAmountForAllogenicStemCellAcquisition = passThroughAmountForAllogenicStemCellAcquisition;
    }

    @Generated
    public void setPassThroughAmountForCapital(BigDecimal passThroughAmountForCapital) {
        this.passThroughAmountForCapital = passThroughAmountForCapital;
    }

    @Generated
    public void setPassThroughAmountForDirectMedicalEducation(BigDecimal passThroughAmountForDirectMedicalEducation) {
        this.passThroughAmountForDirectMedicalEducation = passThroughAmountForDirectMedicalEducation;
    }

    @Generated
    public void setPassThroughAmountForSupplyChainCosts(BigDecimal passThroughAmountForSupplyChainCosts) {
        this.passThroughAmountForSupplyChainCosts = passThroughAmountForSupplyChainCosts;
    }

    @Generated
    public void setPassThroughAmountForOrganAcquisition(BigDecimal passThroughAmountForOrganAcquisition) {
        this.passThroughAmountForOrganAcquisition = passThroughAmountForOrganAcquisition;
    }

    @Generated
    public void setPassThroughTotalAmount(BigDecimal passThroughTotalAmount) {
        this.passThroughTotalAmount = passThroughTotalAmount;
    }

    @Generated
    public void setPpsFacilitySpecificRate(BigDecimal ppsFacilitySpecificRate) {
        this.ppsFacilitySpecificRate = ppsFacilitySpecificRate;
    }

    @Generated
    public void setSupplementalSecurityIncomeRatio(BigDecimal supplementalSecurityIncomeRatio) {
        this.supplementalSecurityIncomeRatio = supplementalSecurityIncomeRatio;
    }

    @Generated
    public void setTemporaryReliefIndicator(String temporaryReliefIndicator) {
        this.temporaryReliefIndicator = temporaryReliefIndicator;
    }

    @Generated
    public void setUncompensatedCareAmount(BigDecimal uncompensatedCareAmount) {
        this.uncompensatedCareAmount = uncompensatedCareAmount;
    }

    @Generated
    public void setVbpAdjustment(BigDecimal vbpAdjustment) {
        this.vbpAdjustment = vbpAdjustment;
    }

    @Generated
    public void setVbpParticipantIndicator(String vbpParticipantIndicator) {
        this.vbpParticipantIndicator = vbpParticipantIndicator;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InpatientProviderData)) {
            return false;
        }
        InpatientProviderData other = (InpatientProviderData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$bedSize = this.getBedSize();
        Integer other$bedSize = other.getBedSize();
        if (this$bedSize == null ? other$bedSize != null : !((Object)this$bedSize).equals(other$bedSize)) {
            return false;
        }
        BigDecimal this$bundleModel1Discount = this.getBundleModel1Discount();
        BigDecimal other$bundleModel1Discount = other.getBundleModel1Discount();
        if (this$bundleModel1Discount == null ? other$bundleModel1Discount != null : !((Object)this$bundleModel1Discount).equals(other$bundleModel1Discount)) {
            return false;
        }
        BigDecimal this$capitalCostToChargeRatio = this.getCapitalCostToChargeRatio();
        BigDecimal other$capitalCostToChargeRatio = other.getCapitalCostToChargeRatio();
        if (this$capitalCostToChargeRatio == null ? other$capitalCostToChargeRatio != null : !((Object)this$capitalCostToChargeRatio).equals(other$capitalCostToChargeRatio)) {
            return false;
        }
        BigDecimal this$capitalExceptionPaymentRate = this.getCapitalExceptionPaymentRate();
        BigDecimal other$capitalExceptionPaymentRate = other.getCapitalExceptionPaymentRate();
        if (this$capitalExceptionPaymentRate == null ? other$capitalExceptionPaymentRate != null : !((Object)this$capitalExceptionPaymentRate).equals(other$capitalExceptionPaymentRate)) {
            return false;
        }
        BigDecimal this$capitalIndirectMedicalEducationRatio = this.getCapitalIndirectMedicalEducationRatio();
        BigDecimal other$capitalIndirectMedicalEducationRatio = other.getCapitalIndirectMedicalEducationRatio();
        if (this$capitalIndirectMedicalEducationRatio == null ? other$capitalIndirectMedicalEducationRatio != null : !((Object)this$capitalIndirectMedicalEducationRatio).equals(other$capitalIndirectMedicalEducationRatio)) {
            return false;
        }
        String this$capitalPpsPaymentCode = this.getCapitalPpsPaymentCode();
        String other$capitalPpsPaymentCode = other.getCapitalPpsPaymentCode();
        if (this$capitalPpsPaymentCode == null ? other$capitalPpsPaymentCode != null : !this$capitalPpsPaymentCode.equals(other$capitalPpsPaymentCode)) {
            return false;
        }
        String this$cbsaStandardizedAmountLocation = this.getCbsaStandardizedAmountLocation();
        String other$cbsaStandardizedAmountLocation = other.getCbsaStandardizedAmountLocation();
        if (this$cbsaStandardizedAmountLocation == null ? other$cbsaStandardizedAmountLocation != null : !this$cbsaStandardizedAmountLocation.equals(other$cbsaStandardizedAmountLocation)) {
            return false;
        }
        String this$ehrReductionIndicator = this.getEhrReductionIndicator();
        String other$ehrReductionIndicator = other.getEhrReductionIndicator();
        if (this$ehrReductionIndicator == null ? other$ehrReductionIndicator != null : !this$ehrReductionIndicator.equals(other$ehrReductionIndicator)) {
            return false;
        }
        String this$federalPpsBlend = this.getFederalPpsBlend();
        String other$federalPpsBlend = other.getFederalPpsBlend();
        if (this$federalPpsBlend == null ? other$federalPpsBlend != null : !this$federalPpsBlend.equals(other$federalPpsBlend)) {
            return false;
        }
        String this$hacReductionParticipantIndicator = this.getHacReductionParticipantIndicator();
        String other$hacReductionParticipantIndicator = other.getHacReductionParticipantIndicator();
        if (this$hacReductionParticipantIndicator == null ? other$hacReductionParticipantIndicator != null : !this$hacReductionParticipantIndicator.equals(other$hacReductionParticipantIndicator)) {
            return false;
        }
        BigDecimal this$hrrAdjustment = this.getHrrAdjustment();
        BigDecimal other$hrrAdjustment = other.getHrrAdjustment();
        if (this$hrrAdjustment == null ? other$hrrAdjustment != null : !((Object)this$hrrAdjustment).equals(other$hrrAdjustment)) {
            return false;
        }
        String this$hrrParticipantIndicator = this.getHrrParticipantIndicator();
        String other$hrrParticipantIndicator = other.getHrrParticipantIndicator();
        if (this$hrrParticipantIndicator == null ? other$hrrParticipantIndicator != null : !this$hrrParticipantIndicator.equals(other$hrrParticipantIndicator)) {
            return false;
        }
        BigDecimal this$internsToBedsRatio = this.getInternsToBedsRatio();
        BigDecimal other$internsToBedsRatio = other.getInternsToBedsRatio();
        if (this$internsToBedsRatio == null ? other$internsToBedsRatio != null : !((Object)this$internsToBedsRatio).equals(other$internsToBedsRatio)) {
            return false;
        }
        BigDecimal this$lowVolumeAdjustmentFactor = this.getLowVolumeAdjustmentFactor();
        BigDecimal other$lowVolumeAdjustmentFactor = other.getLowVolumeAdjustmentFactor();
        if (this$lowVolumeAdjustmentFactor == null ? other$lowVolumeAdjustmentFactor != null : !((Object)this$lowVolumeAdjustmentFactor).equals(other$lowVolumeAdjustmentFactor)) {
            return false;
        }
        String this$ltchDppIndicator = this.getLtchDppIndicator();
        String other$ltchDppIndicator = other.getLtchDppIndicator();
        if (this$ltchDppIndicator == null ? other$ltchDppIndicator != null : !this$ltchDppIndicator.equals(other$ltchDppIndicator)) {
            return false;
        }
        BigDecimal this$medicaidRatio = this.getMedicaidRatio();
        BigDecimal other$medicaidRatio = other.getMedicaidRatio();
        if (this$medicaidRatio == null ? other$medicaidRatio != null : !((Object)this$medicaidRatio).equals(other$medicaidRatio)) {
            return false;
        }
        String this$newHospital = this.getNewHospital();
        String other$newHospital = other.getNewHospital();
        if (this$newHospital == null ? other$newHospital != null : !this$newHospital.equals(other$newHospital)) {
            return false;
        }
        BigDecimal this$oldCapitalHoldHarmlessRate = this.getOldCapitalHoldHarmlessRate();
        BigDecimal other$oldCapitalHoldHarmlessRate = other.getOldCapitalHoldHarmlessRate();
        if (this$oldCapitalHoldHarmlessRate == null ? other$oldCapitalHoldHarmlessRate != null : !((Object)this$oldCapitalHoldHarmlessRate).equals(other$oldCapitalHoldHarmlessRate)) {
            return false;
        }
        BigDecimal this$passThroughAmountForAllogenicStemCellAcquisition = this.getPassThroughAmountForAllogenicStemCellAcquisition();
        BigDecimal other$passThroughAmountForAllogenicStemCellAcquisition = other.getPassThroughAmountForAllogenicStemCellAcquisition();
        if (this$passThroughAmountForAllogenicStemCellAcquisition == null ? other$passThroughAmountForAllogenicStemCellAcquisition != null : !((Object)this$passThroughAmountForAllogenicStemCellAcquisition).equals(other$passThroughAmountForAllogenicStemCellAcquisition)) {
            return false;
        }
        BigDecimal this$passThroughAmountForCapital = this.getPassThroughAmountForCapital();
        BigDecimal other$passThroughAmountForCapital = other.getPassThroughAmountForCapital();
        if (this$passThroughAmountForCapital == null ? other$passThroughAmountForCapital != null : !((Object)this$passThroughAmountForCapital).equals(other$passThroughAmountForCapital)) {
            return false;
        }
        BigDecimal this$passThroughAmountForDirectMedicalEducation = this.getPassThroughAmountForDirectMedicalEducation();
        BigDecimal other$passThroughAmountForDirectMedicalEducation = other.getPassThroughAmountForDirectMedicalEducation();
        if (this$passThroughAmountForDirectMedicalEducation == null ? other$passThroughAmountForDirectMedicalEducation != null : !((Object)this$passThroughAmountForDirectMedicalEducation).equals(other$passThroughAmountForDirectMedicalEducation)) {
            return false;
        }
        BigDecimal this$passThroughAmountForSupplyChainCosts = this.getPassThroughAmountForSupplyChainCosts();
        BigDecimal other$passThroughAmountForSupplyChainCosts = other.getPassThroughAmountForSupplyChainCosts();
        if (this$passThroughAmountForSupplyChainCosts == null ? other$passThroughAmountForSupplyChainCosts != null : !((Object)this$passThroughAmountForSupplyChainCosts).equals(other$passThroughAmountForSupplyChainCosts)) {
            return false;
        }
        BigDecimal this$passThroughAmountForOrganAcquisition = this.getPassThroughAmountForOrganAcquisition();
        BigDecimal other$passThroughAmountForOrganAcquisition = other.getPassThroughAmountForOrganAcquisition();
        if (this$passThroughAmountForOrganAcquisition == null ? other$passThroughAmountForOrganAcquisition != null : !((Object)this$passThroughAmountForOrganAcquisition).equals(other$passThroughAmountForOrganAcquisition)) {
            return false;
        }
        BigDecimal this$passThroughTotalAmount = this.getPassThroughTotalAmount();
        BigDecimal other$passThroughTotalAmount = other.getPassThroughTotalAmount();
        if (this$passThroughTotalAmount == null ? other$passThroughTotalAmount != null : !((Object)this$passThroughTotalAmount).equals(other$passThroughTotalAmount)) {
            return false;
        }
        BigDecimal this$ppsFacilitySpecificRate = this.getPpsFacilitySpecificRate();
        BigDecimal other$ppsFacilitySpecificRate = other.getPpsFacilitySpecificRate();
        if (this$ppsFacilitySpecificRate == null ? other$ppsFacilitySpecificRate != null : !((Object)this$ppsFacilitySpecificRate).equals(other$ppsFacilitySpecificRate)) {
            return false;
        }
        BigDecimal this$supplementalSecurityIncomeRatio = this.getSupplementalSecurityIncomeRatio();
        BigDecimal other$supplementalSecurityIncomeRatio = other.getSupplementalSecurityIncomeRatio();
        if (this$supplementalSecurityIncomeRatio == null ? other$supplementalSecurityIncomeRatio != null : !((Object)this$supplementalSecurityIncomeRatio).equals(other$supplementalSecurityIncomeRatio)) {
            return false;
        }
        String this$temporaryReliefIndicator = this.getTemporaryReliefIndicator();
        String other$temporaryReliefIndicator = other.getTemporaryReliefIndicator();
        if (this$temporaryReliefIndicator == null ? other$temporaryReliefIndicator != null : !this$temporaryReliefIndicator.equals(other$temporaryReliefIndicator)) {
            return false;
        }
        BigDecimal this$uncompensatedCareAmount = this.getUncompensatedCareAmount();
        BigDecimal other$uncompensatedCareAmount = other.getUncompensatedCareAmount();
        if (this$uncompensatedCareAmount == null ? other$uncompensatedCareAmount != null : !((Object)this$uncompensatedCareAmount).equals(other$uncompensatedCareAmount)) {
            return false;
        }
        BigDecimal this$vbpAdjustment = this.getVbpAdjustment();
        BigDecimal other$vbpAdjustment = other.getVbpAdjustment();
        if (this$vbpAdjustment == null ? other$vbpAdjustment != null : !((Object)this$vbpAdjustment).equals(other$vbpAdjustment)) {
            return false;
        }
        String this$vbpParticipantIndicator = this.getVbpParticipantIndicator();
        String other$vbpParticipantIndicator = other.getVbpParticipantIndicator();
        return !(this$vbpParticipantIndicator == null ? other$vbpParticipantIndicator != null : !this$vbpParticipantIndicator.equals(other$vbpParticipantIndicator));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InpatientProviderData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $bedSize = this.getBedSize();
        result = result * 59 + ($bedSize == null ? 43 : ((Object)$bedSize).hashCode());
        BigDecimal $bundleModel1Discount = this.getBundleModel1Discount();
        result = result * 59 + ($bundleModel1Discount == null ? 43 : ((Object)$bundleModel1Discount).hashCode());
        BigDecimal $capitalCostToChargeRatio = this.getCapitalCostToChargeRatio();
        result = result * 59 + ($capitalCostToChargeRatio == null ? 43 : ((Object)$capitalCostToChargeRatio).hashCode());
        BigDecimal $capitalExceptionPaymentRate = this.getCapitalExceptionPaymentRate();
        result = result * 59 + ($capitalExceptionPaymentRate == null ? 43 : ((Object)$capitalExceptionPaymentRate).hashCode());
        BigDecimal $capitalIndirectMedicalEducationRatio = this.getCapitalIndirectMedicalEducationRatio();
        result = result * 59 + ($capitalIndirectMedicalEducationRatio == null ? 43 : ((Object)$capitalIndirectMedicalEducationRatio).hashCode());
        String $capitalPpsPaymentCode = this.getCapitalPpsPaymentCode();
        result = result * 59 + ($capitalPpsPaymentCode == null ? 43 : $capitalPpsPaymentCode.hashCode());
        String $cbsaStandardizedAmountLocation = this.getCbsaStandardizedAmountLocation();
        result = result * 59 + ($cbsaStandardizedAmountLocation == null ? 43 : $cbsaStandardizedAmountLocation.hashCode());
        String $ehrReductionIndicator = this.getEhrReductionIndicator();
        result = result * 59 + ($ehrReductionIndicator == null ? 43 : $ehrReductionIndicator.hashCode());
        String $federalPpsBlend = this.getFederalPpsBlend();
        result = result * 59 + ($federalPpsBlend == null ? 43 : $federalPpsBlend.hashCode());
        String $hacReductionParticipantIndicator = this.getHacReductionParticipantIndicator();
        result = result * 59 + ($hacReductionParticipantIndicator == null ? 43 : $hacReductionParticipantIndicator.hashCode());
        BigDecimal $hrrAdjustment = this.getHrrAdjustment();
        result = result * 59 + ($hrrAdjustment == null ? 43 : ((Object)$hrrAdjustment).hashCode());
        String $hrrParticipantIndicator = this.getHrrParticipantIndicator();
        result = result * 59 + ($hrrParticipantIndicator == null ? 43 : $hrrParticipantIndicator.hashCode());
        BigDecimal $internsToBedsRatio = this.getInternsToBedsRatio();
        result = result * 59 + ($internsToBedsRatio == null ? 43 : ((Object)$internsToBedsRatio).hashCode());
        BigDecimal $lowVolumeAdjustmentFactor = this.getLowVolumeAdjustmentFactor();
        result = result * 59 + ($lowVolumeAdjustmentFactor == null ? 43 : ((Object)$lowVolumeAdjustmentFactor).hashCode());
        String $ltchDppIndicator = this.getLtchDppIndicator();
        result = result * 59 + ($ltchDppIndicator == null ? 43 : $ltchDppIndicator.hashCode());
        BigDecimal $medicaidRatio = this.getMedicaidRatio();
        result = result * 59 + ($medicaidRatio == null ? 43 : ((Object)$medicaidRatio).hashCode());
        String $newHospital = this.getNewHospital();
        result = result * 59 + ($newHospital == null ? 43 : $newHospital.hashCode());
        BigDecimal $oldCapitalHoldHarmlessRate = this.getOldCapitalHoldHarmlessRate();
        result = result * 59 + ($oldCapitalHoldHarmlessRate == null ? 43 : ((Object)$oldCapitalHoldHarmlessRate).hashCode());
        BigDecimal $passThroughAmountForAllogenicStemCellAcquisition = this.getPassThroughAmountForAllogenicStemCellAcquisition();
        result = result * 59 + ($passThroughAmountForAllogenicStemCellAcquisition == null ? 43 : ((Object)$passThroughAmountForAllogenicStemCellAcquisition).hashCode());
        BigDecimal $passThroughAmountForCapital = this.getPassThroughAmountForCapital();
        result = result * 59 + ($passThroughAmountForCapital == null ? 43 : ((Object)$passThroughAmountForCapital).hashCode());
        BigDecimal $passThroughAmountForDirectMedicalEducation = this.getPassThroughAmountForDirectMedicalEducation();
        result = result * 59 + ($passThroughAmountForDirectMedicalEducation == null ? 43 : ((Object)$passThroughAmountForDirectMedicalEducation).hashCode());
        BigDecimal $passThroughAmountForSupplyChainCosts = this.getPassThroughAmountForSupplyChainCosts();
        result = result * 59 + ($passThroughAmountForSupplyChainCosts == null ? 43 : ((Object)$passThroughAmountForSupplyChainCosts).hashCode());
        BigDecimal $passThroughAmountForOrganAcquisition = this.getPassThroughAmountForOrganAcquisition();
        result = result * 59 + ($passThroughAmountForOrganAcquisition == null ? 43 : ((Object)$passThroughAmountForOrganAcquisition).hashCode());
        BigDecimal $passThroughTotalAmount = this.getPassThroughTotalAmount();
        result = result * 59 + ($passThroughTotalAmount == null ? 43 : ((Object)$passThroughTotalAmount).hashCode());
        BigDecimal $ppsFacilitySpecificRate = this.getPpsFacilitySpecificRate();
        result = result * 59 + ($ppsFacilitySpecificRate == null ? 43 : ((Object)$ppsFacilitySpecificRate).hashCode());
        BigDecimal $supplementalSecurityIncomeRatio = this.getSupplementalSecurityIncomeRatio();
        result = result * 59 + ($supplementalSecurityIncomeRatio == null ? 43 : ((Object)$supplementalSecurityIncomeRatio).hashCode());
        String $temporaryReliefIndicator = this.getTemporaryReliefIndicator();
        result = result * 59 + ($temporaryReliefIndicator == null ? 43 : $temporaryReliefIndicator.hashCode());
        BigDecimal $uncompensatedCareAmount = this.getUncompensatedCareAmount();
        result = result * 59 + ($uncompensatedCareAmount == null ? 43 : ((Object)$uncompensatedCareAmount).hashCode());
        BigDecimal $vbpAdjustment = this.getVbpAdjustment();
        result = result * 59 + ($vbpAdjustment == null ? 43 : ((Object)$vbpAdjustment).hashCode());
        String $vbpParticipantIndicator = this.getVbpParticipantIndicator();
        result = result * 59 + ($vbpParticipantIndicator == null ? 43 : $vbpParticipantIndicator.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "InpatientProviderData(bedSize=" + this.getBedSize() + ", bundleModel1Discount=" + this.getBundleModel1Discount() + ", capitalCostToChargeRatio=" + this.getCapitalCostToChargeRatio() + ", capitalExceptionPaymentRate=" + this.getCapitalExceptionPaymentRate() + ", capitalIndirectMedicalEducationRatio=" + this.getCapitalIndirectMedicalEducationRatio() + ", capitalPpsPaymentCode=" + this.getCapitalPpsPaymentCode() + ", cbsaStandardizedAmountLocation=" + this.getCbsaStandardizedAmountLocation() + ", ehrReductionIndicator=" + this.getEhrReductionIndicator() + ", federalPpsBlend=" + this.getFederalPpsBlend() + ", hacReductionParticipantIndicator=" + this.getHacReductionParticipantIndicator() + ", hrrAdjustment=" + this.getHrrAdjustment() + ", hrrParticipantIndicator=" + this.getHrrParticipantIndicator() + ", internsToBedsRatio=" + this.getInternsToBedsRatio() + ", lowVolumeAdjustmentFactor=" + this.getLowVolumeAdjustmentFactor() + ", ltchDppIndicator=" + this.getLtchDppIndicator() + ", medicaidRatio=" + this.getMedicaidRatio() + ", newHospital=" + this.getNewHospital() + ", oldCapitalHoldHarmlessRate=" + this.getOldCapitalHoldHarmlessRate() + ", passThroughAmountForAllogenicStemCellAcquisition=" + this.getPassThroughAmountForAllogenicStemCellAcquisition() + ", passThroughAmountForCapital=" + this.getPassThroughAmountForCapital() + ", passThroughAmountForDirectMedicalEducation=" + this.getPassThroughAmountForDirectMedicalEducation() + ", passThroughAmountForSupplyChainCosts=" + this.getPassThroughAmountForSupplyChainCosts() + ", passThroughAmountForOrganAcquisition=" + this.getPassThroughAmountForOrganAcquisition() + ", passThroughTotalAmount=" + this.getPassThroughTotalAmount() + ", ppsFacilitySpecificRate=" + this.getPpsFacilitySpecificRate() + ", supplementalSecurityIncomeRatio=" + this.getSupplementalSecurityIncomeRatio() + ", temporaryReliefIndicator=" + this.getTemporaryReliefIndicator() + ", uncompensatedCareAmount=" + this.getUncompensatedCareAmount() + ", vbpAdjustment=" + this.getVbpAdjustment() + ", vbpParticipantIndicator=" + this.getVbpParticipantIndicator() + ")";
    }

    @Generated
    public InpatientProviderData() {
    }
}

