/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.hha.HhaPricerConfiguration;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.core.Hha2020RulePricer;
import gov.cms.fiss.pricers.hha.core.Hha2021RulePricer;
import gov.cms.fiss.pricers.hha.core.Hha2022RulePricer;
import gov.cms.fiss.pricers.hha.core.Hha2023RulePricer;
import gov.cms.fiss.pricers.hha.core.Hha2024RulePricer;
import gov.cms.fiss.pricers.hha.core.Hha2025RulePricer;
import gov.cms.fiss.pricers.hha.core.tables.DataTables;
import java.time.LocalDate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HhaPricerDispatch
extends PricerDispatch<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HhaPricerDispatch.class);

    public HhaPricerDispatch(HhaPricerConfiguration configuration) {
        super(configuration, o -> o.getReturnCodeData().getCode());
    }

    @Override
    protected void initializeReferences(HhaPricerConfiguration pricerConfiguration) {
        DataTables.loadDataTables(pricerConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            switch (supportedYear) {
                case 2020: {
                    this.yearReference.register(supportedYear, Hha2020RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2021: {
                    this.yearReference.register(supportedYear, Hha2021RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2022: {
                    this.yearReference.register(supportedYear, Hha2022RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2023: {
                    this.yearReference.register(supportedYear, Hha2023RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2024: {
                    this.yearReference.register(supportedYear, Hha2024RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2025: {
                    this.yearReference.register(supportedYear, Hha2025RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
            }
        }
    }

    @Override
    protected ClaimProcessor<HhaClaimPricingRequest, HhaClaimPricingResponse> getProcessor(HhaClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
        HhaClaimData claimData = (HhaClaimData)input.getClaimData();
        LocalDate serviceThroughDate = claimData.getServiceThroughDate();
        if (serviceThroughDate.getYear() > 2020) {
            return this.yearReference.fromCalendarYear(serviceThroughDate, "serviceThroughDate");
        }
        return this.yearReference.fromCalendarYear(claimData.getServiceFromDate(), "serviceFromDate");
    }

    @Override
    protected boolean isErrorOutput(HhaClaimPricingResponse output) {
        int resultCode = Integer.parseInt(output.getReturnCodeData().getCode());
        return resultCode >= 15 || resultCode == 10;
    }
}

