/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.hha.core.tables.StateCountyCodeEntry;
import java.util.List;
import java.util.Map;

public class StateCountyCodeLookupGenerator {
    private final CsvContentReader<StateCountyCodeEntry> contentProvider = new CsvContentReader<StateCountyCodeEntry>(StateCountyCodeEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public StateCountyCodeLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, StateCountyCodeEntry> generate(String csvFile) {
        List<StateCountyCodeEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(StateCountyCodeEntry::getCode, content);
    }
}

