/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import ch.qos.logback.access.spi.IAccessEvent;
import io.dropwizard.logging.json.AccessAttribute;
import io.dropwizard.logging.json.layout.AbstractJsonLayout;
import io.dropwizard.logging.json.layout.JsonFormatter;
import io.dropwizard.logging.json.layout.MapBuilder;
import io.dropwizard.logging.json.layout.TimestampFormatter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AccessJsonLayout
extends AbstractJsonLayout<IAccessEvent> {
    private static final String USER_AGENT = "User-Agent";
    private Set<AccessAttribute> includes;
    private SortedSet<String> requestHeaders = Collections.emptySortedSet();
    private SortedSet<String> responseHeaders = Collections.emptySortedSet();
    private SortedSet<String> requestAttributes = Collections.emptySortedSet();
    @Nullable
    private String jsonProtocolVersion;
    private final TimestampFormatter timestampFormatter;
    private final Map<String, Object> additionalFields;
    private final Map<String, String> customFieldNames;

    public AccessJsonLayout(JsonFormatter jsonFormatter, TimestampFormatter timestampFormatter, Set<AccessAttribute> includes, Map<String, String> customFieldNames, Map<String, Object> additionalFields) {
        super(jsonFormatter);
        this.timestampFormatter = timestampFormatter;
        this.additionalFields = new HashMap<String, Object>(additionalFields);
        this.customFieldNames = new HashMap<String, String>(customFieldNames);
        this.includes = EnumSet.copyOf(includes);
    }

    @Override
    protected Map<String, Object> toJsonMap(IAccessEvent event) {
        return new MapBuilder(this.timestampFormatter, this.customFieldNames, this.additionalFields, this.includes.size()).addNumber("port", this.isIncluded(AccessAttribute.LOCAL_PORT), event::getLocalPort).addNumber("contentLength", this.isIncluded(AccessAttribute.CONTENT_LENGTH), event::getContentLength).addTimestamp("timestamp", this.isIncluded(AccessAttribute.TIMESTAMP), event.getTimeStamp()).add("method", this.isIncluded(AccessAttribute.METHOD), event::getMethod).add("protocol", this.isIncluded(AccessAttribute.PROTOCOL), event::getProtocol).add("requestContent", this.isIncluded(AccessAttribute.REQUEST_CONTENT), event::getRequestContent).add("remoteAddress", this.isIncluded(AccessAttribute.REMOTE_ADDRESS), event::getRemoteAddr).add("remoteUser", this.isIncluded(AccessAttribute.REMOTE_USER), event::getRemoteUser).addMap("headers", !this.requestHeaders.isEmpty(), () -> this.filterHeaders(event.getRequestHeaderMap(), this.requestHeaders)).addMap("params", this.isIncluded(AccessAttribute.REQUEST_PARAMETERS), event::getRequestParameterMap).addNumber("requestTime", this.isIncluded(AccessAttribute.REQUEST_TIME), event::getElapsedTime).add("uri", this.isIncluded(AccessAttribute.REQUEST_URI), event::getRequestURI).add("url", this.isIncluded(AccessAttribute.REQUEST_URL), event::getRequestURL).add("pathQuery", this.isIncluded(AccessAttribute.PATH_QUERY), () -> event.getRequestURI() + event.getQueryString()).add("remoteHost", this.isIncluded(AccessAttribute.REMOTE_HOST), event::getRemoteHost).add("responseContent", this.isIncluded(AccessAttribute.RESPONSE_CONTENT), event::getResponseContent).addMap("responseHeaders", !this.responseHeaders.isEmpty(), () -> this.filterHeaders(event.getResponseHeaderMap(), this.responseHeaders)).add("serverName", this.isIncluded(AccessAttribute.SERVER_NAME), event::getServerName).addNumber("status", this.isIncluded(AccessAttribute.STATUS_CODE), event::getStatusCode).add("userAgent", this.isIncluded(AccessAttribute.USER_AGENT), () -> event.getRequestHeader(USER_AGENT)).add("version", this.jsonProtocolVersion != null, this.jsonProtocolVersion).addMap("requestAttributes", !this.requestAttributes.isEmpty(), () -> this.filterRequestAttributes(this.requestAttributes, event)).build();
    }

    private boolean isIncluded(AccessAttribute attribute) {
        return this.includes.contains((Object)attribute);
    }

    private Map<String, String> filterRequestAttributes(Set<String> requestAttributeNames, IAccessEvent event) {
        return requestAttributeNames.stream().filter(name -> event.getAttribute((String)name) != null).collect(Collectors.toMap(Function.identity(), event::getAttribute));
    }

    private Map<String, String> filterHeaders(Map<String, String> headers, Set<String> filteredHeaderNames) {
        if (filteredHeaderNames.isEmpty()) {
            return Collections.emptyMap();
        }
        return headers.entrySet().stream().filter(e -> filteredHeaderNames.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Set<AccessAttribute> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<AccessAttribute> includes) {
        this.includes = EnumSet.copyOf(includes);
    }

    @Nullable
    public String getJsonProtocolVersion() {
        return this.jsonProtocolVersion;
    }

    public void setJsonProtocolVersion(@Nullable String jsonProtocolVersion) {
        this.jsonProtocolVersion = jsonProtocolVersion;
    }

    public Set<String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Set<String> requestHeaders) {
        TreeSet<String> headers = new TreeSet<String>(String::compareToIgnoreCase);
        headers.addAll(requestHeaders);
        this.requestHeaders = headers;
    }

    public Set<String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Set<String> responseHeaders) {
        TreeSet<String> headers = new TreeSet<String>(String::compareToIgnoreCase);
        headers.addAll(responseHeaders);
        this.responseHeaders = headers;
    }

    public Set<String> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Set<String> requestAttributes) {
        TreeSet<String> attributes = new TreeSet<String>(String::compareToIgnoreCase);
        attributes.addAll(requestAttributes);
        this.requestAttributes = attributes;
    }
}

