// Generated by delombok at Thu Mar 06 01:40:35 UTC 2025
package gov.cms.fiss.pricers.hha.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat.Shape;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.hha.core.tables.RevenueEntry.Fields;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;

/**
 * Model for the revenue CSV file.
 */
@Immutable
@JsonDeserialize(builder = RevenueEntry.RevenueEntryBuilder.class)
@JsonPropertyOrder({Fields.CODE, Fields.EFFECTIVE_DATE, Fields.NONRURAL_DOLLAR_RATE, Fields.RURAL_DOLLAR_RATE, Fields.NONRURAL_UNSUBMITTED_DOLLAR_RATE, Fields.RURAL_UNSUBMITTED_DOLLAR_RATE, Fields.NONRURAL_UNIT_DOLLAR_RATE, Fields.RURAL_UNIT_DOLLAR_RATE, Fields.NONRURAL_UNSUBMITTED_UNIT_DOLLAR_RATE, Fields.RURAL_UNSUBMITTED_UNIT_DOLLAR_RATE})
public class RevenueEntry implements Comparable<RevenueEntry> {

  @JsonPOJOBuilder(withPrefix = "")
  public static class RevenueEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String code;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private LocalDate effectiveDate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal nonruralDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal ruralDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal nonruralUnsubmittedDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal ruralUnsubmittedDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal nonruralUnitDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal ruralUnitDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal nonruralUnsubmittedUnitDollarRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal ruralUnsubmittedUnitDollarRate;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    RevenueEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder code(final String code) {
      this.code = code;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder effectiveDate(final LocalDate effectiveDate) {
      this.effectiveDate = effectiveDate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder nonruralDollarRate(final BigDecimal nonruralDollarRate) {
      this.nonruralDollarRate = nonruralDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder ruralDollarRate(final BigDecimal ruralDollarRate) {
      this.ruralDollarRate = ruralDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder nonruralUnsubmittedDollarRate(final BigDecimal nonruralUnsubmittedDollarRate) {
      this.nonruralUnsubmittedDollarRate = nonruralUnsubmittedDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder ruralUnsubmittedDollarRate(final BigDecimal ruralUnsubmittedDollarRate) {
      this.ruralUnsubmittedDollarRate = ruralUnsubmittedDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder nonruralUnitDollarRate(final BigDecimal nonruralUnitDollarRate) {
      this.nonruralUnitDollarRate = nonruralUnitDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder ruralUnitDollarRate(final BigDecimal ruralUnitDollarRate) {
      this.ruralUnitDollarRate = ruralUnitDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder nonruralUnsubmittedUnitDollarRate(final BigDecimal nonruralUnsubmittedUnitDollarRate) {
      this.nonruralUnsubmittedUnitDollarRate = nonruralUnsubmittedUnitDollarRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry.RevenueEntryBuilder ruralUnsubmittedUnitDollarRate(final BigDecimal ruralUnsubmittedUnitDollarRate) {
      this.ruralUnsubmittedUnitDollarRate = ruralUnsubmittedUnitDollarRate;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RevenueEntry build() {
      return new RevenueEntry(this.code, this.effectiveDate, this.nonruralDollarRate, this.ruralDollarRate, this.nonruralUnsubmittedDollarRate, this.ruralUnsubmittedDollarRate, this.nonruralUnitDollarRate, this.ruralUnitDollarRate, this.nonruralUnsubmittedUnitDollarRate, this.ruralUnsubmittedUnitDollarRate);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "RevenueEntry.RevenueEntryBuilder(code=" + this.code + ", effectiveDate=" + this.effectiveDate + ", nonruralDollarRate=" + this.nonruralDollarRate + ", ruralDollarRate=" + this.ruralDollarRate + ", nonruralUnsubmittedDollarRate=" + this.nonruralUnsubmittedDollarRate + ", ruralUnsubmittedDollarRate=" + this.ruralUnsubmittedDollarRate + ", nonruralUnitDollarRate=" + this.nonruralUnitDollarRate + ", ruralUnitDollarRate=" + this.ruralUnitDollarRate + ", nonruralUnsubmittedUnitDollarRate=" + this.nonruralUnsubmittedUnitDollarRate + ", ruralUnsubmittedUnitDollarRate=" + this.ruralUnsubmittedUnitDollarRate + ")";
    }
  }

  @Pattern(regexp = "\\d{4}")
  private final String code;
  @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
  private final LocalDate effectiveDate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal nonruralDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal ruralDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal nonruralUnsubmittedDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal ruralUnsubmittedDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal nonruralUnitDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal ruralUnitDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal nonruralUnsubmittedUnitDollarRate;
  @Digits(integer = 7, fraction = 2)
  @BigDecimalScale
  private final BigDecimal ruralUnsubmittedUnitDollarRate;

  @Override
  public int compareTo(@Nonnull RevenueEntry o) {
    return Comparator.comparing(RevenueEntry::getEffectiveDate).compare(this, o);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  RevenueEntry(final String code, final LocalDate effectiveDate, final BigDecimal nonruralDollarRate, final BigDecimal ruralDollarRate, final BigDecimal nonruralUnsubmittedDollarRate, final BigDecimal ruralUnsubmittedDollarRate, final BigDecimal nonruralUnitDollarRate, final BigDecimal ruralUnitDollarRate, final BigDecimal nonruralUnsubmittedUnitDollarRate, final BigDecimal ruralUnsubmittedUnitDollarRate) {
    this.code = code;
    this.effectiveDate = effectiveDate;
    this.nonruralDollarRate = nonruralDollarRate;
    this.ruralDollarRate = ruralDollarRate;
    this.nonruralUnsubmittedDollarRate = nonruralUnsubmittedDollarRate;
    this.ruralUnsubmittedDollarRate = ruralUnsubmittedDollarRate;
    this.nonruralUnitDollarRate = nonruralUnitDollarRate;
    this.ruralUnitDollarRate = ruralUnitDollarRate;
    this.nonruralUnsubmittedUnitDollarRate = nonruralUnsubmittedUnitDollarRate;
    this.ruralUnsubmittedUnitDollarRate = ruralUnsubmittedUnitDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static RevenueEntry.RevenueEntryBuilder builder() {
    return new RevenueEntry.RevenueEntryBuilder();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RevenueEntry)) return false;
    final RevenueEntry other = (RevenueEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$code = this.getCode();
    final java.lang.Object other$code = other.getCode();
    if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
    final java.lang.Object this$effectiveDate = this.getEffectiveDate();
    final java.lang.Object other$effectiveDate = other.getEffectiveDate();
    if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) return false;
    final java.lang.Object this$nonruralDollarRate = this.getNonruralDollarRate();
    final java.lang.Object other$nonruralDollarRate = other.getNonruralDollarRate();
    if (this$nonruralDollarRate == null ? other$nonruralDollarRate != null : !this$nonruralDollarRate.equals(other$nonruralDollarRate)) return false;
    final java.lang.Object this$ruralDollarRate = this.getRuralDollarRate();
    final java.lang.Object other$ruralDollarRate = other.getRuralDollarRate();
    if (this$ruralDollarRate == null ? other$ruralDollarRate != null : !this$ruralDollarRate.equals(other$ruralDollarRate)) return false;
    final java.lang.Object this$nonruralUnsubmittedDollarRate = this.getNonruralUnsubmittedDollarRate();
    final java.lang.Object other$nonruralUnsubmittedDollarRate = other.getNonruralUnsubmittedDollarRate();
    if (this$nonruralUnsubmittedDollarRate == null ? other$nonruralUnsubmittedDollarRate != null : !this$nonruralUnsubmittedDollarRate.equals(other$nonruralUnsubmittedDollarRate)) return false;
    final java.lang.Object this$ruralUnsubmittedDollarRate = this.getRuralUnsubmittedDollarRate();
    final java.lang.Object other$ruralUnsubmittedDollarRate = other.getRuralUnsubmittedDollarRate();
    if (this$ruralUnsubmittedDollarRate == null ? other$ruralUnsubmittedDollarRate != null : !this$ruralUnsubmittedDollarRate.equals(other$ruralUnsubmittedDollarRate)) return false;
    final java.lang.Object this$nonruralUnitDollarRate = this.getNonruralUnitDollarRate();
    final java.lang.Object other$nonruralUnitDollarRate = other.getNonruralUnitDollarRate();
    if (this$nonruralUnitDollarRate == null ? other$nonruralUnitDollarRate != null : !this$nonruralUnitDollarRate.equals(other$nonruralUnitDollarRate)) return false;
    final java.lang.Object this$ruralUnitDollarRate = this.getRuralUnitDollarRate();
    final java.lang.Object other$ruralUnitDollarRate = other.getRuralUnitDollarRate();
    if (this$ruralUnitDollarRate == null ? other$ruralUnitDollarRate != null : !this$ruralUnitDollarRate.equals(other$ruralUnitDollarRate)) return false;
    final java.lang.Object this$nonruralUnsubmittedUnitDollarRate = this.getNonruralUnsubmittedUnitDollarRate();
    final java.lang.Object other$nonruralUnsubmittedUnitDollarRate = other.getNonruralUnsubmittedUnitDollarRate();
    if (this$nonruralUnsubmittedUnitDollarRate == null ? other$nonruralUnsubmittedUnitDollarRate != null : !this$nonruralUnsubmittedUnitDollarRate.equals(other$nonruralUnsubmittedUnitDollarRate)) return false;
    final java.lang.Object this$ruralUnsubmittedUnitDollarRate = this.getRuralUnsubmittedUnitDollarRate();
    final java.lang.Object other$ruralUnsubmittedUnitDollarRate = other.getRuralUnsubmittedUnitDollarRate();
    if (this$ruralUnsubmittedUnitDollarRate == null ? other$ruralUnsubmittedUnitDollarRate != null : !this$ruralUnsubmittedUnitDollarRate.equals(other$ruralUnsubmittedUnitDollarRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RevenueEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $code = this.getCode();
    result = result * PRIME + ($code == null ? 43 : $code.hashCode());
    final java.lang.Object $effectiveDate = this.getEffectiveDate();
    result = result * PRIME + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
    final java.lang.Object $nonruralDollarRate = this.getNonruralDollarRate();
    result = result * PRIME + ($nonruralDollarRate == null ? 43 : $nonruralDollarRate.hashCode());
    final java.lang.Object $ruralDollarRate = this.getRuralDollarRate();
    result = result * PRIME + ($ruralDollarRate == null ? 43 : $ruralDollarRate.hashCode());
    final java.lang.Object $nonruralUnsubmittedDollarRate = this.getNonruralUnsubmittedDollarRate();
    result = result * PRIME + ($nonruralUnsubmittedDollarRate == null ? 43 : $nonruralUnsubmittedDollarRate.hashCode());
    final java.lang.Object $ruralUnsubmittedDollarRate = this.getRuralUnsubmittedDollarRate();
    result = result * PRIME + ($ruralUnsubmittedDollarRate == null ? 43 : $ruralUnsubmittedDollarRate.hashCode());
    final java.lang.Object $nonruralUnitDollarRate = this.getNonruralUnitDollarRate();
    result = result * PRIME + ($nonruralUnitDollarRate == null ? 43 : $nonruralUnitDollarRate.hashCode());
    final java.lang.Object $ruralUnitDollarRate = this.getRuralUnitDollarRate();
    result = result * PRIME + ($ruralUnitDollarRate == null ? 43 : $ruralUnitDollarRate.hashCode());
    final java.lang.Object $nonruralUnsubmittedUnitDollarRate = this.getNonruralUnsubmittedUnitDollarRate();
    result = result * PRIME + ($nonruralUnsubmittedUnitDollarRate == null ? 43 : $nonruralUnsubmittedUnitDollarRate.hashCode());
    final java.lang.Object $ruralUnsubmittedUnitDollarRate = this.getRuralUnsubmittedUnitDollarRate();
    result = result * PRIME + ($ruralUnsubmittedUnitDollarRate == null ? 43 : $ruralUnsubmittedUnitDollarRate.hashCode());
    return result;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String CODE = "code";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String NONRURAL_DOLLAR_RATE = "nonruralDollarRate";
    public static final java.lang.String RURAL_DOLLAR_RATE = "ruralDollarRate";
    public static final java.lang.String NONRURAL_UNSUBMITTED_DOLLAR_RATE = "nonruralUnsubmittedDollarRate";
    public static final java.lang.String RURAL_UNSUBMITTED_DOLLAR_RATE = "ruralUnsubmittedDollarRate";
    public static final java.lang.String NONRURAL_UNIT_DOLLAR_RATE = "nonruralUnitDollarRate";
    public static final java.lang.String RURAL_UNIT_DOLLAR_RATE = "ruralUnitDollarRate";
    public static final java.lang.String NONRURAL_UNSUBMITTED_UNIT_DOLLAR_RATE = "nonruralUnsubmittedUnitDollarRate";
    public static final java.lang.String RURAL_UNSUBMITTED_UNIT_DOLLAR_RATE = "ruralUnsubmittedUnitDollarRate";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonruralDollarRate() {
    return this.nonruralDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralDollarRate() {
    return this.ruralDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonruralUnsubmittedDollarRate() {
    return this.nonruralUnsubmittedDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralUnsubmittedDollarRate() {
    return this.ruralUnsubmittedDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonruralUnitDollarRate() {
    return this.nonruralUnitDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralUnitDollarRate() {
    return this.ruralUnitDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonruralUnsubmittedUnitDollarRate() {
    return this.nonruralUnsubmittedUnitDollarRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralUnsubmittedUnitDollarRate() {
    return this.ruralUnsubmittedUnitDollarRate;
  }
}
