/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The data related to an ambulatory payment classification (APC).")
public class AmbulatoryPaymentClassificationData {
    @NotNull
    @Pattern(regexp="\\d{4}", message="must be four digits")
    @Schema(description="The ambulatory payment classification (APC) for which coinsurance will be reduced.", example="0950")
    private @NotNull @Pattern(regexp="\\d{4}", message="must be four digits") String ambulatoryPaymentClassificationCode;
    @BigDecimalScale
    @DecimalMax(value="99999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=11, fraction=2)
    @NotNull
    @Schema(description="The reduced coinsurance amount elected.", example="21.71")
    private @DecimalMax(value="99999999999.99") @DecimalMin(value="0") @Digits(integer=11, fraction=2) @NotNull BigDecimal reducedCoinsuranceAmount;

    @Generated
    public String getAmbulatoryPaymentClassificationCode() {
        return this.ambulatoryPaymentClassificationCode;
    }

    @Generated
    public BigDecimal getReducedCoinsuranceAmount() {
        return this.reducedCoinsuranceAmount;
    }

    @Generated
    public void setAmbulatoryPaymentClassificationCode(String ambulatoryPaymentClassificationCode) {
        this.ambulatoryPaymentClassificationCode = ambulatoryPaymentClassificationCode;
    }

    @Generated
    public void setReducedCoinsuranceAmount(BigDecimal reducedCoinsuranceAmount) {
        this.reducedCoinsuranceAmount = reducedCoinsuranceAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmbulatoryPaymentClassificationData)) {
            return false;
        }
        AmbulatoryPaymentClassificationData other = (AmbulatoryPaymentClassificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ambulatoryPaymentClassificationCode = this.getAmbulatoryPaymentClassificationCode();
        String other$ambulatoryPaymentClassificationCode = other.getAmbulatoryPaymentClassificationCode();
        if (this$ambulatoryPaymentClassificationCode == null ? other$ambulatoryPaymentClassificationCode != null : !this$ambulatoryPaymentClassificationCode.equals(other$ambulatoryPaymentClassificationCode)) {
            return false;
        }
        BigDecimal this$reducedCoinsuranceAmount = this.getReducedCoinsuranceAmount();
        BigDecimal other$reducedCoinsuranceAmount = other.getReducedCoinsuranceAmount();
        return !(this$reducedCoinsuranceAmount == null ? other$reducedCoinsuranceAmount != null : !((Object)this$reducedCoinsuranceAmount).equals(other$reducedCoinsuranceAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AmbulatoryPaymentClassificationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ambulatoryPaymentClassificationCode = this.getAmbulatoryPaymentClassificationCode();
        result = result * 59 + ($ambulatoryPaymentClassificationCode == null ? 43 : $ambulatoryPaymentClassificationCode.hashCode());
        BigDecimal $reducedCoinsuranceAmount = this.getReducedCoinsuranceAmount();
        result = result * 59 + ($reducedCoinsuranceAmount == null ? 43 : ((Object)$reducedCoinsuranceAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AmbulatoryPaymentClassificationData(ambulatoryPaymentClassificationCode=" + this.getAmbulatoryPaymentClassificationCode() + ", reducedCoinsuranceAmount=" + this.getReducedCoinsuranceAmount() + ")";
    }

    @Generated
    public AmbulatoryPaymentClassificationData() {
    }
}

