/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api.validation;

import gov.cms.fiss.pricers.common.api.validation.RelativeDateValidator;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.function.BiPredicate;
import lombok.Generated;

@Constraint(validatedBy={RelativeDateValidator.class})
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE})
public @interface RelativeDate {
    public String value();

    public ComparisonMode comparisonMode();

    public boolean exclusive() default false;

    public String message() default "must be ${comparisonMode.formattedName} ${exclusive ? '': 'or equal to '}{value}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static enum ComparisonMode {
        AFTER((referenceDate, valueDate) -> valueDate.isAfter((ChronoLocalDate)referenceDate), "after"),
        BEFORE((referenceDate, valueDate) -> valueDate.isBefore((ChronoLocalDate)referenceDate), "before");

        final BiPredicate<LocalDate, LocalDate> comparison;
        final String formattedName;

        private ComparisonMode(BiPredicate<LocalDate, LocalDate> comparison, String formattedName) {
            this.comparison = comparison;
            this.formattedName = formattedName;
        }

        @Generated
        public BiPredicate<LocalDate, LocalDate> getComparison() {
            return this.comparison;
        }

        @Generated
        public String getFormattedName() {
            return this.formattedName;
        }
    }
}

