/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.hha.HhaPricerConfiguration;
import gov.cms.fiss.pricers.hha.core.HhaPricerDispatch;
import gov.cms.fiss.pricers.hha.resources.HhaClaimPricingResource;
import gov.cms.fiss.pricers.hha.resources.HhaExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HhaPricerApplication
extends OpenApiPricerApplication<HhaPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HhaPricerApplication.class);

    public static void main(String[] args) throws Exception {
        new HhaPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(HhaPricerConfiguration configuration, Environment environment) {
        HhaClaimPricingResource v2Resource = new HhaClaimPricingResource(new HhaPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, HhaExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("HHA Pricer").version("v1")));
        return customizers;
    }

    @Override
    public String getName() {
        return "hha-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(HhaClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.0", 2021, "2021.3", 2022, "2022.0", 2023, "2023.1", 2024, "2024.0", 2025, "2025.1", 2026, "2026.0");
    }
}

