/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@Schema(description="The claim data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-INPUT-DATA", value="<structure>")})})
public class HhaClaimData
extends ClaimData {
    @Pattern(regexp="\\d", message="must be one digit")
    @Schema(description="The adjustment indicator.", example="2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-ADJ-IND", value="PIC X")})})
    private @Pattern(regexp="\\d", message="must be one digit") String adjustmentIndicator;
    @NotNull
    @Schema(description="The date of the first service delivered by the HHA in an episode or a series of continuous episodes.", example="2021-06-19", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-ADMIT-DATE", value="HHA-ADMIT-CC  PIC XX\nHHA-ADMIT-YY  PIC XX\nHHA-ADMIT-MM  PIC XX\nHHA-ADMIT-DD  PIC XX")})})
    @StrictLocalDate
    private LocalDate admissionDate;
    @NotNull
    @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters")
    @Schema(description="The home health resource group (HHRG) input code.", example="1FC11", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-HRG-INPUT-CODE", value="PIC X(05)")})})
    private @NotNull @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters") String hhrgInputCode;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The span of days between the first and last line item service dates.", example="30", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-HRG-NO-OF-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer hhrgNumberOfDays;
    @NotNull
    @Pattern(regexp="\\d", message="must be one digit")
    @Schema(description="The initial payment quality reporting program (QRP) indicator.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-INIT-PAY-QRP-IND", value="PIC X(01)")})})
    private @NotNull @Pattern(regexp="\\d", message="must be one digit") String initialPaymentQualityReportingProgramIndicator;
    @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric")
    @Schema(description="The indicator that the late filing penalty has been waived.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-OVERRIDE-IND", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric") String lateFilingPenaltyWaiverIndicator;
    @Pattern(regexp="[A-Z\\d]", message="must be one alphanumeric character")
    @Schema(description="The low-utilization payment adjustment (LUPA) source admission indicator.", example="B", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-LUPA-SRC-ADM", value="PIC X")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be one alphanumeric character") String lupaSourceAdmissionIndicator;
    @Schema(description="The receipt date of the corresponding request for anticipated payment (RAP) for this claim.", example="2021-10-12", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-RECEIPT-DATE", value="PIC X(08)")})})
    @StrictLocalDate
    private LocalDate noticeReceiptDate;
    @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric")
    @Schema(description="The partial episode payment (PEP) indicator.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-PEP-IND", value="PIC X")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric") String partialEpisodePaymentIndicator;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total amount of outlier payments that have been made for episodes ending during the current calendar year.", example="66003.39", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-PROV-OUTLIER-PAY-TOTAL", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal priorOutlierTotal;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total amount of Home Health PPS payments that have been made for episodes ending during the current calendar year.", example="88350.20", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-PROV-PAYMENT-TOTAL", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal priorPaymentTotal;
    @ArraySchema(arraySchema=@Schema(description="The revenue data associated with this claim.", example="[{\"revenueCode\":\"0420\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"},{\"revenueCode\":\"0430\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"},{\"revenueCode\":\"0440\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"},{\"revenueCode\":\"0550\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"},{\"revenueCode\":\"0560\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"},{\"revenueCode\":\"0570\",\"quantityOfCoveredVisits\":8,\"quantityOfOutlierUnits\":32,\"earliestLineItemDate\":\"2020-05-14\"}]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-DATA", value="<structure>")})})
    @NotNull
    @Size(max=6, min=6)
    @Valid
    private @NotNull @Size(max=6, min=6) @Valid List<@NotNull RevenueLineData> revenueLines;
    @NotNull
    @Schema(description="The start date of service.", example="2021-06-19", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-SERV-FROM-DATE", value="HHA-FROM-CC  PIC XX\nHHA-FROM-YY  PIC XX\nHHA-FROM-MM  PIC XX\nHHA-FROM-DD  PIC XX")})})
    @StrictLocalDate
    private LocalDate serviceFromDate;
    @NotNull
    @Schema(description="The end date of service.", example="2021-09-26", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-SERV-THRU-DATE", value="HHA-THRU-CC  PIC XX\nHHA-THRU-YY  PIC XX\nHHA-THRU-MM  PIC XX\nHHA-THRU-DD  PIC XX")})})
    @StrictLocalDate
    private LocalDate serviceThroughDate;
    @Pattern(regexp="\\d{2}[A-Z0-9]", message="must be two digits followed by an alphanumeric character")
    @Schema(description="The type of bill.", example="329", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-TOB", value="PIC X(03)")})})
    private @Pattern(regexp="\\d{2}[A-Z0-9]", message="must be two digits followed by an alphanumeric character") String typeOfBill;

    @Generated
    public String getAdjustmentIndicator() {
        return this.adjustmentIndicator;
    }

    @Generated
    public LocalDate getAdmissionDate() {
        return this.admissionDate;
    }

    @Generated
    public String getHhrgInputCode() {
        return this.hhrgInputCode;
    }

    @Generated
    public Integer getHhrgNumberOfDays() {
        return this.hhrgNumberOfDays;
    }

    @Generated
    public String getInitialPaymentQualityReportingProgramIndicator() {
        return this.initialPaymentQualityReportingProgramIndicator;
    }

    @Generated
    public String getLateFilingPenaltyWaiverIndicator() {
        return this.lateFilingPenaltyWaiverIndicator;
    }

    @Generated
    public String getLupaSourceAdmissionIndicator() {
        return this.lupaSourceAdmissionIndicator;
    }

    @Generated
    public LocalDate getNoticeReceiptDate() {
        return this.noticeReceiptDate;
    }

    @Generated
    public String getPartialEpisodePaymentIndicator() {
        return this.partialEpisodePaymentIndicator;
    }

    @Generated
    public BigDecimal getPriorOutlierTotal() {
        return this.priorOutlierTotal;
    }

    @Generated
    public BigDecimal getPriorPaymentTotal() {
        return this.priorPaymentTotal;
    }

    @Generated
    public List<@NotNull RevenueLineData> getRevenueLines() {
        return this.revenueLines;
    }

    @Generated
    public LocalDate getServiceFromDate() {
        return this.serviceFromDate;
    }

    @Generated
    public LocalDate getServiceThroughDate() {
        return this.serviceThroughDate;
    }

    @Generated
    public String getTypeOfBill() {
        return this.typeOfBill;
    }

    @Generated
    public void setAdjustmentIndicator(String adjustmentIndicator) {
        this.adjustmentIndicator = adjustmentIndicator;
    }

    @Generated
    public void setAdmissionDate(LocalDate admissionDate) {
        this.admissionDate = admissionDate;
    }

    @Generated
    public void setHhrgInputCode(String hhrgInputCode) {
        this.hhrgInputCode = hhrgInputCode;
    }

    @Generated
    public void setHhrgNumberOfDays(Integer hhrgNumberOfDays) {
        this.hhrgNumberOfDays = hhrgNumberOfDays;
    }

    @Generated
    public void setInitialPaymentQualityReportingProgramIndicator(String initialPaymentQualityReportingProgramIndicator) {
        this.initialPaymentQualityReportingProgramIndicator = initialPaymentQualityReportingProgramIndicator;
    }

    @Generated
    public void setLateFilingPenaltyWaiverIndicator(String lateFilingPenaltyWaiverIndicator) {
        this.lateFilingPenaltyWaiverIndicator = lateFilingPenaltyWaiverIndicator;
    }

    @Generated
    public void setLupaSourceAdmissionIndicator(String lupaSourceAdmissionIndicator) {
        this.lupaSourceAdmissionIndicator = lupaSourceAdmissionIndicator;
    }

    @Generated
    public void setNoticeReceiptDate(LocalDate noticeReceiptDate) {
        this.noticeReceiptDate = noticeReceiptDate;
    }

    @Generated
    public void setPartialEpisodePaymentIndicator(String partialEpisodePaymentIndicator) {
        this.partialEpisodePaymentIndicator = partialEpisodePaymentIndicator;
    }

    @Generated
    public void setPriorOutlierTotal(BigDecimal priorOutlierTotal) {
        this.priorOutlierTotal = priorOutlierTotal;
    }

    @Generated
    public void setPriorPaymentTotal(BigDecimal priorPaymentTotal) {
        this.priorPaymentTotal = priorPaymentTotal;
    }

    @Generated
    public void setRevenueLines(List<@NotNull RevenueLineData> revenueLines) {
        this.revenueLines = revenueLines;
    }

    @Generated
    public void setServiceFromDate(LocalDate serviceFromDate) {
        this.serviceFromDate = serviceFromDate;
    }

    @Generated
    public void setServiceThroughDate(LocalDate serviceThroughDate) {
        this.serviceThroughDate = serviceThroughDate;
    }

    @Generated
    public void setTypeOfBill(String typeOfBill) {
        this.typeOfBill = typeOfBill;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HhaClaimData)) {
            return false;
        }
        HhaClaimData other = (HhaClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$hhrgNumberOfDays = this.getHhrgNumberOfDays();
        Integer other$hhrgNumberOfDays = other.getHhrgNumberOfDays();
        if (this$hhrgNumberOfDays == null ? other$hhrgNumberOfDays != null : !((Object)this$hhrgNumberOfDays).equals(other$hhrgNumberOfDays)) {
            return false;
        }
        String this$adjustmentIndicator = this.getAdjustmentIndicator();
        String other$adjustmentIndicator = other.getAdjustmentIndicator();
        if (this$adjustmentIndicator == null ? other$adjustmentIndicator != null : !this$adjustmentIndicator.equals(other$adjustmentIndicator)) {
            return false;
        }
        LocalDate this$admissionDate = this.getAdmissionDate();
        LocalDate other$admissionDate = other.getAdmissionDate();
        if (this$admissionDate == null ? other$admissionDate != null : !((Object)this$admissionDate).equals(other$admissionDate)) {
            return false;
        }
        String this$hhrgInputCode = this.getHhrgInputCode();
        String other$hhrgInputCode = other.getHhrgInputCode();
        if (this$hhrgInputCode == null ? other$hhrgInputCode != null : !this$hhrgInputCode.equals(other$hhrgInputCode)) {
            return false;
        }
        String this$initialPaymentQualityReportingProgramIndicator = this.getInitialPaymentQualityReportingProgramIndicator();
        String other$initialPaymentQualityReportingProgramIndicator = other.getInitialPaymentQualityReportingProgramIndicator();
        if (this$initialPaymentQualityReportingProgramIndicator == null ? other$initialPaymentQualityReportingProgramIndicator != null : !this$initialPaymentQualityReportingProgramIndicator.equals(other$initialPaymentQualityReportingProgramIndicator)) {
            return false;
        }
        String this$lateFilingPenaltyWaiverIndicator = this.getLateFilingPenaltyWaiverIndicator();
        String other$lateFilingPenaltyWaiverIndicator = other.getLateFilingPenaltyWaiverIndicator();
        if (this$lateFilingPenaltyWaiverIndicator == null ? other$lateFilingPenaltyWaiverIndicator != null : !this$lateFilingPenaltyWaiverIndicator.equals(other$lateFilingPenaltyWaiverIndicator)) {
            return false;
        }
        String this$lupaSourceAdmissionIndicator = this.getLupaSourceAdmissionIndicator();
        String other$lupaSourceAdmissionIndicator = other.getLupaSourceAdmissionIndicator();
        if (this$lupaSourceAdmissionIndicator == null ? other$lupaSourceAdmissionIndicator != null : !this$lupaSourceAdmissionIndicator.equals(other$lupaSourceAdmissionIndicator)) {
            return false;
        }
        LocalDate this$noticeReceiptDate = this.getNoticeReceiptDate();
        LocalDate other$noticeReceiptDate = other.getNoticeReceiptDate();
        if (this$noticeReceiptDate == null ? other$noticeReceiptDate != null : !((Object)this$noticeReceiptDate).equals(other$noticeReceiptDate)) {
            return false;
        }
        String this$partialEpisodePaymentIndicator = this.getPartialEpisodePaymentIndicator();
        String other$partialEpisodePaymentIndicator = other.getPartialEpisodePaymentIndicator();
        if (this$partialEpisodePaymentIndicator == null ? other$partialEpisodePaymentIndicator != null : !this$partialEpisodePaymentIndicator.equals(other$partialEpisodePaymentIndicator)) {
            return false;
        }
        BigDecimal this$priorOutlierTotal = this.getPriorOutlierTotal();
        BigDecimal other$priorOutlierTotal = other.getPriorOutlierTotal();
        if (this$priorOutlierTotal == null ? other$priorOutlierTotal != null : !((Object)this$priorOutlierTotal).equals(other$priorOutlierTotal)) {
            return false;
        }
        BigDecimal this$priorPaymentTotal = this.getPriorPaymentTotal();
        BigDecimal other$priorPaymentTotal = other.getPriorPaymentTotal();
        if (this$priorPaymentTotal == null ? other$priorPaymentTotal != null : !((Object)this$priorPaymentTotal).equals(other$priorPaymentTotal)) {
            return false;
        }
        List<RevenueLineData> this$revenueLines = this.getRevenueLines();
        List<RevenueLineData> other$revenueLines = other.getRevenueLines();
        if (this$revenueLines == null ? other$revenueLines != null : !((Object)this$revenueLines).equals(other$revenueLines)) {
            return false;
        }
        LocalDate this$serviceFromDate = this.getServiceFromDate();
        LocalDate other$serviceFromDate = other.getServiceFromDate();
        if (this$serviceFromDate == null ? other$serviceFromDate != null : !((Object)this$serviceFromDate).equals(other$serviceFromDate)) {
            return false;
        }
        LocalDate this$serviceThroughDate = this.getServiceThroughDate();
        LocalDate other$serviceThroughDate = other.getServiceThroughDate();
        if (this$serviceThroughDate == null ? other$serviceThroughDate != null : !((Object)this$serviceThroughDate).equals(other$serviceThroughDate)) {
            return false;
        }
        String this$typeOfBill = this.getTypeOfBill();
        String other$typeOfBill = other.getTypeOfBill();
        return !(this$typeOfBill == null ? other$typeOfBill != null : !this$typeOfBill.equals(other$typeOfBill));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HhaClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $hhrgNumberOfDays = this.getHhrgNumberOfDays();
        result = result * 59 + ($hhrgNumberOfDays == null ? 43 : ((Object)$hhrgNumberOfDays).hashCode());
        String $adjustmentIndicator = this.getAdjustmentIndicator();
        result = result * 59 + ($adjustmentIndicator == null ? 43 : $adjustmentIndicator.hashCode());
        LocalDate $admissionDate = this.getAdmissionDate();
        result = result * 59 + ($admissionDate == null ? 43 : ((Object)$admissionDate).hashCode());
        String $hhrgInputCode = this.getHhrgInputCode();
        result = result * 59 + ($hhrgInputCode == null ? 43 : $hhrgInputCode.hashCode());
        String $initialPaymentQualityReportingProgramIndicator = this.getInitialPaymentQualityReportingProgramIndicator();
        result = result * 59 + ($initialPaymentQualityReportingProgramIndicator == null ? 43 : $initialPaymentQualityReportingProgramIndicator.hashCode());
        String $lateFilingPenaltyWaiverIndicator = this.getLateFilingPenaltyWaiverIndicator();
        result = result * 59 + ($lateFilingPenaltyWaiverIndicator == null ? 43 : $lateFilingPenaltyWaiverIndicator.hashCode());
        String $lupaSourceAdmissionIndicator = this.getLupaSourceAdmissionIndicator();
        result = result * 59 + ($lupaSourceAdmissionIndicator == null ? 43 : $lupaSourceAdmissionIndicator.hashCode());
        LocalDate $noticeReceiptDate = this.getNoticeReceiptDate();
        result = result * 59 + ($noticeReceiptDate == null ? 43 : ((Object)$noticeReceiptDate).hashCode());
        String $partialEpisodePaymentIndicator = this.getPartialEpisodePaymentIndicator();
        result = result * 59 + ($partialEpisodePaymentIndicator == null ? 43 : $partialEpisodePaymentIndicator.hashCode());
        BigDecimal $priorOutlierTotal = this.getPriorOutlierTotal();
        result = result * 59 + ($priorOutlierTotal == null ? 43 : ((Object)$priorOutlierTotal).hashCode());
        BigDecimal $priorPaymentTotal = this.getPriorPaymentTotal();
        result = result * 59 + ($priorPaymentTotal == null ? 43 : ((Object)$priorPaymentTotal).hashCode());
        List<RevenueLineData> $revenueLines = this.getRevenueLines();
        result = result * 59 + ($revenueLines == null ? 43 : ((Object)$revenueLines).hashCode());
        LocalDate $serviceFromDate = this.getServiceFromDate();
        result = result * 59 + ($serviceFromDate == null ? 43 : ((Object)$serviceFromDate).hashCode());
        LocalDate $serviceThroughDate = this.getServiceThroughDate();
        result = result * 59 + ($serviceThroughDate == null ? 43 : ((Object)$serviceThroughDate).hashCode());
        String $typeOfBill = this.getTypeOfBill();
        result = result * 59 + ($typeOfBill == null ? 43 : $typeOfBill.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HhaClaimData(adjustmentIndicator=" + this.getAdjustmentIndicator() + ", admissionDate=" + this.getAdmissionDate() + ", hhrgInputCode=" + this.getHhrgInputCode() + ", hhrgNumberOfDays=" + this.getHhrgNumberOfDays() + ", initialPaymentQualityReportingProgramIndicator=" + this.getInitialPaymentQualityReportingProgramIndicator() + ", lateFilingPenaltyWaiverIndicator=" + this.getLateFilingPenaltyWaiverIndicator() + ", lupaSourceAdmissionIndicator=" + this.getLupaSourceAdmissionIndicator() + ", noticeReceiptDate=" + this.getNoticeReceiptDate() + ", partialEpisodePaymentIndicator=" + this.getPartialEpisodePaymentIndicator() + ", priorOutlierTotal=" + this.getPriorOutlierTotal() + ", priorPaymentTotal=" + this.getPriorPaymentTotal() + ", revenueLines=" + this.getRevenueLines() + ", serviceFromDate=" + this.getServiceFromDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ", typeOfBill=" + this.getTypeOfBill() + ")";
    }

    @Generated
    public HhaClaimData() {
    }
}

