/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import lombok.Generated;

@Schema(description="The HHA prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-INPUT-DATA", value="<structure>")})})
public class HhaPaymentData
extends PaymentData {
    @BigDecimalScale
    @NotNull
    @Schema(description="The payment amount calculated by the Pricer for the Health Insurance Prospective Payment System Code (HIPPS) code.", example="2129.06", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-HRG-PAY", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal hhrgPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9999")
    @Digits(integer=2, fraction=4)
    @NotNull
    @Schema(description="The weight used to determine the payment amount on the claim.", example="12.5932", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-HRG-WGTS", value="PIC 9(02)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.9999") @Digits(integer=2, fraction=4) @NotNull @FixedValue BigDecimal hhrgWeight = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale
    @Schema(description="The late submission penalty amount.", example="50.20", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-LATE-SUB-PEN-AMT", value="PIC 9(9)V9(2)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal lateSubmissionPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The outlier payment amount in addition to any HRG payment amounts.", example="3500.29", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-OUTLIER-PAYMENT", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPayment = BigDecimalUtils.ZERO;
    @ArraySchema(arraySchema=@Schema(description="The revenue data."), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-DATA", value="<structure>")})})
    @NotNull
    @Size(max=6, min=6)
    @Valid
    private @NotNull @Size(max=6, min=6) @Valid List<@NotNull RevenuePaymentData> revenuePayments;
    @BigDecimalScale
    @NotNull
    @Schema(description="The Home Health PPS payment without applying any provider-specific adjustments.", example="995.29", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-PPS-STD-VALUE", value="PIC 9(9)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal standardizedPayment = BigDecimalUtils.ZERO;
    @Max(value=99999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The total number of visits used to determine if the claim must be paid as a low-utilization payment adjustment (LUPA).", example="9", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-SUM1-6-QTY-ALL", value="PIC 9(05)")})})
    private @Max(value=99999L) @Min(value=0L) @NotNull int totalQuantityOfCoveredVisits;
    @BigDecimalScale
    @Schema(description="The value-based purchasing (VBP) adjustment amount.", example="152.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-VBP-ADJ-AMT", value="PIC S9(9)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal valueBasedPurchasingAdjustmentAmount = BigDecimalUtils.ZERO;

    @Generated
    public BigDecimal getHhrgPayment() {
        return this.hhrgPayment;
    }

    @Generated
    public BigDecimal getHhrgWeight() {
        return this.hhrgWeight;
    }

    @Generated
    public BigDecimal getLateSubmissionPenaltyAmount() {
        return this.lateSubmissionPenaltyAmount;
    }

    @Generated
    public BigDecimal getOutlierPayment() {
        return this.outlierPayment;
    }

    @Generated
    public List<@NotNull RevenuePaymentData> getRevenuePayments() {
        return this.revenuePayments;
    }

    @Generated
    public BigDecimal getStandardizedPayment() {
        return this.standardizedPayment;
    }

    @Generated
    public int getTotalQuantityOfCoveredVisits() {
        return this.totalQuantityOfCoveredVisits;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingAdjustmentAmount() {
        return this.valueBasedPurchasingAdjustmentAmount;
    }

    @Generated
    public void setHhrgPayment(BigDecimal hhrgPayment) {
        this.hhrgPayment = hhrgPayment;
    }

    @Generated
    public void setHhrgWeight(BigDecimal hhrgWeight) {
        this.hhrgWeight = hhrgWeight;
    }

    @Generated
    public void setLateSubmissionPenaltyAmount(BigDecimal lateSubmissionPenaltyAmount) {
        this.lateSubmissionPenaltyAmount = lateSubmissionPenaltyAmount;
    }

    @Generated
    public void setOutlierPayment(BigDecimal outlierPayment) {
        this.outlierPayment = outlierPayment;
    }

    @Generated
    public void setRevenuePayments(List<@NotNull RevenuePaymentData> revenuePayments) {
        this.revenuePayments = revenuePayments;
    }

    @Generated
    public void setStandardizedPayment(BigDecimal standardizedPayment) {
        this.standardizedPayment = standardizedPayment;
    }

    @Generated
    public void setTotalQuantityOfCoveredVisits(int totalQuantityOfCoveredVisits) {
        this.totalQuantityOfCoveredVisits = totalQuantityOfCoveredVisits;
    }

    @Generated
    public void setValueBasedPurchasingAdjustmentAmount(BigDecimal valueBasedPurchasingAdjustmentAmount) {
        this.valueBasedPurchasingAdjustmentAmount = valueBasedPurchasingAdjustmentAmount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HhaPaymentData)) {
            return false;
        }
        HhaPaymentData other = (HhaPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalQuantityOfCoveredVisits() != other.getTotalQuantityOfCoveredVisits()) {
            return false;
        }
        BigDecimal this$hhrgPayment = this.getHhrgPayment();
        BigDecimal other$hhrgPayment = other.getHhrgPayment();
        if (this$hhrgPayment == null ? other$hhrgPayment != null : !((Object)this$hhrgPayment).equals(other$hhrgPayment)) {
            return false;
        }
        BigDecimal this$hhrgWeight = this.getHhrgWeight();
        BigDecimal other$hhrgWeight = other.getHhrgWeight();
        if (this$hhrgWeight == null ? other$hhrgWeight != null : !((Object)this$hhrgWeight).equals(other$hhrgWeight)) {
            return false;
        }
        BigDecimal this$lateSubmissionPenaltyAmount = this.getLateSubmissionPenaltyAmount();
        BigDecimal other$lateSubmissionPenaltyAmount = other.getLateSubmissionPenaltyAmount();
        if (this$lateSubmissionPenaltyAmount == null ? other$lateSubmissionPenaltyAmount != null : !((Object)this$lateSubmissionPenaltyAmount).equals(other$lateSubmissionPenaltyAmount)) {
            return false;
        }
        BigDecimal this$outlierPayment = this.getOutlierPayment();
        BigDecimal other$outlierPayment = other.getOutlierPayment();
        if (this$outlierPayment == null ? other$outlierPayment != null : !((Object)this$outlierPayment).equals(other$outlierPayment)) {
            return false;
        }
        List<RevenuePaymentData> this$revenuePayments = this.getRevenuePayments();
        List<RevenuePaymentData> other$revenuePayments = other.getRevenuePayments();
        if (this$revenuePayments == null ? other$revenuePayments != null : !((Object)this$revenuePayments).equals(other$revenuePayments)) {
            return false;
        }
        BigDecimal this$standardizedPayment = this.getStandardizedPayment();
        BigDecimal other$standardizedPayment = other.getStandardizedPayment();
        if (this$standardizedPayment == null ? other$standardizedPayment != null : !((Object)this$standardizedPayment).equals(other$standardizedPayment)) {
            return false;
        }
        BigDecimal this$valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
        BigDecimal other$valueBasedPurchasingAdjustmentAmount = other.getValueBasedPurchasingAdjustmentAmount();
        return !(this$valueBasedPurchasingAdjustmentAmount == null ? other$valueBasedPurchasingAdjustmentAmount != null : !((Object)this$valueBasedPurchasingAdjustmentAmount).equals(other$valueBasedPurchasingAdjustmentAmount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HhaPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalQuantityOfCoveredVisits();
        BigDecimal $hhrgPayment = this.getHhrgPayment();
        result = result * 59 + ($hhrgPayment == null ? 43 : ((Object)$hhrgPayment).hashCode());
        BigDecimal $hhrgWeight = this.getHhrgWeight();
        result = result * 59 + ($hhrgWeight == null ? 43 : ((Object)$hhrgWeight).hashCode());
        BigDecimal $lateSubmissionPenaltyAmount = this.getLateSubmissionPenaltyAmount();
        result = result * 59 + ($lateSubmissionPenaltyAmount == null ? 43 : ((Object)$lateSubmissionPenaltyAmount).hashCode());
        BigDecimal $outlierPayment = this.getOutlierPayment();
        result = result * 59 + ($outlierPayment == null ? 43 : ((Object)$outlierPayment).hashCode());
        List<RevenuePaymentData> $revenuePayments = this.getRevenuePayments();
        result = result * 59 + ($revenuePayments == null ? 43 : ((Object)$revenuePayments).hashCode());
        BigDecimal $standardizedPayment = this.getStandardizedPayment();
        result = result * 59 + ($standardizedPayment == null ? 43 : ((Object)$standardizedPayment).hashCode());
        BigDecimal $valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
        result = result * 59 + ($valueBasedPurchasingAdjustmentAmount == null ? 43 : ((Object)$valueBasedPurchasingAdjustmentAmount).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HhaPaymentData(hhrgPayment=" + this.getHhrgPayment() + ", hhrgWeight=" + this.getHhrgWeight() + ", lateSubmissionPenaltyAmount=" + this.getLateSubmissionPenaltyAmount() + ", outlierPayment=" + this.getOutlierPayment() + ", revenuePayments=" + this.getRevenuePayments() + ", standardizedPayment=" + this.getStandardizedPayment() + ", totalQuantityOfCoveredVisits=" + this.getTotalQuantityOfCoveredVisits() + ", valueBasedPurchasingAdjustmentAmount=" + this.getValueBasedPurchasingAdjustmentAmount() + ")";
    }

    @Generated
    public HhaPaymentData() {
    }
}

