/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.LocalDate;
import lombok.Generated;

@Schema(description="An input revenue line.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-DATA", value="<structure>")})})
public class RevenueLineData {
    @Schema(description="The earliest line item date for the corresponding revenue code.", example="2021-06-22", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-EARLIEST-DATE", value="PIC 9(08)")})})
    @StrictLocalDate
    private LocalDate earliestLineItemDate;
    @NotNull
    @Pattern(regexp="\\d{4}", message="must be four digits")
    @Schema(description="The associated revenue code.", example="0841", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-CODE", value="PIC X(04)")})})
    private @NotNull @Pattern(regexp="\\d{4}", message="must be four digits") String revenueCode;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The quantity of covered visits corresponding to the revenue code.", example="50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-QTY-COV-VISITS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int quantityOfCoveredVisits;
    @Max(value=99999L)
    @Min(value=0L)
    @Schema(description="The sum of the units reported on all covered lines corresponding to the revenue code.", example="32", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-QTY-OUTL-UNITS", value="PIC 9(05)")})})
    private @Max(value=99999L) @Min(value=0L) int quantityOfOutlierUnits;

    @Generated
    public LocalDate getEarliestLineItemDate() {
        return this.earliestLineItemDate;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public int getQuantityOfCoveredVisits() {
        return this.quantityOfCoveredVisits;
    }

    @Generated
    public int getQuantityOfOutlierUnits() {
        return this.quantityOfOutlierUnits;
    }

    @Generated
    public void setEarliestLineItemDate(LocalDate earliestLineItemDate) {
        this.earliestLineItemDate = earliestLineItemDate;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public void setQuantityOfCoveredVisits(int quantityOfCoveredVisits) {
        this.quantityOfCoveredVisits = quantityOfCoveredVisits;
    }

    @Generated
    public void setQuantityOfOutlierUnits(int quantityOfOutlierUnits) {
        this.quantityOfOutlierUnits = quantityOfOutlierUnits;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevenueLineData)) {
            return false;
        }
        RevenueLineData other = (RevenueLineData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQuantityOfCoveredVisits() != other.getQuantityOfCoveredVisits()) {
            return false;
        }
        if (this.getQuantityOfOutlierUnits() != other.getQuantityOfOutlierUnits()) {
            return false;
        }
        LocalDate this$earliestLineItemDate = this.getEarliestLineItemDate();
        LocalDate other$earliestLineItemDate = other.getEarliestLineItemDate();
        if (this$earliestLineItemDate == null ? other$earliestLineItemDate != null : !((Object)this$earliestLineItemDate).equals(other$earliestLineItemDate)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        return !(this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevenueLineData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQuantityOfCoveredVisits();
        result = result * 59 + this.getQuantityOfOutlierUnits();
        LocalDate $earliestLineItemDate = this.getEarliestLineItemDate();
        result = result * 59 + ($earliestLineItemDate == null ? 43 : ((Object)$earliestLineItemDate).hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RevenueLineData(earliestLineItemDate=" + this.getEarliestLineItemDate() + ", revenueCode=" + this.getRevenueCode() + ", quantityOfCoveredVisits=" + this.getQuantityOfCoveredVisits() + ", quantityOfOutlierUnits=" + this.getQuantityOfOutlierUnits() + ")";
    }

    @Generated
    public RevenueLineData() {
    }
}

