/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="An output revenue line payment.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-DATA", value="<structure>")})})
public class RevenuePaymentData {
    @BigDecimalScale
    @Schema(description="The add-on amount to be applied to the earliest line item date with the corresponding revenue code.", example="362.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-ADD-ON-VISIT-AMT", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal addOnVisitAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The dollar amount of the low-utilization payment adjustment (LUPA) payment or the dollar amounts for the purposes of calculating an outlier payment.", example="1200.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-COST", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal cost = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="999999999.99")
    @Digits(integer=9, fraction=2)
    @Schema(description="The dollar rate used to calculate the low-utilization payment adjustment (LUPA) payment or the dollar amount for the purposes of calculating an outlier payment.", example="177.84", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-DOLL-RATE", value="PIC 9(09)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="999999999.99") @Digits(integer=9, fraction=2) @FixedValue BigDecimal dollarRate = BigDecimalUtils.ZERO;
    @NotNull
    @Pattern(regexp="\\d{4}", message="must be four digits")
    @Schema(description="The associated revenue code.", example="0841", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="HHA-REVENUE-CODE", value="PIC X(04)")})})
    private @NotNull @Pattern(regexp="\\d{4}", message="must be four digits") String revenueCode;

    @Generated
    public BigDecimal getAddOnVisitAmount() {
        return this.addOnVisitAmount;
    }

    @Generated
    public BigDecimal getCost() {
        return this.cost;
    }

    @Generated
    public BigDecimal getDollarRate() {
        return this.dollarRate;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public void setAddOnVisitAmount(BigDecimal addOnVisitAmount) {
        this.addOnVisitAmount = addOnVisitAmount;
    }

    @Generated
    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    @Generated
    public void setDollarRate(BigDecimal dollarRate) {
        this.dollarRate = dollarRate;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevenuePaymentData)) {
            return false;
        }
        RevenuePaymentData other = (RevenuePaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$addOnVisitAmount = this.getAddOnVisitAmount();
        BigDecimal other$addOnVisitAmount = other.getAddOnVisitAmount();
        if (this$addOnVisitAmount == null ? other$addOnVisitAmount != null : !((Object)this$addOnVisitAmount).equals(other$addOnVisitAmount)) {
            return false;
        }
        BigDecimal this$cost = this.getCost();
        BigDecimal other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        BigDecimal this$dollarRate = this.getDollarRate();
        BigDecimal other$dollarRate = other.getDollarRate();
        if (this$dollarRate == null ? other$dollarRate != null : !((Object)this$dollarRate).equals(other$dollarRate)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        return !(this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevenuePaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $addOnVisitAmount = this.getAddOnVisitAmount();
        result = result * 59 + ($addOnVisitAmount == null ? 43 : ((Object)$addOnVisitAmount).hashCode());
        BigDecimal $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        BigDecimal $dollarRate = this.getDollarRate();
        result = result * 59 + ($dollarRate == null ? 43 : ((Object)$dollarRate).hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RevenuePaymentData(addOnVisitAmount=" + this.getAddOnVisitAmount() + ", cost=" + this.getCost() + ", dollarRate=" + this.getDollarRate() + ", revenueCode=" + this.getRevenueCode() + ")";
    }

    @Generated
    public RevenuePaymentData() {
    }
}

