/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hha.core.models.RevenueRateEntry;
import gov.cms.fiss.pricers.hha.core.tables.DataTables;
import gov.cms.fiss.pricers.hha.core.tables.RevenueEntry;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class HhaPricerContext
extends CalculationContext<HhaClaimPricingRequest, HhaClaimPricingResponse> {
    public static final BigDecimal USABLE_RAP_MODIFIER = new BigDecimal("0.20");
    public static final int RTC_ADJUSTMENT_INDICATOR_2 = 2;
    public static final int RTC_ADJUSTMENT_INDICATOR_4 = 4;
    private static final BigDecimal RURAL_NOOP = new BigDecimal("1.000");
    @JsonIgnore
    private final DataTables dataTables;
    private final List<@NotNull RevenueRateEntry> revenueData = new ArrayList<RevenueRateEntry>();
    private boolean partialEpisodePaymentCalculated = false;
    private Integer returnCodeAdjustmentIndicator = 0;
    private BigDecimal wsStdvLupaAddonFac = new BigDecimal("0.0000");
    @FixedValue
    private BigDecimal federalEpisodeRateAmount = BigDecimalUtils.ZERO;
    private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
    private BigDecimal pretotalPepPayment = BigDecimalUtils.ZERO;
    private String ruralCategory = "";
    private int hrgThreshold;
    private BigDecimal cbsaWageIndex = new BigDecimal("0.0000");
    private BigDecimal temporaryPaymentTotal;

    protected HhaPricerContext(HhaClaimPricingRequest input, HhaClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeContext();
    }

    protected void initializeContext() {
        for (RevenueLineData inputRevenueData : this.getRevenueLines()) {
            RevenuePaymentData outputRevenueData = new RevenuePaymentData();
            outputRevenueData.setRevenueCode(inputRevenueData.getRevenueCode());
            this.getRevenuePayments().add(outputRevenueData);
        }
    }

    public HhaClaimData getClaimData() {
        return (HhaClaimData)((HhaClaimPricingRequest)this.getInput()).getClaimData();
    }

    public List<RevenueLineData> getRevenueLines() {
        if (this.getClaimData().getRevenueLines() == null) {
            this.getClaimData().setRevenueLines(new ArrayList<RevenueLineData>());
        }
        return this.getClaimData().getRevenueLines();
    }

    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((HhaClaimPricingRequest)this.getInput()).getProviderData();
    }

    public HhaPaymentData getPaymentData() {
        return (HhaPaymentData)((HhaClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    public List<RevenuePaymentData> getRevenuePayments() {
        if (this.getPaymentData().getRevenuePayments() == null) {
            this.getPaymentData().setRevenuePayments(new ArrayList<RevenuePaymentData>());
        }
        return this.getPaymentData().getRevenuePayments();
    }

    public abstract @FixedValue BigDecimal getRateAmountChecked();

    public abstract BigDecimal getThresholdAmountChecked();

    public abstract @FixedValue BigDecimal getRateAmountUnchecked();

    public abstract BigDecimal getThresholdAmountUnchecked();

    public abstract BigDecimal getStandardizedRuralMultiplier();

    public abstract BigDecimal getStandardValueAmount();

    public abstract BigDecimal getLaborPercent();

    public abstract BigDecimal getNonLaborPercent();

    public abstract BigDecimal getLupaAddOnSkilledNursing();

    public abstract BigDecimal getLupaAddOnPhysicalTherapy();

    public abstract BigDecimal getLupaAddOnSpeechLanguagePathology();

    public abstract BigDecimal getLupaAddOnOccupationalTherapy();

    public abstract BigDecimal getOutlierLossSharingRatio();

    public abstract String getCalculationVersion();

    protected abstract @FixedValue BigDecimal getRuralAddOnA();

    protected abstract @FixedValue BigDecimal getRuralAddOnB();

    protected abstract @FixedValue BigDecimal getRuralAddOnC();

    public boolean checkReturnCode(ReturnCode code) {
        return code.getCode() == Integer.parseInt(((HhaClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode());
    }

    public void completeWithReturnCode(ReturnCode code) {
        this.applyReturnCode(code);
        this.setCalculationCompleted();
    }

    public void applyReturnCode(ReturnCode code) {
        ((HhaClaimPricingResponse)this.getOutput()).setReturnCodeData(code.toReturnCodeData());
    }

    public boolean usingDataCheck() {
        return StringUtils.equalsAny(this.getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "1");
    }

    public boolean isPartialEpisodePaymentIndicator() {
        return StringUtils.equals(((HhaClaimData)((HhaClaimPricingRequest)this.getInput()).getClaimData()).getPartialEpisodePaymentIndicator(), "Y");
    }

    public boolean isLateFilingPenaltyWaiverIndicator() {
        return StringUtils.equals(((HhaClaimData)((HhaClaimPricingRequest)this.getInput()).getClaimData()).getLateFilingPenaltyWaiverIndicator(), "Y");
    }

    public boolean isRural(String revenueCode) {
        return StringUtils.equalsAny(revenueCode, "50001", "50002", "50005", "50007", "50025", "50028", "50031", "50035", "50036", "50037", "50041", "50045", "50047", "50048", "50050", "50056", "50057", "50066", "50068", "50071", "50073", "50080", "50084", "50087", "50089", "50090", "50091", "50103", "50104", "50111", "50115", "50117", "50118", "50120", "50121", "50139", "50146", "50147", "50149", "50151", "50164", "50165", "50168", "50169", "50173", "50174", "50177", "50180", "50182", "50183") || StringUtils.startsWith(revenueCode, "999");
    }

    public RevenueRateEntry getRateEntry(String code) {
        LocalDate date = this.getClaimData().getServiceThroughDate();
        @FixedValue RevenueEntry revenueEntry = this.dataTables.getRevenueEntry(code, date);
        if (revenueEntry == null) {
            return null;
        }
        String revenueCode = revenueEntry.getCode();
        @FixedValue RevenueRateEntry rateEntry = new RevenueRateEntry(revenueCode, revenueEntry.getNonruralUnitDollarRate(), revenueEntry.getNonruralDollarRate(), revenueEntry.getNonruralDollarRate());
        if (this.isRural(revenueCode)) {
            if (this.usingDataCheck()) {
                rateEntry.setDollarRate(revenueEntry.getRuralDollarRate());
                rateEntry.setDollarRateUnits(revenueEntry.getRuralUnitDollarRate());
            } else {
                rateEntry.setDollarRate(revenueEntry.getRuralUnsubmittedDollarRate());
                rateEntry.setDollarRateUnits(revenueEntry.getRuralUnsubmittedUnitDollarRate());
            }
        } else if (!this.usingDataCheck()) {
            rateEntry.setDollarRate(revenueEntry.getNonruralUnsubmittedDollarRate());
            rateEntry.setDollarRateUnits(revenueEntry.getNonruralUnsubmittedUnitDollarRate());
        }
        return rateEntry;
    }

    public boolean isValidPaymentIndicator() {
        return StringUtils.equalsAny(this.getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "1", "2", "3");
    }

    public boolean isUsablePaymentIndicator() {
        return StringUtils.equalsAny(this.getClaimData().getInitialPaymentQualityReportingProgramIndicator(), "0", "2");
    }

    public boolean isPartialEpisodePaymentCalculated() {
        return this.partialEpisodePaymentCalculated;
    }

    public void setPartialEpisodePaymentCalculated() {
        this.partialEpisodePaymentCalculated = true;
    }

    public BigDecimal calculateAdjustedCost(BigDecimal initialCost) {
        BigDecimal fedLaborAdj = this.getCbsaWageIndex().multiply(this.getLaborPercent()).multiply(initialCost).setScale(2, RoundingMode.HALF_UP);
        BigDecimal fedNonLaborAdj = this.getNonLaborPercent().multiply(initialCost).setScale(2, RoundingMode.HALF_UP);
        return fedLaborAdj.add(fedNonLaborAdj);
    }

    public BigDecimal calculatePaymentBasis() {
        return this.calculateAdjustedCost(this.getPaymentData().getHhrgWeight().multiply(this.getFederalEpisodeRateAmount()).setScale(2, RoundingMode.HALF_UP));
    }

    public boolean hasReturnCode(ReturnCode expectedCode) {
        return expectedCode.equals((Object)ReturnCode.fromCode(Integer.parseInt(((HhaClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode())));
    }

    public @FixedValue BigDecimal getRuralAddon() {
        switch (this.getRuralCategory()) {
            case "A": {
                return this.getRuralAddOnA();
            }
            case "B": {
                return this.getRuralAddOnB();
            }
            case "C": {
                return this.getRuralAddOnC();
            }
        }
        return RURAL_NOOP;
    }

    public boolean isBillTypeClaim() {
        return StringUtils.equalsAny(this.getClaimData().getTypeOfBill(), "327", "329", "32F", "32G", "32H", "32I", "32J", "32K", "32M", "32Q", "32P");
    }

    public boolean isBillTypeRap() {
        return StringUtils.equalsAny(this.getClaimData().getTypeOfBill(), "322");
    }

    public boolean isBillTypeValid() {
        return this.isBillTypeClaim() || this.isBillTypeRap();
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public List<@NotNull RevenueRateEntry> getRevenueData() {
        return this.revenueData;
    }

    @Generated
    public Integer getReturnCodeAdjustmentIndicator() {
        return this.returnCodeAdjustmentIndicator;
    }

    @Generated
    public void setReturnCodeAdjustmentIndicator(Integer returnCodeAdjustmentIndicator) {
        this.returnCodeAdjustmentIndicator = returnCodeAdjustmentIndicator;
    }

    @Generated
    public BigDecimal getWsStdvLupaAddonFac() {
        return this.wsStdvLupaAddonFac;
    }

    @Generated
    public void setWsStdvLupaAddonFac(BigDecimal wsStdvLupaAddonFac) {
        this.wsStdvLupaAddonFac = wsStdvLupaAddonFac;
    }

    @Generated
    public BigDecimal getFederalEpisodeRateAmount() {
        return this.federalEpisodeRateAmount;
    }

    @Generated
    public void setFederalEpisodeRateAmount(BigDecimal federalEpisodeRateAmount) {
        this.federalEpisodeRateAmount = federalEpisodeRateAmount;
    }

    @Generated
    public BigDecimal getOutlierThresholdAmount() {
        return this.outlierThresholdAmount;
    }

    @Generated
    public void setOutlierThresholdAmount(BigDecimal outlierThresholdAmount) {
        this.outlierThresholdAmount = outlierThresholdAmount;
    }

    @Generated
    public BigDecimal getPretotalPepPayment() {
        return this.pretotalPepPayment;
    }

    @Generated
    public void setPretotalPepPayment(BigDecimal pretotalPepPayment) {
        this.pretotalPepPayment = pretotalPepPayment;
    }

    @Generated
    public String getRuralCategory() {
        return this.ruralCategory;
    }

    @Generated
    public void setRuralCategory(String ruralCategory) {
        this.ruralCategory = ruralCategory;
    }

    @Generated
    public int getHrgThreshold() {
        return this.hrgThreshold;
    }

    @Generated
    public void setHrgThreshold(int hrgThreshold) {
        this.hrgThreshold = hrgThreshold;
    }

    @Generated
    public BigDecimal getCbsaWageIndex() {
        return this.cbsaWageIndex;
    }

    @Generated
    public void setCbsaWageIndex(BigDecimal cbsaWageIndex) {
        this.cbsaWageIndex = cbsaWageIndex;
    }

    @Generated
    public BigDecimal getTemporaryPaymentTotal() {
        return this.temporaryPaymentTotal;
    }

    @Generated
    public void setTemporaryPaymentTotal(BigDecimal temporaryPaymentTotal) {
        this.temporaryPaymentTotal = temporaryPaymentTotal;
    }
}

