/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.models.RevenueRateEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class CalculateStandardValue
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    private static final BigDecimal THIRTY_DAYS = new BigDecimal("30.00000000");
    private static final BigDecimal ONE = new BigDecimal("1.00");

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setStandardizedPayment(BigDecimalUtils.ZERO);
        if (paymentData.getTotalQuantityOfCoveredVisits() < 5 && !calculationContext.isBillTypeRap()) {
            this.calculateLupaStandardValue(calculationContext);
        }
        if (paymentData.getTotalQuantityOfCoveredVisits() > 4 || calculationContext.isBillTypeRap()) {
            this.calculateNonLupaStandardValue(calculationContext);
        }
    }

    private void calculateLupaStandardValue(HhaPricerContext calculationContext) {
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal standardizedPaymentAmount = paymentData.getStandardizedPayment();
        List<RevenueLineData> inputRevenueData = calculationContext.getRevenueLines();
        List<RevenueRateEntry> revenueRateData = calculationContext.getRevenueData();
        List<RevenuePaymentData> outputRevenueData = paymentData.getRevenuePayments();
        for (int i2 = 0; i2 < inputRevenueData.size(); ++i2) {
            RevenueRateEntry revenueRateEntry = revenueRateData.get(i2);
            RevenuePaymentData outputRevenueEntry = outputRevenueData.get(i2);
            int quantityOfCoveredVisits = ObjectUtils.defaultIfNull(inputRevenueData.get(i2).getQuantityOfCoveredVisits(), 0);
            BigDecimal dollarRate = revenueRateEntry.getStandardValueDollarRate();
            if (quantityOfCoveredVisits > 0) {
                standardizedPaymentAmount = BigDecimal.valueOf(quantityOfCoveredVisits).multiply(dollarRate).add(standardizedPaymentAmount).setScale(2, RoundingMode.HALF_UP);
            }
            if (!BigDecimalUtils.isGreaterThanZero(outputRevenueEntry.getAddOnVisitAmount())) continue;
            standardizedPaymentAmount = dollarRate.multiply(calculationContext.getWsStdvLupaAddonFac()).add(standardizedPaymentAmount).setScale(2, RoundingMode.HALF_UP);
        }
        standardizedPaymentAmount = standardizedPaymentAmount.multiply(calculationContext.getStandardizedRuralMultiplier()).setScale(2, RoundingMode.HALF_UP);
        paymentData.setStandardizedPayment(standardizedPaymentAmount);
    }

    private void calculateNonLupaStandardValue(HhaPricerContext calculationContext) {
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal laborPercent = calculationContext.getLaborPercent();
        BigDecimal percentOfDays = BigDecimal.valueOf(calculationContext.getClaimData().getHhrgNumberOfDays().intValue()).divide(THIRTY_DAYS, 8, RoundingMode.DOWN);
        BigDecimal amount = paymentData.getHhrgWeight().multiply(calculationContext.getStandardValueAmount()).multiply(percentOfDays).multiply(calculationContext.getStandardizedRuralMultiplier()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal outlier = paymentData.getOutlierPayment().divide(laborPercent.multiply(calculationContext.getCbsaWageIndex()).add(ONE.subtract(laborPercent)), 2, RoundingMode.HALF_UP);
        BigDecimal standardizedPaymentAmount = amount.add(outlier);
        if (calculationContext.isBillTypeRap()) {
            standardizedPaymentAmount = !calculationContext.isUsablePaymentIndicator() ? BigDecimalUtils.ZERO : standardizedPaymentAmount.multiply(HhaPricerContext.USABLE_RAP_MODIFIER).setScale(2, RoundingMode.HALF_UP);
        }
        paymentData.setStandardizedPayment(standardizedPaymentAmount);
    }
}

