/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.calculate_value_based_purchasing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaInpatientProviderData;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.stream.Stream;

public class AddRevenueData
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        return BigDecimalUtils.isZero(paymentData.getHhrgPayment()) && this.isLupaPayment(Integer.parseInt(((HhaClaimPricingResponse)calculationContext.getOutput()).getReturnCodeData().getCode()));
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        BigDecimal vbpAdjustmentFactor = ((HhaInpatientProviderData)((HhaClaimPricingRequest)calculationContext.getInput()).getProviderData()).getVbpAdjustment();
        BigDecimal totalPayment = calculationContext.getPaymentData().getTotalPayment();
        for (RevenuePaymentData outputRevenueEntry : calculationContext.getPaymentData().getRevenuePayments()) {
            BigDecimal cost = outputRevenueEntry.getCost().multiply(vbpAdjustmentFactor).setScale(2, RoundingMode.HALF_UP);
            BigDecimal addOnAmount = outputRevenueEntry.getAddOnVisitAmount().multiply(vbpAdjustmentFactor).setScale(2, RoundingMode.HALF_UP);
            totalPayment = totalPayment.add(cost).add(addOnAmount);
            outputRevenueEntry.setCost(cost);
            outputRevenueEntry.setAddOnVisitAmount(addOnAmount);
        }
        totalPayment = totalPayment.setScale(2, RoundingMode.HALF_UP);
        calculationContext.getPaymentData().setTotalPayment(totalPayment);
    }

    private boolean isLupaPayment(Integer returnCode) {
        return Stream.of(ReturnCode.LUPA_PAYMENT_6, ReturnCode.LUPA_PAYMENT_WITH_ADDON_14).anyMatch(rtc -> rtc.is(returnCode));
    }
}

