/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.rules2025;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaInpatientProviderData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.resources.HhaCbsaUtil;
import java.util.Objects;

public class ValidateCountyCode2025
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        String cbsa = ((HhaInpatientProviderData)((HhaClaimPricingRequest)calculationContext.getInput()).getProviderData()).getCbsaActualGeographicLocation();
        return HhaCbsaUtil.sanitizeCbsa(cbsa).length() == 2;
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        String ruralCategory = calculationContext.getDataTables().getAddOnCategory(calculationContext.getProviderData().getCountyCode());
        calculationContext.setRuralCategory(Objects.requireNonNullElse(ruralCategory, ""));
    }
}

