/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.hha.core.tables.HrgEntry;
import java.util.List;
import java.util.Map;

public class HrgLookupProvider {
    private static final String CSV_FILE_PATTERN = "/hrg-%s.csv";
    private final CsvContentReader<HrgEntry> contentProvider = new CsvContentReader<HrgEntry>(HrgEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public HrgLookupProvider(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, HrgEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, HrgEntry> generate(String csvFile) {
        List<HrgEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(HrgEntry::getCode, content);
    }
}

