/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=RevenueEntryBuilder.class)
@JsonPropertyOrder(value={"code", "effectiveDate", "nonruralDollarRate", "ruralDollarRate", "nonruralUnsubmittedDollarRate", "ruralUnsubmittedDollarRate", "nonruralUnitDollarRate", "ruralUnitDollarRate", "nonruralUnsubmittedUnitDollarRate", "ruralUnsubmittedUnitDollarRate"})
@Immutable
public class RevenueEntry
implements Comparable<RevenueEntry> {
    @Pattern(regexp="\\d{4}")
    private final @Pattern(regexp="\\d{4}") String code;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal nonruralDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal ruralDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal nonruralUnsubmittedDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal ruralUnsubmittedDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal nonruralUnitDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal ruralUnitDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal nonruralUnsubmittedUnitDollarRate;
    @Digits(integer=7, fraction=2)
    @BigDecimalScale
    private final @Digits(integer=7, fraction=2) BigDecimal ruralUnsubmittedUnitDollarRate;

    @Override
    public int compareTo(@Nonnull RevenueEntry o) {
        return Comparator.comparing(RevenueEntry::getEffectiveDate).compare(this, o);
    }

    @Generated
    RevenueEntry(String code, LocalDate effectiveDate, BigDecimal nonruralDollarRate, BigDecimal ruralDollarRate, BigDecimal nonruralUnsubmittedDollarRate, BigDecimal ruralUnsubmittedDollarRate, BigDecimal nonruralUnitDollarRate, BigDecimal ruralUnitDollarRate, BigDecimal nonruralUnsubmittedUnitDollarRate, BigDecimal ruralUnsubmittedUnitDollarRate) {
        this.code = code;
        this.effectiveDate = effectiveDate;
        this.nonruralDollarRate = nonruralDollarRate;
        this.ruralDollarRate = ruralDollarRate;
        this.nonruralUnsubmittedDollarRate = nonruralUnsubmittedDollarRate;
        this.ruralUnsubmittedDollarRate = ruralUnsubmittedDollarRate;
        this.nonruralUnitDollarRate = nonruralUnitDollarRate;
        this.ruralUnitDollarRate = ruralUnitDollarRate;
        this.nonruralUnsubmittedUnitDollarRate = nonruralUnsubmittedUnitDollarRate;
        this.ruralUnsubmittedUnitDollarRate = ruralUnsubmittedUnitDollarRate;
    }

    @Generated
    public static RevenueEntryBuilder builder() {
        return new RevenueEntryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevenueEntry)) {
            return false;
        }
        RevenueEntry other = (RevenueEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        BigDecimal this$nonruralDollarRate = this.getNonruralDollarRate();
        BigDecimal other$nonruralDollarRate = other.getNonruralDollarRate();
        if (this$nonruralDollarRate == null ? other$nonruralDollarRate != null : !((Object)this$nonruralDollarRate).equals(other$nonruralDollarRate)) {
            return false;
        }
        BigDecimal this$ruralDollarRate = this.getRuralDollarRate();
        BigDecimal other$ruralDollarRate = other.getRuralDollarRate();
        if (this$ruralDollarRate == null ? other$ruralDollarRate != null : !((Object)this$ruralDollarRate).equals(other$ruralDollarRate)) {
            return false;
        }
        BigDecimal this$nonruralUnsubmittedDollarRate = this.getNonruralUnsubmittedDollarRate();
        BigDecimal other$nonruralUnsubmittedDollarRate = other.getNonruralUnsubmittedDollarRate();
        if (this$nonruralUnsubmittedDollarRate == null ? other$nonruralUnsubmittedDollarRate != null : !((Object)this$nonruralUnsubmittedDollarRate).equals(other$nonruralUnsubmittedDollarRate)) {
            return false;
        }
        BigDecimal this$ruralUnsubmittedDollarRate = this.getRuralUnsubmittedDollarRate();
        BigDecimal other$ruralUnsubmittedDollarRate = other.getRuralUnsubmittedDollarRate();
        if (this$ruralUnsubmittedDollarRate == null ? other$ruralUnsubmittedDollarRate != null : !((Object)this$ruralUnsubmittedDollarRate).equals(other$ruralUnsubmittedDollarRate)) {
            return false;
        }
        BigDecimal this$nonruralUnitDollarRate = this.getNonruralUnitDollarRate();
        BigDecimal other$nonruralUnitDollarRate = other.getNonruralUnitDollarRate();
        if (this$nonruralUnitDollarRate == null ? other$nonruralUnitDollarRate != null : !((Object)this$nonruralUnitDollarRate).equals(other$nonruralUnitDollarRate)) {
            return false;
        }
        BigDecimal this$ruralUnitDollarRate = this.getRuralUnitDollarRate();
        BigDecimal other$ruralUnitDollarRate = other.getRuralUnitDollarRate();
        if (this$ruralUnitDollarRate == null ? other$ruralUnitDollarRate != null : !((Object)this$ruralUnitDollarRate).equals(other$ruralUnitDollarRate)) {
            return false;
        }
        BigDecimal this$nonruralUnsubmittedUnitDollarRate = this.getNonruralUnsubmittedUnitDollarRate();
        BigDecimal other$nonruralUnsubmittedUnitDollarRate = other.getNonruralUnsubmittedUnitDollarRate();
        if (this$nonruralUnsubmittedUnitDollarRate == null ? other$nonruralUnsubmittedUnitDollarRate != null : !((Object)this$nonruralUnsubmittedUnitDollarRate).equals(other$nonruralUnsubmittedUnitDollarRate)) {
            return false;
        }
        BigDecimal this$ruralUnsubmittedUnitDollarRate = this.getRuralUnsubmittedUnitDollarRate();
        BigDecimal other$ruralUnsubmittedUnitDollarRate = other.getRuralUnsubmittedUnitDollarRate();
        return !(this$ruralUnsubmittedUnitDollarRate == null ? other$ruralUnsubmittedUnitDollarRate != null : !((Object)this$ruralUnsubmittedUnitDollarRate).equals(other$ruralUnsubmittedUnitDollarRate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevenueEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        BigDecimal $nonruralDollarRate = this.getNonruralDollarRate();
        result = result * 59 + ($nonruralDollarRate == null ? 43 : ((Object)$nonruralDollarRate).hashCode());
        BigDecimal $ruralDollarRate = this.getRuralDollarRate();
        result = result * 59 + ($ruralDollarRate == null ? 43 : ((Object)$ruralDollarRate).hashCode());
        BigDecimal $nonruralUnsubmittedDollarRate = this.getNonruralUnsubmittedDollarRate();
        result = result * 59 + ($nonruralUnsubmittedDollarRate == null ? 43 : ((Object)$nonruralUnsubmittedDollarRate).hashCode());
        BigDecimal $ruralUnsubmittedDollarRate = this.getRuralUnsubmittedDollarRate();
        result = result * 59 + ($ruralUnsubmittedDollarRate == null ? 43 : ((Object)$ruralUnsubmittedDollarRate).hashCode());
        BigDecimal $nonruralUnitDollarRate = this.getNonruralUnitDollarRate();
        result = result * 59 + ($nonruralUnitDollarRate == null ? 43 : ((Object)$nonruralUnitDollarRate).hashCode());
        BigDecimal $ruralUnitDollarRate = this.getRuralUnitDollarRate();
        result = result * 59 + ($ruralUnitDollarRate == null ? 43 : ((Object)$ruralUnitDollarRate).hashCode());
        BigDecimal $nonruralUnsubmittedUnitDollarRate = this.getNonruralUnsubmittedUnitDollarRate();
        result = result * 59 + ($nonruralUnsubmittedUnitDollarRate == null ? 43 : ((Object)$nonruralUnsubmittedUnitDollarRate).hashCode());
        BigDecimal $ruralUnsubmittedUnitDollarRate = this.getRuralUnsubmittedUnitDollarRate();
        result = result * 59 + ($ruralUnsubmittedUnitDollarRate == null ? 43 : ((Object)$ruralUnsubmittedUnitDollarRate).hashCode());
        return result;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getNonruralDollarRate() {
        return this.nonruralDollarRate;
    }

    @Generated
    public BigDecimal getRuralDollarRate() {
        return this.ruralDollarRate;
    }

    @Generated
    public BigDecimal getNonruralUnsubmittedDollarRate() {
        return this.nonruralUnsubmittedDollarRate;
    }

    @Generated
    public BigDecimal getRuralUnsubmittedDollarRate() {
        return this.ruralUnsubmittedDollarRate;
    }

    @Generated
    public BigDecimal getNonruralUnitDollarRate() {
        return this.nonruralUnitDollarRate;
    }

    @Generated
    public BigDecimal getRuralUnitDollarRate() {
        return this.ruralUnitDollarRate;
    }

    @Generated
    public BigDecimal getNonruralUnsubmittedUnitDollarRate() {
        return this.nonruralUnsubmittedUnitDollarRate;
    }

    @Generated
    public BigDecimal getRuralUnsubmittedUnitDollarRate() {
        return this.ruralUnsubmittedUnitDollarRate;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class RevenueEntryBuilder {
        @Generated
        private String code;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal nonruralDollarRate;
        @Generated
        private BigDecimal ruralDollarRate;
        @Generated
        private BigDecimal nonruralUnsubmittedDollarRate;
        @Generated
        private BigDecimal ruralUnsubmittedDollarRate;
        @Generated
        private BigDecimal nonruralUnitDollarRate;
        @Generated
        private BigDecimal ruralUnitDollarRate;
        @Generated
        private BigDecimal nonruralUnsubmittedUnitDollarRate;
        @Generated
        private BigDecimal ruralUnsubmittedUnitDollarRate;

        @Generated
        RevenueEntryBuilder() {
        }

        @Generated
        public RevenueEntryBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public RevenueEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder nonruralDollarRate(BigDecimal nonruralDollarRate) {
            this.nonruralDollarRate = nonruralDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder ruralDollarRate(BigDecimal ruralDollarRate) {
            this.ruralDollarRate = ruralDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder nonruralUnsubmittedDollarRate(BigDecimal nonruralUnsubmittedDollarRate) {
            this.nonruralUnsubmittedDollarRate = nonruralUnsubmittedDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder ruralUnsubmittedDollarRate(BigDecimal ruralUnsubmittedDollarRate) {
            this.ruralUnsubmittedDollarRate = ruralUnsubmittedDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder nonruralUnitDollarRate(BigDecimal nonruralUnitDollarRate) {
            this.nonruralUnitDollarRate = nonruralUnitDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder ruralUnitDollarRate(BigDecimal ruralUnitDollarRate) {
            this.ruralUnitDollarRate = ruralUnitDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder nonruralUnsubmittedUnitDollarRate(BigDecimal nonruralUnsubmittedUnitDollarRate) {
            this.nonruralUnsubmittedUnitDollarRate = nonruralUnsubmittedUnitDollarRate;
            return this;
        }

        @Generated
        public RevenueEntryBuilder ruralUnsubmittedUnitDollarRate(BigDecimal ruralUnsubmittedUnitDollarRate) {
            this.ruralUnsubmittedUnitDollarRate = ruralUnsubmittedUnitDollarRate;
            return this;
        }

        @Generated
        public RevenueEntry build() {
            return new RevenueEntry(this.code, this.effectiveDate, this.nonruralDollarRate, this.ruralDollarRate, this.nonruralUnsubmittedDollarRate, this.ruralUnsubmittedDollarRate, this.nonruralUnitDollarRate, this.ruralUnitDollarRate, this.nonruralUnsubmittedUnitDollarRate, this.ruralUnsubmittedUnitDollarRate);
        }

        @Generated
        public String toString() {
            return "RevenueEntry.RevenueEntryBuilder(code=" + this.code + ", effectiveDate=" + this.effectiveDate + ", nonruralDollarRate=" + this.nonruralDollarRate + ", ruralDollarRate=" + this.ruralDollarRate + ", nonruralUnsubmittedDollarRate=" + this.nonruralUnsubmittedDollarRate + ", ruralUnsubmittedDollarRate=" + this.ruralUnsubmittedDollarRate + ", nonruralUnitDollarRate=" + this.nonruralUnitDollarRate + ", ruralUnitDollarRate=" + this.ruralUnitDollarRate + ", nonruralUnsubmittedUnitDollarRate=" + this.nonruralUnsubmittedUnitDollarRate + ", ruralUnsubmittedUnitDollarRate=" + this.ruralUnsubmittedUnitDollarRate + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String CODE = "code";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String NONRURAL_DOLLAR_RATE = "nonruralDollarRate";
        public static final String RURAL_DOLLAR_RATE = "ruralDollarRate";
        public static final String NONRURAL_UNSUBMITTED_DOLLAR_RATE = "nonruralUnsubmittedDollarRate";
        public static final String RURAL_UNSUBMITTED_DOLLAR_RATE = "ruralUnsubmittedDollarRate";
        public static final String NONRURAL_UNIT_DOLLAR_RATE = "nonruralUnitDollarRate";
        public static final String RURAL_UNIT_DOLLAR_RATE = "ruralUnitDollarRate";
        public static final String NONRURAL_UNSUBMITTED_UNIT_DOLLAR_RATE = "nonruralUnsubmittedUnitDollarRate";
        public static final String RURAL_UNSUBMITTED_UNIT_DOLLAR_RATE = "ruralUnsubmittedUnitDollarRate";
    }
}

