/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class RequestIdFilter
implements ContainerResponseFilter {
    private static final String REQUEST_ID = "X-Request-Id";
    private Logger logger = LoggerFactory.getLogger(RequestIdFilter.class);

    void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        String id = Optional.ofNullable(request.getHeaderString(REQUEST_ID)).filter(header -> !header.isEmpty()).orElseGet(() -> RequestIdFilter.generateRandomUuid().toString());
        this.logger.trace("method={} path={} request_id={} status={} length={}", request.getMethod(), request.getUriInfo().getPath(), id, response.getStatus(), response.getLength());
        response.getHeaders().putSingle(REQUEST_ID, id);
    }

    private static UUID generateRandomUuid() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long mostSig = ((Random)rnd).nextLong();
        long leastSig = ((Random)rnd).nextLong();
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= Long.MIN_VALUE);
    }
}

