/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.web;

import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.web.conf.WebConfiguration;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.servlets.HeaderFilter;

public abstract class WebBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final String WILDCARD = "*";

    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(T configuration, Environment environment) throws Exception {
        WebConfiguration webConfig = this.getWebConfiguration(configuration);
        String urlPattern = this.deriveUrlPattern(webConfig.getUriPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        if (webConfig.getHstsHeaderFactory() != null) {
            headers.putAll(webConfig.getHstsHeaderFactory().build());
        }
        headers.putAll(webConfig.getFrameOptionsHeaderFactory().build());
        headers.putAll(webConfig.getContentTypeOptionsHeaderFactory().build());
        headers.putAll(webConfig.getXssProtectionHeaderFactory().build());
        if (webConfig.getCspHeaderFactory() != null) {
            headers.putAll(webConfig.getCspHeaderFactory().build());
        }
        headers.putAll(webConfig.getHeaders());
        this.configureHeaderFilter(environment, webConfig.getUriPath(), urlPattern, headers);
        if (webConfig.getCorsFilterFactory() != null) {
            webConfig.getCorsFilterFactory().build(environment, urlPattern);
        }
    }

    protected void configureHeaderFilter(Environment environment, String uriPath, String urlPattern, Map<String, String> headers) {
        String headerConfig = headers.entrySet().stream().map(entry -> "set " + (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(","));
        Map<String, String> filterConfig = Collections.singletonMap("headerConfig", headerConfig);
        FilterRegistration.Dynamic filter = this.getServletEnvironment(environment).addFilter("header-filter-" + uriPath, HeaderFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, urlPattern);
        filter.setInitParameters(filterConfig);
    }

    private String deriveUrlPattern(String uri) {
        if (uri.endsWith("/")) {
            return uri + WILDCARD;
        }
        return uri + "/*";
    }

    protected ServletEnvironment getServletEnvironment(Environment environment) {
        return environment.servlets();
    }

    public abstract WebConfiguration getWebConfiguration(T var1);
}

