package gov.cms.fiss.pricers.hospice.core;

import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;

public class Hospice2021PricerContext extends HospicePricerContext {
  public static final String CALCULATION_VERSION_2021 = "2021.0";

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2021 =
      new BigDecimal("136.90");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2021 =
      new BigDecimal("62.35");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2021 = new BigDecimal("108.21");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2021 = new BigDecimal("49.28");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_NQR_RATE_2021 = new BigDecimal("984.21");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2021 = new BigDecimal("448.20");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_NQR_RATE_2021 =
      new BigDecimal("249.59");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2021 =
      new BigDecimal("211.50");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_NQR_RATE_2021 =
      new BigDecimal("669.33");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2021 =
      new BigDecimal("376.33");

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2021 = new BigDecimal("134.23");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2021 = new BigDecimal("61.13");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2021 = new BigDecimal("106.10");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2021 = new BigDecimal("48.32");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_QR_RATE_2021 = new BigDecimal("964.99");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_QR_RATE_2021 = new BigDecimal("439.45");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_QR_RATE_2021 = new BigDecimal("244.71");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_QR_RATE_2021 =
      new BigDecimal("207.37");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_QR_RATE_2021 = new BigDecimal("656.25");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_QR_RATE_2021 =
      new BigDecimal("368.98");

  public Hospice2021PricerContext(
      HospiceClaimPricingRequest input,
      HospiceClaimPricingResponse hospiceOutput,
      DataTables dataTables) {
    super(input, hospiceOutput, dataTables);
  }

  @Override
  protected String getCalculationVersion() {
    return CALCULATION_VERSION_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsNqrRate() {
    return CONTINUOUS_HOME_CARE_LS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsNqrRate() {
    return CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsNqrRate() {
    return INPATIENT_RESPITE_CARE_LS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsNqrRate() {
    return INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsNqrRate() {
    return GENERAL_INPATIENT_CARE_LS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsNqrRate() {
    return GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsQrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsQrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsQrRate() {
    return CONTINUOUS_HOME_CARE_LS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsQrRate() {
    return CONTINUOUS_HOME_CARE_NLS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsQrRate() {
    return INPATIENT_RESPITE_CARE_LS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsQrRate() {
    return INPATIENT_RESPITE_CARE_NLS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsQrRate() {
    return GENERAL_INPATIENT_CARE_LS_QR_RATE_2021;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsQrRate() {
    return GENERAL_INPATIENT_CARE_NLS_QR_RATE_2021;
  }
}
