package gov.cms.fiss.pricers.hospice.core;

import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;

public class Hospice2026PricerContext extends HospicePricerContext {

  public static final String CALCULATION_VERSION_2026 = "2026.0";

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2026 =
      new BigDecimal("152.35");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2026 =
      new BigDecimal("78.48");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2026 = new BigDecimal("120.08");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2026 = new BigDecimal("61.86");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_NQR_RATE_2026 = new BigDecimal("1259.07");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2026 = new BigDecimal("415.22");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_NQR_RATE_2026 =
      new BigDecimal("324.81");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2026 =
      new BigDecimal("207.67");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_NQR_RATE_2026 =
      new BigDecimal("761.91");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2026 =
      new BigDecimal("437.95");

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2026 = new BigDecimal("146.41");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2026 = new BigDecimal("75.42");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2026 = new BigDecimal("115.39");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2026 = new BigDecimal("59.45");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_QR_RATE_2026 = new BigDecimal("1209.98");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_QR_RATE_2026 = new BigDecimal("399.04");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_QR_RATE_2026 = new BigDecimal("312.15");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_QR_RATE_2026 =
      new BigDecimal("199.57");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_QR_RATE_2026 = new BigDecimal("732.21");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_QR_RATE_2026 =
      new BigDecimal("420.87");

  public Hospice2026PricerContext(
      HospiceClaimPricingRequest input,
      HospiceClaimPricingResponse hospiceOutput,
      DataTables dataTables) {
    super(input, hospiceOutput, dataTables);
  }

  @Override
  protected String getCalculationVersion() {
    return CALCULATION_VERSION_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsNqrRate() {
    return CONTINUOUS_HOME_CARE_LS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsNqrRate() {
    return CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsNqrRate() {
    return INPATIENT_RESPITE_CARE_LS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsNqrRate() {
    return INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsNqrRate() {
    return GENERAL_INPATIENT_CARE_LS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsNqrRate() {
    return GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsQrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsQrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsQrRate() {
    return CONTINUOUS_HOME_CARE_LS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsQrRate() {
    return CONTINUOUS_HOME_CARE_NLS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsQrRate() {
    return INPATIENT_RESPITE_CARE_LS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsQrRate() {
    return INPATIENT_RESPITE_CARE_NLS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsQrRate() {
    return GENERAL_INPATIENT_CARE_LS_QR_RATE_2026;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsQrRate() {
    return GENERAL_INPATIENT_CARE_NLS_QR_RATE_2026;
  }
}
