// Generated by delombok at Thu Nov 13 21:20:38 UTC 2025
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.math.BigDecimal;

@Schema(description = "The calculated payment for the corresponding end-of-life add-on day units.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "BILL-SIA-ADD-ON-PYMTS", value = "<structure>")))
public class EndOfLifeAddOnDaysPaymentData {
  @Max(7)
  @Min(1)
  @Schema(description = "This index indicates which entry in the claim\'s end-of-life add-on days the payment " + "corresponds to.", example = "1")
  private int index;
  @BigDecimalScale
  @Schema(description = "The end-of-life add-on days payment", example = "123.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-EOL-ADD-ON-DAY1-PAY", value = "PIC 9(06)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal payment;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getIndex() {
    return this.index;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPayment() {
    return this.payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIndex(final int index) {
    this.index = index;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayment(final BigDecimal payment) {
    this.payment = payment;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof EndOfLifeAddOnDaysPaymentData)) return false;
    final EndOfLifeAddOnDaysPaymentData other = (EndOfLifeAddOnDaysPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getIndex() != other.getIndex()) return false;
    final java.lang.Object this$payment = this.getPayment();
    final java.lang.Object other$payment = other.getPayment();
    if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof EndOfLifeAddOnDaysPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getIndex();
    final java.lang.Object $payment = this.getPayment();
    result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "EndOfLifeAddOnDaysPaymentData(index=" + this.getIndex() + ", payment=" + this.getPayment() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EndOfLifeAddOnDaysPaymentData() {
  }
}
