// Generated by delombok at Thu Sep 12 18:32:38 UTC 2024
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(description = "The bill payment calculated for the specified revenue and HCPCS codes.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "BILL-GROUP-DATAn <partial>", value = "<structure>")))
public class BillPaymentData {
  @BigDecimalScale
  @NotNull
  @Schema(description = "The amount paid for this bill.", example = "123.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-PAY-AMT-TOTAL", value = "PIC 9(06)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal amount;
  @Pattern(regexp = "[A-Z\\d]{5}", message = "must be five alphanumeric characters")
  @Schema(description = "The Healthcare Common Procedure Coding System (HCPCS) G code associated with " + "the payment revenue code.", example = "G2564", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-HCPCn", value = "PIC X(05)")})})
  private String hcpcsCode;
  @NotNull
  @Pattern(regexp = "065[1256]", message = "must be one of `0651`, `0652`, `0655`, or `0656`")
  @Schema(description = "The revenue code for which the payment was calculated.", example = "0651", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-REVn", value = "PIC XXXX")})})
  private String revenueCode;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAmount() {
    return this.amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHcpcsCode() {
    return this.hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRevenueCode() {
    return this.revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final BigDecimal amount) {
    this.amount = amount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHcpcsCode(final String hcpcsCode) {
    this.hcpcsCode = hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRevenueCode(final String revenueCode) {
    this.revenueCode = revenueCode;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BillPaymentData)) return false;
    final BillPaymentData other = (BillPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$hcpcsCode = this.getHcpcsCode();
    final java.lang.Object other$hcpcsCode = other.getHcpcsCode();
    if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) return false;
    final java.lang.Object this$revenueCode = this.getRevenueCode();
    final java.lang.Object other$revenueCode = other.getRevenueCode();
    if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BillPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $hcpcsCode = this.getHcpcsCode();
    result = result * PRIME + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
    final java.lang.Object $revenueCode = this.getRevenueCode();
    result = result * PRIME + ($revenueCode == null ? 43 : $revenueCode.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BillPaymentData(amount=" + this.getAmount() + ", hcpcsCode=" + this.getHcpcsCode() + ", revenueCode=" + this.getRevenueCode() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillPaymentData() {
  }
}
