// Generated by delombok at Thu Sep 12 18:32:38 UTC 2024
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(description = "The Hospice billing group; this group is repeated 4 times.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-GROUPn", value = "<repeated structure")})})
public class BillingGroupData {
  @NotNull
  @Schema(description = "The line item date of service associated with the revenue code.", example = "2020-04-15", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-LINE-ITEM-DOSn", value = "BILL-LIDOSn-CC       PIC 99\n" + "BILL-LIDOSn-YY       PIC 99\n" + "BILL-LIDOSn-MM       PIC 99\n" + "BILL-LIDOSn-DD       PIC 99")})})
  @StrictLocalDate
  private LocalDate dateOfService;
  @Pattern(regexp = "[A-Z\\d]{5}", message = "must be five alphanumeric characters")
  @Schema(description = "The Healthcare Common Procedure Coding System (HCPCS) G code associated with " + "the revenue code.", example = "12345", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-HCPCn", value = "PIC X(05)")})})
  private String hcpcsCode;
  @NotNull
  @Pattern(regexp = "065[1256]", message = "must be one of `0651`, `0652`, `0655`, or `0656`")
  @Schema(description = "The revenue code for the billing group.", example = "0651", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-REVn", value = "PIC XXXX")})})
  private String revenueCode;
  @Max(9999999)
  @Min(0)
  @NotNull
  @Schema(description = "The number of units associated with the revenue code.", example = "1000", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-UNITSn", value = "PIC 9(07)")})})
  private Integer units;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDateOfService() {
    return this.dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHcpcsCode() {
    return this.hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRevenueCode() {
    return this.revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getUnits() {
    return this.units;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDateOfService(final LocalDate dateOfService) {
    this.dateOfService = dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHcpcsCode(final String hcpcsCode) {
    this.hcpcsCode = hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRevenueCode(final String revenueCode) {
    this.revenueCode = revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUnits(final Integer units) {
    this.units = units;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BillingGroupData)) return false;
    final BillingGroupData other = (BillingGroupData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$units = this.getUnits();
    final java.lang.Object other$units = other.getUnits();
    if (this$units == null ? other$units != null : !this$units.equals(other$units)) return false;
    final java.lang.Object this$dateOfService = this.getDateOfService();
    final java.lang.Object other$dateOfService = other.getDateOfService();
    if (this$dateOfService == null ? other$dateOfService != null : !this$dateOfService.equals(other$dateOfService)) return false;
    final java.lang.Object this$hcpcsCode = this.getHcpcsCode();
    final java.lang.Object other$hcpcsCode = other.getHcpcsCode();
    if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) return false;
    final java.lang.Object this$revenueCode = this.getRevenueCode();
    final java.lang.Object other$revenueCode = other.getRevenueCode();
    if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BillingGroupData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $units = this.getUnits();
    result = result * PRIME + ($units == null ? 43 : $units.hashCode());
    final java.lang.Object $dateOfService = this.getDateOfService();
    result = result * PRIME + ($dateOfService == null ? 43 : $dateOfService.hashCode());
    final java.lang.Object $hcpcsCode = this.getHcpcsCode();
    result = result * PRIME + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
    final java.lang.Object $revenueCode = this.getRevenueCode();
    result = result * PRIME + ($revenueCode == null ? 43 : $revenueCode.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BillingGroupData(dateOfService=" + this.getDateOfService() + ", hcpcsCode=" + this.getHcpcsCode() + ", revenueCode=" + this.getRevenueCode() + ", units=" + this.getUnits() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingGroupData() {
  }
}
