package gov.cms.fiss.pricers.hospice.core;

import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;

public class Hospice2022PricerContext extends HospicePricerContext {

  public static final String CALCULATION_VERSION_2022 = "2022.0";

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2022 =
      new BigDecimal("134.24");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2022 =
      new BigDecimal("69.16");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2022 = new BigDecimal("106.09");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2022 = new BigDecimal("54.65");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_NQR_RATE_2022 = new BigDecimal("1099.82");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2022 = new BigDecimal("362.70");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_NQR_RATE_2022 =
      new BigDecimal("288.99");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2022 =
      new BigDecimal("184.76");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_NQR_RATE_2022 =
      new BigDecimal("678.36");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2022 =
      new BigDecimal("389.92");

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2022 = new BigDecimal("131.61");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2022 = new BigDecimal("67.80");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2022 = new BigDecimal("104.00");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2022 = new BigDecimal("53.58");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_QR_RATE_2022 = new BigDecimal("1078.25");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_QR_RATE_2022 = new BigDecimal("355.59");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_QR_RATE_2022 = new BigDecimal("283.32");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_QR_RATE_2022 =
      new BigDecimal("181.14");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_QR_RATE_2022 = new BigDecimal("665.05");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_QR_RATE_2022 =
      new BigDecimal("382.28");

  public Hospice2022PricerContext(
      HospiceClaimPricingRequest input,
      HospiceClaimPricingResponse hospiceOutput,
      DataTables dataTables) {
    super(input, hospiceOutput, dataTables);
  }

  @Override
  protected String getCalculationVersion() {
    return CALCULATION_VERSION_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsNqrRate() {
    return CONTINUOUS_HOME_CARE_LS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsNqrRate() {
    return CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsNqrRate() {
    return INPATIENT_RESPITE_CARE_LS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsNqrRate() {
    return INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsNqrRate() {
    return GENERAL_INPATIENT_CARE_LS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsNqrRate() {
    return GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsQrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsQrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsQrRate() {
    return CONTINUOUS_HOME_CARE_LS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsQrRate() {
    return CONTINUOUS_HOME_CARE_NLS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsQrRate() {
    return INPATIENT_RESPITE_CARE_LS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsQrRate() {
    return INPATIENT_RESPITE_CARE_NLS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsQrRate() {
    return GENERAL_INPATIENT_CARE_LS_QR_RATE_2022;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsQrRate() {
    return GENERAL_INPATIENT_CARE_NLS_QR_RATE_2022;
  }
}
