package gov.cms.fiss.pricers.hospice.core;

import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;

public class Hospice2023PricerContext extends HospicePricerContext {

  public static final String CALCULATION_VERSION_2023 = "2023.0";

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2023 =
      new BigDecimal("139.48");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2023 =
      new BigDecimal("71.86");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2023 = new BigDecimal("110.22");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2023 = new BigDecimal("56.78");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_NQR_RATE_2023 = new BigDecimal("1144.57");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2023 = new BigDecimal("377.47");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_NQR_RATE_2023 =
      new BigDecimal("300.18");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2023 =
      new BigDecimal("191.92");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_NQR_RATE_2023 =
      new BigDecimal("705.33");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2023 =
      new BigDecimal("405.43");

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2023 = new BigDecimal("136.80");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2023 = new BigDecimal("70.47");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2023 = new BigDecimal("108.09");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2023 = new BigDecimal("55.69");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_QR_RATE_2023 = new BigDecimal("1122.53");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_QR_RATE_2023 = new BigDecimal("370.19");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_QR_RATE_2023 = new BigDecimal("294.40");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_QR_RATE_2023 =
      new BigDecimal("188.22");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_QR_RATE_2023 = new BigDecimal("691.74");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_QR_RATE_2023 =
      new BigDecimal("397.62");

  public Hospice2023PricerContext(
      HospiceClaimPricingRequest input,
      HospiceClaimPricingResponse hospiceOutput,
      DataTables dataTables) {
    super(input, hospiceOutput, dataTables);
  }

  @Override
  protected String getCalculationVersion() {
    return CALCULATION_VERSION_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsNqrRate() {
    return CONTINUOUS_HOME_CARE_LS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsNqrRate() {
    return CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsNqrRate() {
    return INPATIENT_RESPITE_CARE_LS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsNqrRate() {
    return INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsNqrRate() {
    return GENERAL_INPATIENT_CARE_LS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsNqrRate() {
    return GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsQrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsQrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsQrRate() {
    return CONTINUOUS_HOME_CARE_LS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsQrRate() {
    return CONTINUOUS_HOME_CARE_NLS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsQrRate() {
    return INPATIENT_RESPITE_CARE_LS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsQrRate() {
    return INPATIENT_RESPITE_CARE_NLS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsQrRate() {
    return GENERAL_INPATIENT_CARE_LS_QR_RATE_2023;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsQrRate() {
    return GENERAL_INPATIENT_CARE_NLS_QR_RATE_2023;
  }
}
