package gov.cms.fiss.pricers.hospice.core;

import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;

public class Hospice2024PricerContext extends HospicePricerContext {

  public static final String CALCULATION_VERSION_2024 = "2024.0";

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2024 =
      new BigDecimal("144.10");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2024 =
      new BigDecimal("74.23");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2024 = new BigDecimal("113.75");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2024 = new BigDecimal("58.60");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_NQR_RATE_2024 = new BigDecimal("1177.23");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2024 = new BigDecimal("388.23");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_NQR_RATE_2024 =
      new BigDecimal("309.70");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2024 =
      new BigDecimal("198.01");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_NQR_RATE_2024 =
      new BigDecimal("727.27");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2024 =
      new BigDecimal("418.04");

  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2024 = new BigDecimal("138.51");
  private static final BigDecimal ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2024 = new BigDecimal("71.35");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2024 = new BigDecimal("109.34");
  private static final BigDecimal ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2024 = new BigDecimal("56.32");
  private static final BigDecimal CONTINUOUS_HOME_CARE_LS_QR_RATE_2024 = new BigDecimal("1131.55");
  private static final BigDecimal CONTINUOUS_HOME_CARE_NLS_QR_RATE_2024 = new BigDecimal("373.17");
  private static final BigDecimal INPATIENT_RESPITE_CARE_LS_QR_RATE_2024 = new BigDecimal("297.69");
  private static final BigDecimal INPATIENT_RESPITE_CARE_NLS_QR_RATE_2024 =
      new BigDecimal("190.32");
  private static final BigDecimal GENERAL_INPATIENT_CARE_LS_QR_RATE_2024 = new BigDecimal("699.05");
  private static final BigDecimal GENERAL_INPATIENT_CARE_NLS_QR_RATE_2024 =
      new BigDecimal("401.82");

  public Hospice2024PricerContext(
      HospiceClaimPricingRequest input,
      HospiceClaimPricingResponse hospiceOutput,
      DataTables dataTables) {
    super(input, hospiceOutput, dataTables);
  }

  @Override
  protected String getCalculationVersion() {
    return CALCULATION_VERSION_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsNqrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsNqrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsNqrRate() {
    return CONTINUOUS_HOME_CARE_LS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsNqrRate() {
    return CONTINUOUS_HOME_CARE_NLS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsNqrRate() {
    return INPATIENT_RESPITE_CARE_LS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsNqrRate() {
    return INPATIENT_RESPITE_CARE_NLS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsNqrRate() {
    return GENERAL_INPATIENT_CARE_LS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsNqrRate() {
    return GENERAL_INPATIENT_CARE_NLS_NQR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighLsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_LS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareHighNlsQrRate() {
    return ROUTINE_HOME_CARE_HIGH_NLS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowLsQrRate() {
    return ROUTINE_HOME_CARE_LOW_LS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getRoutineHomeCareLowNlsQrRate() {
    return ROUTINE_HOME_CARE_LOW_NLS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getContinuousHomeCareLsQrRate() {
    return CONTINUOUS_HOME_CARE_LS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getContinuousHomeCareNlsQrRate() {
    return CONTINUOUS_HOME_CARE_NLS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getInpatientRespiteCareLsQrRate() {
    return INPATIENT_RESPITE_CARE_LS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getInpatientRespiteCareNlsQrRate() {
    return INPATIENT_RESPITE_CARE_NLS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getGeneralInpatientCareLsQrRate() {
    return GENERAL_INPATIENT_CARE_LS_QR_RATE_2024;
  }

  @Override
  public BigDecimal getGeneralInpatientCareNlsQrRate() {
    return GENERAL_INPATIENT_CARE_NLS_QR_RATE_2024;
  }
}
