// Generated by delombok at Thu Nov 13 21:21:00 UTC 2025
package gov.cms.fiss.pricers.hospice.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.EndOfLifeAddOnDaysPaymentData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.api.v2.HospicePaymentData;
import gov.cms.fiss.pricers.hospice.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class HospicePricerContext extends CalculationContext<HospiceClaimPricingRequest, HospiceClaimPricingResponse> {
  public static final String ROUTINE_HOME_CARE_REVENUE_CODE = "0651";
  public static final String CONTINUOUS_HOME_CARE_REVENUE_CODE = "0652";
  public static final String INPATIENT_RESPITE_CARE_REVENUE_CODE = "0655";
  public static final String GENERAL_INPATIENT_CARE_REVENUE_CODE = "0656";
  @JsonIgnore
  private final DataTables dataTables;
  /**
   * Corresponds to {@code WRK-PAY-RATE1 PIC 9(06)V9(02)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal workPayRate1 = BigDecimal.ZERO;
  /**
   * Corresponds to {@code WRK-PAY-RATE2 PIC 9(06)V9(02)} from the COBOL source.
   */
  private BigDecimal workPayRate2 = BigDecimal.ZERO;
  /**
   * Corresponds to {@code WRK-PAY-RATE3 PIC 9(06)V9(02)} from the COBOL source.
   */
  private BigDecimal workPayRate3 = BigDecimal.ZERO;
  /**
   * Corresponds to {@code WRK-PAY-RATE4 PIC 9(06)V9(02)} from the COBOL source.
   */
  private BigDecimal workPayRate4 = BigDecimal.ZERO;
  /**
   * Corresponds to {@code SIA-PAY-AMT-TOTAL PIC 9(06)V99} from the COBOL source.
   */
  private BigDecimal siaPayAmountTotal;
  private int priorServiceDays;
  /**
   * Corresponds to {@code BILL-BENE-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal patientWageIndex = BigDecimal.ZERO;
  /**
   * Corresponds to {@code BILL-PROV-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @FixedValue
  private BigDecimal providerWageIndex = BigDecimal.ZERO;
  /**
   * Corresponds to {@code LR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  private int lowRateBillUnits;
  /**
   * Corresponds to {@code HR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  private int highRateBillUnits;
  private boolean siaUnitsIndicator;
  private BigDecimal siaPaymentRate;
  /**
   * Corresponds to {@code HR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @FixedValue
  private BigDecimal highRateBillPayAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code LR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @FixedValue
  private BigDecimal lowRateBillPayAmount = BigDecimal.ZERO;
  /**
   * Corresponds to {@code RHC-HIGH-DAY-IND PIC X} from the COBOL source.
   */
  private boolean routineHomeCareHighDayIndicator;
  /**
   * Corresponds to {@code RHC-LOW-DAY-IND PIC X} from the COBOL source.
   */
  private boolean routineHomeCareLowDayIndicator;
  /**
   * Corresponds to {@code DATE-2-DOS PIC 9(8)} from the COBOL source.
   */
  private LocalDate dateOfService;

  protected HospicePricerContext(HospiceClaimPricingRequest input, HospiceClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    output.setCalculationVersion(getCalculationVersion());
    applyReturnCode(ReturnCode.HOME_RATE_RETURNED_00);
    initializeContext();
  }

  protected void initializeContext() {
    getPaymentData().setPatientWageIndex(getPatientWageIndex());
    getPaymentData().setProviderWageIndex(getProviderWageIndex());
    getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
  }

  @JsonIgnore
  public HospiceClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public List<Integer> getEndOfLifeAddOnDaysUnits() {
    List<Integer> list = new ArrayList<>();
    if (getClaimData().getEndOfLifeAddOnDaysUnits() != null) {
      list = getClaimData().getEndOfLifeAddOnDaysUnits();
    }
    return list;
  }

  @JsonIgnore
  public HospicePaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  @JsonIgnore
  public List<EndOfLifeAddOnDaysPaymentData> getEndOfLifeAddOnDaysPaymentData() {
    for (int i = 0; i < getEndOfLifeAddOnDaysUnits().size(); i++) {
      if (getPaymentData().getEndOfLifeAddOnDaysPayments() == null) {
        getPaymentData().setEndOfLifeAddOnDaysPayments(new ArrayList<>());
      }
      final EndOfLifeAddOnDaysPaymentData eolPaymentData = new EndOfLifeAddOnDaysPaymentData();
      eolPaymentData.setIndex(i + 1);
      eolPaymentData.setPayment(BigDecimal.ZERO.setScale(2, RoundingMode.DOWN));
      getPaymentData().getEndOfLifeAddOnDaysPayments().add(eolPaymentData);
    }
    return getPaymentData().getEndOfLifeAddOnDaysPayments();
  }

  @JsonIgnore
  public List<BillingGroupData> getBillingGroups() {
    return getClaimData().getBillingGroups();
  }

  public boolean isReportingQualityData() {
    return StringUtils.equals(getClaimData().getReportingQualityData(), "1");
  }

  @JsonIgnore
  public BillingGroupData getBillGroup(String revenueCode) {
    return getBillingGroups().stream().filter(bg -> bg.getRevenueCode().equals(revenueCode)).findFirst().orElse(null);
  }

  // Calculation data
  public void applyReturnCode(ReturnCode returnCode) {
    getOutput().setReturnCodeData(returnCode.toReturnCodeData());
  }

  public void applyReturnCodeAndComplete(ReturnCode returnCode) {
    applyReturnCode(returnCode);
    setCalculationCompleted();
  }

  // Per-year value retrieval
  protected abstract String getCalculationVersion();

  /**
   * Corresponds to {@code HIGH-RHC-LS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareHighLsNqrRate();

  /**
   * Corresponds to {@code HIGH-RHC-NLS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareHighNlsNqrRate();

  /**
   * Corresponds to {@code LOW-RHC-LS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareLowLsNqrRate();

  /**
   * Corresponds to {@code LOW-RHC-NLS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareLowNlsNqrRate();

  /**
   * Corresponds to {@code CHC-LS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getContinuousHomeCareLsNqrRate();

  /**
   * Corresponds to {@code CHC-NLS-RATE PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getContinuousHomeCareNlsNqrRate();

  /**
   * Corresponds to {@code IRC-LS-RATE PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getInpatientRespiteCareLsNqrRate();

  /**
   * Corresponds to {@code GIC-NLS-RATE PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getGeneralInpatientCareNlsNqrRate();

  /**
   * Corresponds to {@code GIC-LS-RATE PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getGeneralInpatientCareLsNqrRate();

  /**
   * Corresponds to {@code GIC-NLS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getGeneralInpatientCareNlsQrRate();

  /**
   * Corresponds to {@code HIGH-RHC-LS-RATE-Q PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareHighLsQrRate();

  /**
   * Corresponds to {@code HIGH-RHC-NLS-RATE-Q PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareHighNlsQrRate();

  /**
   * Corresponds to {@code LOW-RHC-LS-RATE-Q PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareLowLsQrRate();

  /**
   * Corresponds to {@code LOW-RHC-NLS-RATE-Q PIC 999V99} from the COBOL source.
   */
  @FixedValue
  public abstract BigDecimal getRoutineHomeCareLowNlsQrRate();

  /**
   * Corresponds to {@code CHC-LS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getContinuousHomeCareLsQrRate();

  /**
   * Corresponds to {@code CHC-NLS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getContinuousHomeCareNlsQrRate();

  /**
   * Corresponds to {@code IRC-NLS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getInpatientRespiteCareNlsQrRate();

  /**
   * Corresponds to {@code IRC-NLS-RATE PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getInpatientRespiteCareNlsNqrRate();

  /**
   * Corresponds to {@code GIC-LS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getGeneralInpatientCareLsQrRate();

  /**
   * Corresponds to {@code IRC-LS-RATE-Q PIC 999V99} from the COBOL source.
   */
  public abstract BigDecimal getInpatientRespiteCareLsQrRate();

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE1 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWorkPayRate1() {
    return this.workPayRate1;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE1 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWorkPayRate1(final BigDecimal workPayRate1) {
    this.workPayRate1 = workPayRate1;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE2 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWorkPayRate2() {
    return this.workPayRate2;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE2 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWorkPayRate2(final BigDecimal workPayRate2) {
    this.workPayRate2 = workPayRate2;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE3 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWorkPayRate3() {
    return this.workPayRate3;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE3 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWorkPayRate3(final BigDecimal workPayRate3) {
    this.workPayRate3 = workPayRate3;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE4 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWorkPayRate4() {
    return this.workPayRate4;
  }

  /**
   * Corresponds to {@code WRK-PAY-RATE4 PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWorkPayRate4(final BigDecimal workPayRate4) {
    this.workPayRate4 = workPayRate4;
  }

  /**
   * Corresponds to {@code SIA-PAY-AMT-TOTAL PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSiaPayAmountTotal() {
    return this.siaPayAmountTotal;
  }

  /**
   * Corresponds to {@code SIA-PAY-AMT-TOTAL PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiaPayAmountTotal(final BigDecimal siaPayAmountTotal) {
    this.siaPayAmountTotal = siaPayAmountTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getPriorServiceDays() {
    return this.priorServiceDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPriorServiceDays(final int priorServiceDays) {
    this.priorServiceDays = priorServiceDays;
  }

  /**
   * Corresponds to {@code BILL-BENE-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientWageIndex() {
    return this.patientWageIndex;
  }

  /**
   * Corresponds to {@code BILL-BENE-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientWageIndex(final BigDecimal patientWageIndex) {
    this.patientWageIndex = patientWageIndex;
  }

  /**
   * Corresponds to {@code BILL-PROV-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getProviderWageIndex() {
    return this.providerWageIndex;
  }

  /**
   * Corresponds to {@code BILL-PROV-WAGE-INDEX PIC 9(02)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProviderWageIndex(final BigDecimal providerWageIndex) {
    this.providerWageIndex = providerWageIndex;
  }

  /**
   * Corresponds to {@code LR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLowRateBillUnits() {
    return this.lowRateBillUnits;
  }

  /**
   * Corresponds to {@code LR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowRateBillUnits(final int lowRateBillUnits) {
    this.lowRateBillUnits = lowRateBillUnits;
  }

  /**
   * Corresponds to {@code HR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHighRateBillUnits() {
    return this.highRateBillUnits;
  }

  /**
   * Corresponds to {@code HR-BILL-UNITS1 PIC 9(4)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHighRateBillUnits(final int highRateBillUnits) {
    this.highRateBillUnits = highRateBillUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isSiaUnitsIndicator() {
    return this.siaUnitsIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiaUnitsIndicator(final boolean siaUnitsIndicator) {
    this.siaUnitsIndicator = siaUnitsIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSiaPaymentRate() {
    return this.siaPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiaPaymentRate(final BigDecimal siaPaymentRate) {
    this.siaPaymentRate = siaPaymentRate;
  }

  /**
   * Corresponds to {@code HR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHighRateBillPayAmount() {
    return this.highRateBillPayAmount;
  }

  /**
   * Corresponds to {@code HR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHighRateBillPayAmount(final BigDecimal highRateBillPayAmount) {
    this.highRateBillPayAmount = highRateBillPayAmount;
  }

  /**
   * Corresponds to {@code LR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowRateBillPayAmount() {
    return this.lowRateBillPayAmount;
  }

  /**
   * Corresponds to {@code LR-BILL-PAY-AMT1 PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowRateBillPayAmount(final BigDecimal lowRateBillPayAmount) {
    this.lowRateBillPayAmount = lowRateBillPayAmount;
  }

  /**
   * Corresponds to {@code RHC-HIGH-DAY-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isRoutineHomeCareHighDayIndicator() {
    return this.routineHomeCareHighDayIndicator;
  }

  /**
   * Corresponds to {@code RHC-HIGH-DAY-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRoutineHomeCareHighDayIndicator(final boolean routineHomeCareHighDayIndicator) {
    this.routineHomeCareHighDayIndicator = routineHomeCareHighDayIndicator;
  }

  /**
   * Corresponds to {@code RHC-LOW-DAY-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isRoutineHomeCareLowDayIndicator() {
    return this.routineHomeCareLowDayIndicator;
  }

  /**
   * Corresponds to {@code RHC-LOW-DAY-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRoutineHomeCareLowDayIndicator(final boolean routineHomeCareLowDayIndicator) {
    this.routineHomeCareLowDayIndicator = routineHomeCareLowDayIndicator;
  }

  /**
   * Corresponds to {@code DATE-2-DOS PIC 9(8)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDateOfService() {
    return this.dateOfService;
  }

  /**
   * Corresponds to {@code DATE-2-DOS PIC 9(8)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDateOfService(final LocalDate dateOfService) {
    this.dateOfService = dateOfService;
  }
}
