/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.component.ComponentManager;
import com.component.ReportGenerator;
import com.constants.Component_EN;
import com.constants.Constants;
import com.constants.bypass.DenialRejectionFlag_EN;
import com.constants.bypass.PackagingFlag_EN;
import com.constants.bypass.PaymentAdjustmentFlag_EN;
import com.constants.bypass.PaymentMethodFlag_EN;
import com.constants.code.ActionFlag_EN;
import com.constants.code.Opps_EN;
import com.constants.code.PaySource_EN;
import com.constants.code.Sex_EN;
import com.modal.Diagnosis;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import com.util.ComboBoxUtils;
import com.util.ControlUtils;
import com.util.NodeUtils;
import com.util.Popup;
import com.util.StringUtils;
import com.util.TableUtils;
import com.util.TextFieldListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Controller
implements Initializable {
    private static final Logger logger = Logger.getLogger(Controller.class);
    private static ObservableList<Diagnosis> pdxData = FXCollections.observableArrayList();
    private static ObservableList<Diagnosis> sdxData = FXCollections.observableArrayList();
    private static ObservableList<Diagnosis> rvdxData = FXCollections.observableArrayList();
    private static ObservableList<Procedure> procedureData = FXCollections.observableArrayList();
    private final Component_EN _COMPONENT_ = Component_EN.IOCE;
    private final Constants _CONSTANTS_ = new Constants(this._COMPONENT_);
    @FXML
    private GridPane baseGridPane;
    @FXML
    private Button addPDXButton;
    @FXML
    private Button addProcedureButton;
    @FXML
    private Button addRVDXButton;
    @FXML
    private Button addSDXButton;
    @FXML
    private Button deleteDXButton;
    @FXML
    private Button deleteProcedureButton;
    @FXML
    private Button copyProcedureButton;
    @FXML
    private Button generateReportButton;
    @FXML
    private Button newClaimButton;
    @FXML
    private MenuItem helpButton;
    @FXML
    private MenuItem exitButton;
    @FXML
    private ComboBox<String> actionFlagComboBox;
    @FXML
    private ComboBox<String> denialRejectionFlagComboBox;
    @FXML
    private ComboBox<String> oppsComboBox;
    @FXML
    private ComboBox<String> packagingFlagComboBox;
    @FXML
    private ComboBox<String> paymentAdjustmentFlagComboBox;
    @FXML
    private ComboBox<String> paymentMethodFlagComboBox;
    @FXML
    private ComboBox<String> paySourceComboBox;
    @FXML
    private ComboBox<String> sexComboBox;
    @FXML
    private DatePicker birthDatePicker;
    @FXML
    private DatePicker fromDatePicker;
    @FXML
    private DatePicker serviceDatePicker;
    @FXML
    private DatePicker throughDatePicker;
    @FXML
    private Label copyrightLabel;
    @FXML
    private HBox modifierHBox;
    @FXML
    private TextField ageText;
    @FXML
    private TextField billTypeText;
    @FXML
    private TextField cc1Text;
    @FXML
    private TextField cc2Text;
    @FXML
    private TextField cc3Text;
    @FXML
    private TextField cc4Text;
    @FXML
    private TextField cc5Text;
    @FXML
    private TextField cc6Text;
    @FXML
    private TextField codeText;
    @FXML
    private TextField dxCodeText;
    @FXML
    private TextField commentText;
    @FXML
    private TextField descriptionText;
    @FXML
    private TextField dxDescriptionText;
    @FXML
    private TextField medicalRecordNumberText;
    @FXML
    private TextField oc1Text;
    @FXML
    private TextField oc2Text;
    @FXML
    private TextField oc3Text;
    @FXML
    private TextField oc4Text;
    @FXML
    private TextField oc5Text;
    @FXML
    private TextField oc6Text;
    @FXML
    private TextField patientAccountNumberText;
    @FXML
    private TextField patientNameText;
    @FXML
    private TextField patientStatusText;
    @FXML
    private TextField vc1AmountText;
    @FXML
    private TextField vc1Text;
    @FXML
    private TextField vc2AmountText;
    @FXML
    private TextField vc2Text;
    @FXML
    private TextField vc3AmountText;
    @FXML
    private TextField vc3Text;
    @FXML
    private TextField vc4AmountText;
    @FXML
    private TextField vc4Text;
    @FXML
    private TextField mod1Text;
    @FXML
    private TextField mod2Text;
    @FXML
    private TextField mod3Text;
    @FXML
    private TextField mod4Text;
    @FXML
    private TextField mod5Text;
    @FXML
    private TextField revenueCodeText;
    @FXML
    private TextField unitsText;
    @FXML
    private TextField chargesText;
    @FXML
    private TextField cbEdit1Text;
    @FXML
    private TextField cbEdit2Text;
    @FXML
    private TextField cbEdit3Text;
    @FXML
    private TextField cbEdit4Text;
    @FXML
    private TextField cbAPCText;
    @FXML
    private TextField cbStatusIndicatorText;
    @FXML
    private TextField cbPaymentIndicatorText;
    @FXML
    private TextField cbDiscountingFormula;
    @FXML
    private TableView<Diagnosis> pdxTable = new TableView();
    @FXML
    private TableView<Diagnosis> sdxTable = new TableView();
    @FXML
    private TableView<Diagnosis> rvdxTable = new TableView();
    @FXML
    private TableView<Procedure> procedureTable = new TableView();
    @FXML
    private TitledPane conditionCodePane = new TitledPane();
    @FXML
    private TitledPane occurrenceCodePane = new TitledPane();

    public void initialize(URL location, ResourceBundle resources) {
        if (!new File("gapc.ctl").exists()) {
            new Popup(Alert.AlertType.ERROR, "Component Error", "Missing Required Library", "Library missing for component runtime (gapc.ctl). This file must be in the same directory as this program. Check the delivery folder and relaunch. The program will now exit.").showAndWait();
            System.exit(-1);
        }
        System.out.println("Successful Init");
        this.addTextFieldListeners();
        this.resetGUI();
    }

    private void addTextFieldListeners() {
        boolean _ONE_ = true;
        int _TWO_ = 2;
        int _THREE_ = 3;
        int _FOUR_ = 4;
        int _FIVE_ = 5;
        int _EIGHT_ = 8;
        int _NINE_ = 9;
        int _TEN_ = 10;
        int _TWENTY_ = 20;
        HashMap<TextField, Object[]> alphaOnlyMap = new HashMap<TextField, Object[]>(){
            {
                this.put(Controller.this.vc1Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc2Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc3Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc4Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.patientNameText, new Object[]{20, TextFieldListener.JUSTIFICATION_EN.NONE});
            }
        };
        HashMap<TextField, Object[]> numericOnlyMap = new HashMap<TextField, Object[]>(){
            {
                this.put(Controller.this.ageText, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbAPCText, new Object[]{5, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbDiscountingFormula, new Object[]{1, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbEdit1Text, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbEdit2Text, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbEdit3Text, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbEdit4Text, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.cbPaymentIndicatorText, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.chargesText, new Object[]{10, TextFieldListener.JUSTIFICATION_EN.CURRENCY});
                this.put(Controller.this.patientStatusText, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.revenueCodeText, new Object[]{4, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.unitsText, new Object[]{9, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc1AmountText, new Object[]{9, TextFieldListener.JUSTIFICATION_EN.CURRENCY});
                this.put(Controller.this.vc2AmountText, new Object[]{9, TextFieldListener.JUSTIFICATION_EN.CURRENCY});
                this.put(Controller.this.vc3AmountText, new Object[]{9, TextFieldListener.JUSTIFICATION_EN.CURRENCY});
                this.put(Controller.this.vc4AmountText, new Object[]{9, TextFieldListener.JUSTIFICATION_EN.CURRENCY});
            }
        };
        HashMap<TextField, Object[]> alphaNumericMap = new HashMap<TextField, Object[]>(){
            {
                this.put(Controller.this.billTypeText, new Object[]{3, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.codeText, new Object[]{5, TextFieldListener.JUSTIFICATION_EN.LEFT});
                this.put(Controller.this.dxCodeText, new Object[]{8, TextFieldListener.JUSTIFICATION_EN.LEFT});
                this.put(Controller.this.cbStatusIndicatorText, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc1Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc2Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc3Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.vc4Text, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.RIGHT});
                this.put(Controller.this.medicalRecordNumberText, new Object[]{20, TextFieldListener.JUSTIFICATION_EN.NONE});
                this.put(Controller.this.commentText, new Object[]{20, TextFieldListener.JUSTIFICATION_EN.NONE});
                this.put(Controller.this.patientAccountNumberText, new Object[]{20, TextFieldListener.JUSTIFICATION_EN.NONE});
                this.put(Controller.this.medicalRecordNumberText, new Object[]{20, TextFieldListener.JUSTIFICATION_EN.NONE});
            }
        };
        for (Control c : NodeUtils.getAllControl((Parent)this.conditionCodePane)) {
            if (!(c instanceof TextField)) continue;
            alphaNumericMap.put((TextField)c, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.LEFT});
        }
        for (Control c : NodeUtils.getAllControl((Parent)this.occurrenceCodePane)) {
            if (!(c instanceof TextField)) continue;
            alphaNumericMap.put((TextField)c, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.LEFT});
        }
        for (Control c : NodeUtils.getAllControl((Parent)this.modifierHBox)) {
            if (!(c instanceof TextField)) continue;
            alphaNumericMap.put((TextField)c, new Object[]{2, TextFieldListener.JUSTIFICATION_EN.LEFT});
        }
        for (TextField textField : alphaOnlyMap.keySet()) {
            if (!textField.getId().equals("patientNameText") && !textField.getId().equals("commentText")) {
                textField.addEventFilter(KeyEvent.KEY_TYPED, this.alphaValidation((Integer)((Object[])alphaOnlyMap.get(textField))[0]));
                textField.addEventFilter(KeyEvent.KEY_RELEASED, this.toUpper());
            }
            textField.focusedProperty().addListener((ChangeListener)new TextFieldListener(textField, (Integer)((Object[])alphaOnlyMap.get(textField))[0], " ", (TextFieldListener.JUSTIFICATION_EN)((Object)((Object[])alphaOnlyMap.get(textField))[1])));
        }
        for (TextField textField : numericOnlyMap.keySet()) {
            textField.addEventFilter(KeyEvent.KEY_TYPED, this.numericValidation((Integer)((Object[])numericOnlyMap.get(textField))[0]));
            textField.focusedProperty().addListener((ChangeListener)new TextFieldListener(textField, (Integer)((Object[])numericOnlyMap.get(textField))[0], "0", (TextFieldListener.JUSTIFICATION_EN)((Object)((Object[])numericOnlyMap.get(textField))[1])));
        }
        for (TextField textField : alphaNumericMap.keySet()) {
            if (!textField.getId().equals("patientNameText") && !textField.getId().equals("commentText")) {
                textField.addEventFilter(KeyEvent.KEY_TYPED, this.alphaNumericValidation((Integer)((Object[])alphaNumericMap.get(textField))[0]));
                textField.addEventFilter(KeyEvent.KEY_RELEASED, this.toUpper());
            }
            textField.focusedProperty().addListener((ChangeListener)new TextFieldListener(textField, (Integer)((Object[])alphaNumericMap.get(textField))[0], " ", (TextFieldListener.JUSTIFICATION_EN)((Object)((Object[])alphaNumericMap.get(textField))[1])));
        }
        this.birthDatePicker.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            this.ageText.setDisable(false);
            if (!newPropertyValue.booleanValue() && this.birthDatePicker.getValue() != null && this.birthDatePicker.getEditor().getText() != null) {
                this.ageText.setText(String.valueOf(ChronoUnit.YEARS.between((Temporal)this.birthDatePicker.getValue(), LocalDate.now())));
                this.birthDatePicker.setAccessibleText(this.birthDatePicker.getAccessibleText().replace(this.birthDatePicker.getEditor().getText(), "") + " " + this.birthDatePicker.getEditor().getText());
            }
        });
        this.ageText.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            if (this.birthDatePicker.getValue() != null && this.birthDatePicker.getEditor().getText() != null) {
                this.ageText.setText(String.format("%3s", String.valueOf(ChronoUnit.YEARS.between((Temporal)this.birthDatePicker.getValue(), LocalDate.now()))).replace(" ", "0"));
                this.ageText.setDisable(true);
                this.birthDatePicker.setAccessibleText(this.birthDatePicker.getAccessibleText().replace(this.birthDatePicker.getEditor().getText(), "") + " " + this.birthDatePicker.getEditor().getText());
            }
        });
        this.serviceDatePicker.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            if (this.serviceDatePicker.getValue() != null && this.serviceDatePicker.getEditor().getText() != null) {
                this.serviceDatePicker.setAccessibleText(this.serviceDatePicker.getAccessibleText().replace(this.serviceDatePicker.getEditor().getText(), "") + " " + this.serviceDatePicker.getEditor().getText());
            }
        });
        this.pdxTable.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            this.sdxTable.getSelectionModel().clearSelection();
            this.rvdxTable.getSelectionModel().clearSelection();
        });
        this.fromDatePicker.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            ObservableList pdxTmp = FXCollections.observableArrayList(pdxData);
            ObservableList sdxTmp = FXCollections.observableArrayList(sdxData);
            ObservableList rvdxTmp = FXCollections.observableArrayList(rvdxData);
            ObservableList procTmp = FXCollections.observableArrayList(procedureData);
            if (this.fromDatePicker.getValue() != null) {
                ComponentManager componentManager = new ComponentManager();
                for (Diagnosis d : pdxTmp) {
                    d.setDescription(componentManager.getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), d.getCode(), 2));
                }
                for (Diagnosis d : sdxTmp) {
                    d.setDescription(componentManager.getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), d.getCode(), 2));
                }
                for (Diagnosis d : rvdxTmp) {
                    d.setDescription(componentManager.getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), d.getCode(), 2));
                }
                for (Procedure p : procTmp) {
                    p.setDescription(componentManager.getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), p.getCode(), 1));
                }
                this.fromDatePicker.setAccessibleText(this.fromDatePicker.getAccessibleText().replace(this.fromDatePicker.getEditor().getText(), "") + " " + this.fromDatePicker.getEditor().getText());
            }
            pdxData.clear();
            pdxData.addAll((Collection)pdxTmp);
            sdxData.clear();
            sdxData.addAll((Collection)sdxTmp);
            rvdxData.clear();
            rvdxData.addAll((Collection)rvdxTmp);
            procedureData.clear();
            procedureData.addAll((Collection)procTmp);
        });
        this.throughDatePicker.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> this.throughDatePicker.setAccessibleText(this.throughDatePicker.getAccessibleText().replace(this.throughDatePicker.getEditor().getText(), "") + " " + this.throughDatePicker.getEditor().getText()));
    }

    private void resetGUI() {
        Control[] allControlMap = NodeUtils.getAllControl((Parent)this.baseGridPane);
        HashMap<ComboBox<String>, Object[]> comboBoxMap = new HashMap<ComboBox<String>, Object[]>(){
            {
                this.put(Controller.this.actionFlagComboBox, ActionFlag_EN.values());
                this.put(Controller.this.denialRejectionFlagComboBox, DenialRejectionFlag_EN.values());
                this.put(Controller.this.oppsComboBox, Opps_EN.values());
                this.put(Controller.this.packagingFlagComboBox, PackagingFlag_EN.values());
                this.put(Controller.this.paymentAdjustmentFlagComboBox, PaymentAdjustmentFlag_EN.values());
                this.put(Controller.this.paymentMethodFlagComboBox, PaymentMethodFlag_EN.values());
                this.put(Controller.this.paySourceComboBox, PaySource_EN.values());
                this.put(Controller.this.sexComboBox, Sex_EN.values());
            }
        };
        ControlUtils.resetControl(allControlMap);
        this.paySourceComboBox.setDisable(true);
        this.patientAccountNumberText.setDisable(true);
        this.commentText.setDisable(true);
        TableUtils.initDxTable(this.pdxTable, pdxData);
        TableUtils.initDxTable(this.sdxTable, sdxData);
        TableUtils.initDxTable(this.rvdxTable, rvdxData);
        TableUtils.initProcedureTable(this.procedureTable, procedureData);
        ControlUtils.setText(Constants._COPYRIGHT_, new Control[]{this.copyrightLabel});
        for (ComboBox c : comboBoxMap.keySet()) {
            new ComboBoxUtils((ComboBox<String>)c, (Object[])comboBoxMap.get(c)).init();
        }
        this.oppsComboBox.setAccessibleText((String)this.oppsComboBox.getSelectionModel().getSelectedItem());
    }

    @FXML
    private void oppsComboBoxChanged(ActionEvent actionEvent) {
        Control[] nonOppsOnlyFields = new Control[]{this.paySourceComboBox, this.patientAccountNumberText, this.commentText};
        boolean isDisable = this.oppsComboBox.getSelectionModel().getSelectedItem() != null && ((String)this.oppsComboBox.getSelectionModel().getSelectedItem()).equals(Opps_EN.OPPS.toString());
        ControlUtils.disableAndReset(isDisable, nonOppsOnlyFields);
        this.pdxTable.requestFocus();
        this.oppsComboBox.setAccessibleText((String)this.oppsComboBox.getSelectionModel().getSelectedItem());
        this.oppsComboBox.requestFocus();
    }

    @FXML
    private void accessibleComboBoxChanged(KeyEvent keyEvent) {
        ComboBox comboBox = (ComboBox)keyEvent.getSource();
        this.pdxTable.requestFocus();
        comboBox.setAccessibleText((String)comboBox.getSelectionModel().getSelectedItem());
        comboBox.requestFocus();
    }

    private void SaveFile(String content, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(content);
            fileWriter.close();
        }
        catch (IOException ex) {
            logger.log(Level.ERROR, "Could not save report");
        }
    }

    @FXML
    private void generateReportAction(ActionEvent actionEvent) {
        Stage dialog = new Stage();
        Stage primaryStage = (Stage)this.baseGridPane.getScene().getWindow();
        TextArea reportField = new TextArea();
        ButtonBar buttonBar = new ButtonBar();
        Button saveButton = new Button("Save Report");
        Button closeButton = new Button("Close Report");
        Label copyrightLabel = new Label(Constants._COPYRIGHT_);
        dialog.setResizable(false);
        VBox dialogVbox = new VBox(20.0);
        double height = 768.0;
        double width = 1024.0;
        Scene dialogScene = new Scene((Parent)dialogVbox, 1024.0, 768.0);
        dialog.setTitle(this._CONSTANTS_.getReportTitle());
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.initOwner((Window)primaryStage);
        ArrayList<String> conditionCodes = new ArrayList<String>(){
            {
                this.add(Controller.this.cc1Text.getText());
                this.add(Controller.this.cc2Text.getText());
                this.add(Controller.this.cc3Text.getText());
                this.add(Controller.this.cc4Text.getText());
                this.add(Controller.this.cc5Text.getText());
                this.add(Controller.this.cc6Text.getText());
            }
        };
        ArrayList<String> occurrenceCodes = new ArrayList<String>(){
            {
                this.add(Controller.this.oc1Text.getText());
                this.add(Controller.this.oc2Text.getText());
                this.add(Controller.this.oc3Text.getText());
                this.add(Controller.this.oc4Text.getText());
                this.add(Controller.this.oc5Text.getText());
                this.add(Controller.this.oc6Text.getText());
            }
        };
        ArrayList<ValueCodes> valueCodes = new ArrayList<ValueCodes>(){
            {
                this.add(new ValueCodes(Controller.this.vc1Text.getText(), Controller.this.vc1AmountText.getText()));
                this.add(new ValueCodes(Controller.this.vc2Text.getText(), Controller.this.vc2AmountText.getText()));
                this.add(new ValueCodes(Controller.this.vc3Text.getText(), Controller.this.vc3AmountText.getText()));
                this.add(new ValueCodes(Controller.this.vc4Text.getText(), Controller.this.vc4AmountText.getText()));
            }
        };
        GrouperInput grouperInput = new GrouperInput(this.patientNameText.getText(), this.medicalRecordNumberText.getText(), this.fromDatePicker.getValue() == null ? "        " : ((LocalDate)this.fromDatePicker.getValue()).toString(), this.throughDatePicker.getValue() == null ? "        " : ((LocalDate)this.throughDatePicker.getValue()).toString(), this.patientStatusText.getText(), this.billTypeText.getText(), this.birthDatePicker.getValue() == null ? "        " : ((LocalDate)this.birthDatePicker.getValue()).toString(), this.ageText.getText(), (String)this.sexComboBox.getSelectionModel().getSelectedItem(), (String)this.oppsComboBox.getSelectionModel().getSelectedItem(), " ", (String)this.paySourceComboBox.getSelectionModel().getSelectedItem(), this.patientAccountNumberText.getText(), this.commentText.getText(), conditionCodes, occurrenceCodes, valueCodes, procedureData, pdxData, sdxData, rvdxData);
        GrouperOutput grouperOutput = new GrouperOutput(new ArrayList<Procedure>((Collection<Procedure>)procedureData), new ArrayList<Diagnosis>((Collection<Diagnosis>)pdxData), new ArrayList<Diagnosis>((Collection<Diagnosis>)sdxData), new ArrayList<Diagnosis>((Collection<Diagnosis>)rvdxData));
        ComponentManager componentManager = new ComponentManager(grouperInput, grouperOutput);
        if (procedureData.size() != 0 && this.fromDatePicker.getValue() != null && this.throughDatePicker.getValue() != null) {
            componentManager.processFixedClaim();
            ReportGenerator reportGenerator = new ReportGenerator(grouperInput, grouperOutput);
            reportField.setText(reportGenerator.getFormattedReport());
            this.setTextFieldConfig(reportField, dialogVbox, 768.0, 1024.0);
            dialogVbox.getChildren().add((Object)buttonBar);
            buttonBar.getButtons().addAll((Object[])new Node[]{saveButton, closeButton});
            dialog.setScene(dialogScene);
            dialog.show();
            saveButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> ((Button)saveButton).fire());
            closeButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> ((Button)closeButton).fire());
            closeButton.setOnAction(event -> dialog.close());
            saveButton.setOnAction(event -> {
                FileChooser fileChooser = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("TXT files (*.txt)", new String[]{"*.txt"});
                fileChooser.getExtensionFilters().add((Object)extFilter);
                File file = fileChooser.showSaveDialog((Window)primaryStage);
                if (file != null) {
                    this.SaveFile(reportGenerator.getFormattedReport(), file);
                }
            });
        } else {
            new Popup(Alert.AlertType.ERROR, "Component Error", "Missing Required Input", "Fromdate, throughdate, and at least one procedure line are required to run a claim.").showAndWait();
        }
    }

    private void setTextFieldConfig(TextArea reportField, VBox dialogVbox, double height, double width) {
        reportField.setPrefHeight(height);
        reportField.setPrefWidth(width);
        reportField.setEditable(false);
        reportField.setStyle("-fx-font-family: 'monospaced';");
        dialogVbox.getChildren().add((Object)reportField);
    }

    @FXML
    private void addDXAction(ActionEvent actionEvent) {
        logger.log(Level.WARN, actionEvent.getSource());
        switch (((Button)actionEvent.getSource()).getId()) {
            case "addPDXButton": {
                pdxData.add((Object)new Diagnosis(this.dxCodeText.getText(), this.dxDescriptionText.getText()));
                ControlUtils.disableAndReset(pdxData.size() == 1, new Control[]{this.addPDXButton});
                break;
            }
            case "addRVDXButton": {
                if (rvdxData.size() < 3) {
                    rvdxData.add((Object)new Diagnosis(this.dxCodeText.getText(), this.dxDescriptionText.getText()));
                }
                ControlUtils.disableAndReset(rvdxData.size() == 3, new Control[]{this.addRVDXButton});
                break;
            }
            case "addSDXButton": {
                if (sdxData.size() < 24) {
                    sdxData.add((Object)new Diagnosis(this.dxCodeText.getText(), this.dxDescriptionText.getText()));
                }
                ControlUtils.disableAndReset(sdxData.size() == 24, new Control[]{this.addSDXButton});
            }
        }
        ControlUtils.resetControl(NodeUtils.getAllControl((Parent)this.baseGridPane, this.dxCodeText.getId(), this.dxDescriptionText.getId()));
    }

    @FXML
    private void deleteDXAction(ActionEvent actionEvent) {
        if (this.pdxTable.getSelectionModel().getSelectedItem() != null) {
            pdxData.remove(this.pdxTable.getSelectionModel().getSelectedItem());
            this.pdxTable.getSelectionModel().clearSelection();
            this.addPDXButton.setDisable(false);
        } else if (this.sdxTable.getSelectionModel().getSelectedItem() != null) {
            sdxData.remove(this.sdxTable.getSelectionModel().getSelectedItem());
            this.sdxTable.getSelectionModel().clearSelection();
            this.addSDXButton.setDisable(false);
        } else if (this.rvdxTable.getSelectionModel().getSelectedItem() != null) {
            rvdxData.remove(this.rvdxTable.getSelectionModel().getSelectedItem());
            this.rvdxTable.getSelectionModel().clearSelection();
            this.addRVDXButton.setDisable(false);
        }
    }

    @FXML
    private void deleteProcedureAction(ActionEvent actionEvent) {
        if (this.procedureTable.getSelectionModel().getSelectedItem() != null) {
            procedureData.remove(this.procedureTable.getSelectionModel().getSelectedItem());
            this.procedureTable.getSelectionModel().clearSelection();
        }
    }

    @FXML
    private void clearSelections(MouseEvent mouseEvent) {
        Node source = (Node)mouseEvent.getSource();
        if (source == this.pdxTable) {
            this.sdxTable.getSelectionModel().clearSelection();
            this.rvdxTable.getSelectionModel().clearSelection();
        } else if (source == this.sdxTable) {
            this.pdxTable.getSelectionModel().clearSelection();
            this.rvdxTable.getSelectionModel().clearSelection();
        } else if (source == this.rvdxTable) {
            this.pdxTable.getSelectionModel().clearSelection();
            this.sdxTable.getSelectionModel().clearSelection();
        }
    }

    @FXML
    private void copyProcedureAction(ActionEvent actionEvent) {
        if (this.procedureTable.getSelectionModel().getSelectedItem() != null) {
            Procedure procedure = new Procedure((Procedure)this.procedureTable.getSelectionModel().getSelectedItem()).getProcedure();
            this.codeText.setText(procedure.getCode().trim());
            this.mod1Text.setText(procedure.getModifier1().trim());
            this.mod2Text.setText(procedure.getModifier2().trim());
            this.mod3Text.setText(procedure.getModifier3().trim());
            this.mod4Text.setText(procedure.getModifier4().trim());
            this.mod5Text.setText(procedure.getModifier5().trim());
            this.revenueCodeText.setText(procedure.getRevenueCode().trim());
            if (!procedure.getUnitsInput().replace("0", "").trim().isEmpty()) {
                this.unitsText.setText(procedure.getUnitsInput());
            }
            if (!procedure.getChargeInput().replace("0", "").trim().isEmpty()) {
                this.chargesText.setText(procedure.getChargeInput());
            }
            if (procedure.getServiceDate() != null) {
                this.serviceDatePicker.setValue((Object)LocalDate.parse(procedure.getServiceDate(), DateTimeFormatter.ofPattern("MMddyyyy")));
            }
            this.actionFlagComboBox.getSelectionModel().select((Object)procedure.getLineItemActionFlagInput());
            this.cbEdit1Text.setText(procedure.getCbEdit1().trim());
            this.cbEdit2Text.setText(procedure.getCbEdit2().trim());
            this.cbEdit3Text.setText(procedure.getCbEdit3().trim());
            this.cbEdit4Text.setText(procedure.getCbEdit4().trim());
            this.cbAPCText.setText(procedure.getCbAPC().trim());
            this.cbStatusIndicatorText.setText(procedure.getCbStatusIndicator().trim());
            this.cbPaymentIndicatorText.setText(procedure.getCbPaymentIndicator().trim());
            this.cbDiscountingFormula.setText(procedure.getCbDiscountingFormula().trim());
            this.denialRejectionFlagComboBox.getSelectionModel().select((Object)procedure.getCbDenialRejection());
            this.packagingFlagComboBox.getSelectionModel().select((Object)procedure.getCbPackagingFlag());
            this.paymentAdjustmentFlagComboBox.getSelectionModel().select((Object)procedure.getCbPaymentAdjustmentFlag());
            this.paymentMethodFlagComboBox.getSelectionModel().select((Object)procedure.getCbPaymentMethodFlag());
            if (this.fromDatePicker.getValue() != null) {
                this.descriptionText.setText(new ComponentManager().getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), this.codeText.getText(), 1));
            }
        }
    }

    @FXML
    private void newClaimAction(ActionEvent actionEvent) {
        logger.log(Level.WARN, actionEvent.getSource());
        if (new Popup(Alert.AlertType.CONFIRMATION, "Reset Claim Information?", "Are you sure you want to reset this claim?", "").showAndWait().get() == ButtonType.OK) {
            this.resetGUI();
        }
    }

    @FXML
    private void exitAction(ActionEvent actionEvent) {
        logger.log(Level.WARN, actionEvent.getSource());
        if (new Popup(Alert.AlertType.CONFIRMATION, "Close Application?", "Are you sure you want to close?", "").showAndWait().get() == ButtonType.OK) {
            System.exit(0);
        }
    }

    @FXML
    private void aboutPopupAction(ActionEvent actionEvent) {
        logger.log(Level.WARN, actionEvent.getSource());
        Stage dialog = new Stage();
        Stage primaryStage = (Stage)this.baseGridPane.getScene().getWindow();
        TextArea reportField = new TextArea();
        dialog.setResizable(false);
        VBox dialogVbox = new VBox(20.0);
        double height = 100.0;
        double width = 500.0;
        Scene dialogScene = new Scene((Parent)dialogVbox, 500.0, 100.0);
        dialog.setTitle(this._CONSTANTS_.getCopyrightTitle());
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.initOwner((Window)primaryStage);
        this.setTextFieldConfig(reportField, dialogVbox, 100.0, 500.0);
        reportField.setText(Constants._AMA_MESSAGE_);
        dialog.setScene(dialogScene);
        dialog.show();
    }

    @FXML
    private void addProcedureAction(ActionEvent actionEvent) {
        logger.log(Level.WARN, actionEvent.getSource());
        Control[] procedureFields = new Control[]{this.addProcedureButton, this.mod1Text, this.mod2Text, this.mod3Text, this.mod4Text, this.mod5Text, this.revenueCodeText, this.unitsText, this.chargesText, this.serviceDatePicker, this.actionFlagComboBox, this.serviceDatePicker};
        Control[] byPassFields = new Control[]{this.cbAPCText, this.cbStatusIndicatorText, this.cbEdit1Text, this.cbEdit2Text, this.cbEdit3Text, this.cbEdit4Text, this.cbPaymentIndicatorText, this.cbPaymentIndicatorText, this.cbDiscountingFormula, this.denialRejectionFlagComboBox, this.packagingFlagComboBox, this.paymentAdjustmentFlagComboBox, this.paymentMethodFlagComboBox};
        Control[] codeLabels = new Control[]{this.codeText, this.descriptionText};
        Procedure procedure = new Procedure(this.codeText.getText(), this.descriptionText.getText(), this.mod1Text.getText(), this.mod2Text.getText(), this.mod3Text.getText(), this.mod4Text.getText(), this.mod5Text.getText(), this.revenueCodeText.getText(), this.unitsText.getText(), this.chargesText.getText(), (LocalDate)this.serviceDatePicker.getValue(), (String)this.actionFlagComboBox.getSelectionModel().getSelectedItem(), this.cbEdit1Text.getText(), this.cbEdit2Text.getText(), this.cbEdit3Text.getText(), this.cbEdit4Text.getText(), this.cbAPCText.getText(), this.cbStatusIndicatorText.getText(), this.cbPaymentIndicatorText.getText(), this.cbDiscountingFormula.getText(), (String)this.denialRejectionFlagComboBox.getSelectionModel().getSelectedItem(), (String)this.packagingFlagComboBox.getSelectionModel().getSelectedItem(), (String)this.paymentAdjustmentFlagComboBox.getSelectionModel().getSelectedItem(), (String)this.paymentMethodFlagComboBox.getSelectionModel().getSelectedItem());
        procedureData.add((Object)procedure);
        ControlUtils.resetControl(procedureFields);
        ControlUtils.resetControl(byPassFields);
        ControlUtils.resetControl(codeLabels);
    }

    private EventHandler<KeyEvent> numericValidation(Integer max) {
        return e -> {
            TextField textField = (TextField)e.getSource();
            if (textField.getText().length() >= max) {
                e.consume();
            } else if (e.getCharacter().matches("[0-9.]")) {
                if (textField.getText().contains(".") && e.getCharacter().matches("[.]")) {
                    e.consume();
                } else if (textField.getText().length() == 0 && e.getCharacter().matches("[.]")) {
                    e.consume();
                }
            } else {
                e.consume();
            }
        };
    }

    private EventHandler<KeyEvent> alphaValidation(Integer max) {
        return e -> {
            TextField textField = (TextField)e.getSource();
            if (textField.getText().length() >= max) {
                e.consume();
            }
            if (!e.getCharacter().matches("[A-Za-z]")) {
                e.consume();
            }
        };
    }

    private EventHandler<KeyEvent> alphaNumericValidation(Integer max) {
        return e -> {
            TextField textField = (TextField)e.getSource();
            if (textField.getText().length() >= max) {
                e.consume();
            }
            if (!e.getCharacter().matches("[a-zA-Z0-9]")) {
                e.consume();
            }
        };
    }

    private EventHandler<KeyEvent> toUpper() {
        return e -> {
            TextField textField = (TextField)e.getSource();
            if (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.BACK_SPACE || e.getCode() == KeyCode.DELETE || e.getCode() == KeyCode.HOME || e.getCode() == KeyCode.END) {
                e.consume();
            } else {
                int position = textField.getCaretPosition();
                textField.setText(textField.getText().toUpperCase());
                textField.positionCaret(position);
            }
            if (textField == this.dxCodeText && this.fromDatePicker.getValue() != null) {
                this.dxDescriptionText.setText(new ComponentManager().getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), this.dxCodeText.getText(), 2));
            } else if (textField == this.codeText && this.fromDatePicker.getValue() != null) {
                this.descriptionText.setText(new ComponentManager().getDescription(StringUtils.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "YYYYMMdd"), this.codeText.getText(), 1));
            }
        };
    }

    void loadAccelerators(Scene scene) {
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addPDXButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addSDXButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addRVDXButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.deleteDXButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addProcedureButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.deleteProcedureButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.copyProcedureButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.newClaimButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.generateReportButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.exitButton.fire());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.helpButton.fire());
    }
}

