/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.Controller;
import com.component.BatchManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Main
extends Application {
    private static final Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            new BufferedWriter(new FileWriter("log.txt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (args.length == 2) {
            int exitStatus = 0;
            logger.log(Level.INFO, "Two inputs read, configured for batch run");
            File input = new File(args[0]);
            File output = new File(args[1]);
            logger.log(Level.INFO, String.format("[input file], %s", input.getAbsolutePath()));
            logger.log(Level.INFO, String.format("[output file], %s", output.getAbsolutePath()));
            if (!input.exists()) {
                logger.log(Level.ERROR, "The input file or directory does not exist, exiting");
                exitStatus = -1;
            } else if (!output.exists() && output.isDirectory()) {
                logger.log(Level.ERROR, "The output directory does not exist, exiting");
                exitStatus = -1;
            } else if ((input.isDirectory() && input.exists()) ^ (output.isDirectory() && output.exists())) {
                logger.log(Level.ERROR, "One parameter is a file, while one parameter is a directory or does not exist. Use two files or two directories. Ensure output directory exists. Exiting");
                exitStatus = -1;
            } else if (input.isDirectory()) {
                File[] directoryListing = input.listFiles();
                for (File child : directoryListing != null ? directoryListing : new File[]{}) {
                    if (new BatchManager(child, new File(output.getAbsolutePath() + "/" + child.getName())).group()) continue;
                    logger.log(Level.ERROR, "There was an error in grouping. Check the log for more information.");
                }
            } else if (!new BatchManager(input, output).group()) {
                logger.log(Level.ERROR, "There was an error in grouping. Check the log for more information.");
            }
            System.exit(exitStatus);
        } else if (args.length == 1) {
            logger.log(Level.ERROR, "Missing output file or directory");
        } else {
            logger.log(Level.INFO, "No inputs available, launching GUI.");
            Main.launch((String[])args);
        }
    }

    public void start(Stage primaryStage) throws Exception {
        FXMLLoader loader = new FXMLLoader();
        GridPane page = (GridPane)loader.load(((Object)((Object)this)).getClass().getResourceAsStream("/fxml/product.fxml"));
        Scene scene = new Scene((Parent)page);
        primaryStage.setTitle("Integrated Outpatient Code Editor");
        primaryStage.setResizable(false);
        primaryStage.setScene(scene);
        primaryStage.show();
        Controller controller = (Controller)loader.getController();
        controller.loadAccelerators(scene);
    }
}

