/*
 * Decompiled with CFR 0.152.
 */
package com.component;

import com.component.ComponentManager;
import com.modal.Diagnosis;
import com.modal.Procedure;
import com.modal.claim.Claim;
import com.modal.claim.GrouperOutput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class BatchManager {
    private File inputFile;
    private File outputFile;
    private static final Logger logger = Logger.getLogger(BatchManager.class);

    public BatchManager(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    public boolean group() {
        try {
            this.parseLines();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void parseLines() throws FileNotFoundException {
        Scanner fileInput = new Scanner(this.inputFile);
        Claim claim = new Claim();
        String nextLine = fileInput.nextLine();
        int linePointer = 0;
        int claimNumber = 0;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile.getAbsolutePath(), false));
            writer.close();
            writer = new BufferedWriter(new FileWriter(this.outputFile.getAbsolutePath(), true));
            ComponentManager componentManager = new ComponentManager();
            long start = System.currentTimeMillis();
            System.out.print("\n");
            while (fileInput.hasNext()) {
                if (nextLine.startsWith("C")) {
                    claim.getGrouperInput().setHasCRecord(true);
                    System.out.print("\r" + this.inputFile + " Processing claim " + ++claimNumber + " " + (float)(System.currentTimeMillis() - start) / 1000.0f + " sec");
                } else if (nextLine.startsWith("D")) {
                    claim.getGrouperInput().setHasDRecord(true);
                } else if (nextLine.startsWith("E")) {
                    claim.getGrouperInput().setHasERecord(true);
                } else if (nextLine.startsWith("F")) {
                    claim.getGrouperInput().setHasFRecord(true);
                } else if (nextLine.startsWith("L")) {
                    claim.getGrouperInput().setHasLRecord(true);
                }
                claim.parseBatchAndSet(nextLine, linePointer);
                if (nextLine.startsWith("L")) {
                    ++linePointer;
                }
                if (!(nextLine = fileInput.nextLine()).startsWith("C")) continue;
                claim.setGrouperOutput(new GrouperOutput(new ArrayList<Procedure>((Collection<Procedure>)claim.getGrouperInput().getProcedures()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getPdxList()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getSdxList()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getRvdxList())));
                componentManager.setGrouperInput(claim.getGrouperInput());
                componentManager.setGrouperOutput(claim.getGrouperOutput());
                componentManager.processFixedClaim();
                claim.writeClaimToFile(writer);
                claim = new Claim();
                linePointer = 0;
            }
            claim.parseBatchAndSet(nextLine, linePointer);
            claim.setGrouperOutput(new GrouperOutput(new ArrayList<Procedure>((Collection<Procedure>)claim.getGrouperInput().getProcedures()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getPdxList()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getSdxList()), new ArrayList<Diagnosis>((Collection<Diagnosis>)claim.getGrouperInput().getRvdxList())));
            componentManager.setGrouperInput(claim.getGrouperInput());
            componentManager.setGrouperOutput(claim.getGrouperOutput());
            componentManager.processFixedClaim();
            claim.writeClaimToFile(writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

