/*
 * Decompiled with CFR 0.152.
 */
package com.component;

import com.constants.code.Opps_EN;
import com.constants.code.Sex_EN;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainFixedString;
import com.mmmhis.domain.DomainString;
import com.mmmhis.groupers.gapc;
import com.modal.ClaimOutputFlag;
import com.modal.Diagnosis;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import com.util.StringUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ComponentManager {
    private static final Logger logger = Logger.getLogger(ComponentManager.class);
    private static final DomainEnvironment env = new DomainEnvironment(new String[0]);
    private static gapc cmsGrouper;
    private String[] domainEnvList;
    private GrouperInput grouperInput;
    private GrouperOutput grouperOutput;

    public ComponentManager(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this();
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
    }

    public ComponentManager() {
        this.initManager();
    }

    private void initManager() {
        this.buildDomainEnvList("gapc.ctl");
        this.createGrouper();
    }

    public String getDescription(String fsDate, String code, int tableLookupKey) {
        DomainString description = new DomainString();
        int returnCode = 0;
        try {
            if (fsDate != null && !fsDate.isEmpty()) {
                returnCode = cmsGrouper.GAPC_VarClaimDescA(tableLookupKey, code.trim(), fsDate, description, this.getCodeSet(fsDate));
            }
        }
        catch (DomainException e) {
            logger.error(e.getMessage());
        }
        if (returnCode == 0) {
            return description.toString();
        }
        logger.debug("Description lookup return code -> " + returnCode);
        return "Invalid Code";
    }

    public String getDescription(String fsDate, String code, int tableLookupKey, String valueID) {
        DomainString description = new DomainString();
        int returnCode = 0;
        try {
            if (fsDate != null && !fsDate.isEmpty()) {
                returnCode = cmsGrouper.GAPC_VarClaimDescA(tableLookupKey, code.trim(), fsDate, description, valueID);
            }
        }
        catch (DomainException e) {
            logger.error(e.getMessage());
        }
        if (returnCode == 0) {
            return description.toString();
        }
        logger.debug("Description lookup return code -> " + returnCode);
        return "Invalid Code";
    }

    private String getCodeSet(String fDate) {
        String codeSet = "0";
        if (fDate != null && !fDate.isEmpty()) {
            try {
                Date switchDate = new SimpleDateFormat("yyyyMMdd", Locale.US).parse("20151001");
                Date fromDate = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(fDate);
                codeSet = fromDate.before(switchDate) ? "9" : "0";
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                codeSet = "0";
            }
        }
        return codeSet;
    }

    public void processFixedClaim() {
        String fsNonOPPS;
        String fsSex;
        Object procedure;
        String domainString;
        int i2;
        Object[] fsDxCodes = new String[28];
        Arrays.fill(fsDxCodes, "        ");
        for (i2 = 0; i2 < this.grouperInput.getRvdxList().size(); ++i2) {
            fsDxCodes[i2] = ((Diagnosis)this.grouperInput.getRvdxList().get(i2)).getCode();
        }
        for (i2 = 0; i2 < this.grouperInput.getPdxList().size(); ++i2) {
            fsDxCodes[i2 + 3] = ((Diagnosis)this.grouperInput.getPdxList().get(i2)).getCode();
        }
        for (i2 = 0; i2 < this.grouperInput.getSdxList().size(); ++i2) {
            fsDxCodes[i2 + 3 + 1] = ((Diagnosis)this.grouperInput.getSdxList().get(i2)).getCode();
        }
        Object[] fsProcedureCodes = new String[450];
        Arrays.fill(fsProcedureCodes, "                                                                         ");
        Iterator iterator = this.grouperInput.getProcedures().iterator();
        while (iterator.hasNext() && !(domainString = ((Procedure)(procedure = (Procedure)iterator.next())).toDomainString()).trim().isEmpty()) {
            fsProcedureCodes[this.grouperInput.getProcedures().indexOf((Object)procedure)] = domainString;
        }
        Object[] fsActionFlags = new String[450];
        Arrays.fill(fsActionFlags, "");
        for (Procedure procedure2 : this.grouperInput.getProcedures()) {
            fsActionFlags[this.grouperInput.getProcedures().indexOf((Object)procedure2)] = procedure2.getLineItemActionFlagInput();
        }
        String fsAge = this.grouperInput.getAge().length() == "   ".length() ? this.grouperInput.getAge() : "   ";
        try {
            fsSex = String.valueOf(Sex_EN.valueOf((String)this.grouperInput.getSex()).componentValue);
        }
        catch (IllegalArgumentException e) {
            fsSex = this.grouperInput.getSex();
        }
        String fsDate = (this.grouperInput.getFromDate() + this.grouperInput.getThroughDate()).replaceAll("-", "");
        Object[] fsConditionCodes = new String[60];
        int conditionCodeCounter = 0;
        Arrays.fill(fsConditionCodes, "  ");
        for (String conditionCode : this.grouperInput.getConditionCodes()) {
            if (conditionCode.isEmpty()) continue;
            fsConditionCodes[conditionCodeCounter++] = conditionCode;
        }
        Object[] fsOccurrenceCodes = new String[60];
        int occurrenceCodeCounter = 0;
        Arrays.fill(fsOccurrenceCodes, "  ");
        for (String occurrenceCode : this.grouperInput.getOccurrenceCodes()) {
            if (occurrenceCode.isEmpty()) continue;
            fsOccurrenceCodes[occurrenceCodeCounter++] = occurrenceCode;
        }
        String fsBillType = this.grouperInput.getBillType().length() == "   ".length() ? this.grouperInput.getBillType() : "   ";
        String fsPatientStatus = this.grouperInput.getPatientStatus().length() == "  ".length() ? this.grouperInput.getPatientStatus() : "  ";
        try {
            fsNonOPPS = String.valueOf(Opps_EN.valueOf((String)this.grouperInput.getOpps()).componentValue);
        }
        catch (IllegalArgumentException e) {
            fsNonOPPS = this.grouperInput.getOpps();
        }
        Object[] fsValueCodes = new String[36];
        Arrays.fill(fsValueCodes, "           ");
        for (ValueCodes valueCode : this.grouperInput.getValueCodes()) {
            if (valueCode.getValueCode().isEmpty()) continue;
            fsValueCodes[this.grouperInput.getValueCodes().indexOf((Object)valueCode)] = valueCode.toDomainString();
        }
        DomainFixedString[] fsDxEdits = StringUtils.createEmptyDomainStringArray(24, 28);
        DomainFixedString[] fsProcEdits = StringUtils.createEmptyDomainStringArray(90, 450);
        DomainFixedString[] fsModifEdits = StringUtils.createEmptyDomainStringArray(60, 450);
        DomainFixedString[] fsDateEdits = StringUtils.createEmptyDomainStringArray(12, 450);
        DomainFixedString[] fsRevenueEdits = StringUtils.createEmptyDomainStringArray(15, 450);
        DomainFixedString[] fsApcReturnBuffer = StringUtils.createEmptyDomainStringArray(51, 450);
        DomainFixedString fsClaimReturnBuffer = new DomainFixedString(403);
        try {
            int grouperReturnCode = cmsGrouper.GAPC_FixedOCEAPC((String[])fsDxCodes, (String[])fsProcedureCodes, (String[])fsActionFlags, fsAge, fsSex, fsDate, (String[])fsConditionCodes, fsBillType, "             ", "      ", fsPatientStatus, fsNonOPPS, (String[])fsOccurrenceCodes, (String[])fsValueCodes, fsDxEdits, fsProcEdits, fsModifEdits, fsDateEdits, fsRevenueEdits, fsApcReturnBuffer, fsClaimReturnBuffer);
            this.grouperOutput.addLineLevelOutput(fsApcReturnBuffer, fsProcEdits, fsModifEdits, fsDateEdits, fsRevenueEdits, this.grouperInput.getProcedures());
            this.grouperOutput.addClaimLevelOutputs(fsClaimReturnBuffer.toString());
            this.grouperOutput.addDXEdits(fsDxEdits);
            this.grouperOutput.setReturnCode(new ClaimOutputFlag(String.format("%2s", grouperReturnCode).replace(" ", " "), 14));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int buildDomainEnvList(String rotFileList) {
        this.domainEnvList = new String[10];
        int rotIdx = 0;
        StringTokenizer tokenizer = new StringTokenizer(rotFileList, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String rotFilePath = "./" + token;
            File rotFile = new File(rotFilePath);
            if (!rotFile.exists()) continue;
            this.domainEnvList[rotIdx++] = "database/path";
            this.domainEnvList[rotIdx++] = rotFilePath;
        }
        return rotIdx / 2;
    }

    private gapc createGrouper() {
        cmsGrouper = new gapc(env, this.domainEnvList, "unloadimage.rcs");
        return cmsGrouper;
    }

    public void setGrouperInput(GrouperInput grouperInput) {
        this.grouperInput = grouperInput;
    }

    public void setGrouperOutput(GrouperOutput grouperOutput) {
        this.grouperOutput = grouperOutput;
    }
}

