/*
 * Decompiled with CFR 0.152.
 */
package com.component;

import com.constants.Component_EN;
import com.constants.Constants;
import com.modal.Diagnosis;
import com.modal.Edit;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import com.util.StringUtils;
import java.util.ArrayList;

public class ReportGenerator {
    private StringBuilder sb = new StringBuilder();
    private GrouperInput grouperInput;
    private GrouperOutput grouperOutput;
    private Constants _CONSTANTS_ = new Constants(Component_EN.IOCE);

    public ReportGenerator(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
        this.appendClaimLevelInfo();
    }

    private void appendClaimLevelInfo() {
        String _AGE_ = "Age (years):";
        String _BIRTH_DATE_ = "Birth Date:";
        String _COMMENT_ = "Comment:";
        String _CONDITION_CODES_ = "Condition Codes:";
        String _FROM_DATE_ = "From Date:";
        String _MEDICAL_RECORD_ = "Medical Record Number:";
        String _OCCURRENCE_CODES_ = "Occurrence Codes:";
        String _OCE_VERSION_ = "OCE Version Used:";
        String _OPPS_FLAG_ = "OPPS Flag:";
        String _PATIENT_ACCOUNT_NUMBER_ = "Account #:";
        String _PAY_SOURCE_ = "Pay Source:";
        String _PATIENT_NAME_ = "Patient Name:";
        String _PATIENT_STATUS_ = "Patient Status:";
        String _PAYER_CONDITION_CODES_ = "Payer Condition Codes:";
        String _PRINCIPAL_DIAGNOSIS_ = "Principal Diagnosis:\n";
        String _PROCEDURES_ = "Procedures:\n";
        String _REASON_DX_DIAGNOSIS_ = "Reason For Visit Diagnosis:\n";
        final String _REPORT_HEADER_ = this._CONSTANTS_.getReportTitle();
        String _SECONDARY_DIAGNOSIS_ = "Secondary Diagnosis:\n";
        String _SEX_ = "Sex:";
        String _THROUGH_DATE_ = "Through Date:";
        String _TYPE_OF_BILL_ = "Bill Type:";
        String _VALUE_CODES_INPUT_ = "Value Codes (Input):\n";
        String _VALUE_CODES_OUTPUT_ = "Value Codes (Output):\n";
        String _OVERALL_CLAIM_DISPOSITION_ = "Overall Claim Disposition:";
        String _CLAIM_PROCESSING_FLAG_ = "Claim Processing Flag:";
        String _GROUPER_RETURN_CODE_ = "Grouper Return Code:";
        String _BUFFER_COMPLETED_ = "APC Buffer Return Flag:";
        String _CLAIM_REJECTION_EDITS_ = "Claim Rejection Edits:\n";
        String _CLAIM_DENIAL_EDITS_ = "Claim Denial Edits:\n";
        String _CLAIM_RTP_EDITS_ = "Claim Return To Provider Edits:\n";
        String _CLAIM_MEDICAL_SUSPEND_EDITS_ = "Claim Medical Suspend Edits:\n";
        String _CLAIM_LINE_ITEM_REJECTION_EDITS_ = "Claim Line Item Rejection Edits:\n";
        String _CLAIM_LINE_ITEM_DENIAL_EDITS_ = "Claim Line Item Denial Edits:\n";
        String _CLAIM_REJECTION_DISPOSITION_ = "Claim Rejection Disposition:";
        String _CLAIM_DENIAL_DISPOSITION_ = "Claim Denial Disposition:";
        String _CLAIM_RTP_DISPOSITION_ = "Claim Return To Provider Disposition:";
        String _CLAIM_SUSPENSION_DISPOSITION_ = "Claim Suspension Disposition:";
        String _LINE_ITEM_REJECTION_DISPOSITION_ = "Line Item Rejection Disposition:";
        String _LINE_ITEM_DENIAL_DISPOSITION_ = "Line Item Denial Disposition:";
        ArrayList<ArrayList<String>> values = new ArrayList<ArrayList<String>>(){
            {
                this.add(new ArrayList<String>(){
                    {
                        this.add(_REPORT_HEADER_);
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Patient Name:", ReportGenerator.this.grouperInput.getPatientName()));
                        this.add(new String(new char[25 - "Patient Name:".length() - ReportGenerator.this.grouperInput.getPatientName().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Medical Record Number:", ReportGenerator.this.grouperInput.getMedicalRecordNumber()));
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("From Date:", StringUtils.convertToDomainDate(ReportGenerator.this.grouperInput.getFromDate(), "yyyy-MM-dd", "MM/dd/YYYY")));
                        this.add(new String(new char[25 - "From Date:".length() - ReportGenerator.this.grouperInput.getFromDate().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Through Date:", StringUtils.convertToDomainDate(ReportGenerator.this.grouperInput.getThroughDate(), "yyyy-MM-dd", "MM/dd/YYYY")));
                        this.add(new String(new char[25 - "Through Date:".length() - ReportGenerator.this.grouperInput.getThroughDate().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("OPPS Flag:", ReportGenerator.this.grouperInput.getOpps()));
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Birth Date:", StringUtils.convertToDomainDate(ReportGenerator.this.grouperInput.getBirthDate(), "yyyy-MM-dd", "MM/dd/YYYY")));
                        this.add(new String(new char[25 - "Birth Date:".length() - StringUtils.convertToDomainDate(ReportGenerator.this.grouperInput.getBirthDate(), "yyyy-MM-dd", "MM/dd/YYYY").length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Age (years):", ReportGenerator.this.grouperInput.getAge()));
                        this.add(new String(new char[25 - "Age (years):".length() - ReportGenerator.this.grouperInput.getAge().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Sex:", ReportGenerator.this.grouperInput.getSex()));
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Patient Status:", ReportGenerator.this.grouperInput.getPatientStatus()));
                        this.add(new String(new char[25 - "Patient Status:".length() - ReportGenerator.this.grouperInput.getPatientStatus().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Bill Type:", ReportGenerator.this.grouperInput.getBillType()));
                        this.add(new String(new char[25 - "Bill Type:".length() - ReportGenerator.this.grouperInput.getBillType().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("OCE Version Used:", ReportGenerator.this.grouperOutput.getOceVersionUsed()));
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Pay Source:", ReportGenerator.this.grouperInput.getPaySource()));
                        this.add(new String(new char[25 - "Pay Source:".length() - ReportGenerator.this.grouperInput.getPaySource().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Account #:", ReportGenerator.this.grouperInput.getAccountNumber()));
                        this.add(new String(new char[25 - "Account #:".length() - ReportGenerator.this.grouperInput.getAccountNumber().length()]).replace("\u0000", " "));
                        this.add(StringUtils.cat("Comment:", ReportGenerator.this.grouperInput.getComment()));
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add("Condition Codes:");
                        for (String v : ReportGenerator.this.grouperInput.getConditionCodes()) {
                            if (v.trim().isEmpty()) continue;
                            this.add(v + " ");
                        }
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add("Occurrence Codes:");
                        for (String v : ReportGenerator.this.grouperInput.getOccurrenceCodes()) {
                            if (v.trim().isEmpty()) continue;
                            this.add(v + " ");
                        }
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add("Payer Condition Codes:");
                        for (String v : ReportGenerator.this.grouperOutput.getPayerConditionCodes()) {
                            if (v.trim().isEmpty()) continue;
                            this.add(v + " ");
                        }
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!(ReportGenerator.this.grouperInput.getValueCodes().get(0).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperInput.getValueCodes().get(1).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperInput.getValueCodes().get(2).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperInput.getValueCodes().get(3).getValueCode().trim().isEmpty())) {
                            this.add("Value Codes (Input):\n");
                            for (ValueCodes v : ReportGenerator.this.grouperInput.getValueCodes()) {
                                if (v.getValueCode().trim().isEmpty()) continue;
                                this.add(v.toString() + " ");
                            }
                        }
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!(ReportGenerator.this.grouperOutput.getValueCodes().get(0).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(1).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(2).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(3).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(4).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(5).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(6).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(7).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(8).getValueCode().trim().isEmpty() && ReportGenerator.this.grouperOutput.getValueCodes().get(9).getValueCode().trim().isEmpty())) {
                            this.add("Value Codes (Output):\n");
                            for (ValueCodes v : ReportGenerator.this.grouperOutput.getValueCodes()) {
                                if (v.getValueCode().trim().isEmpty()) continue;
                                this.add(v.toString() + " ");
                            }
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimRejectionEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("\nClaim Rejection Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimRejectionEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimDenialEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("\nClaim Denial Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimDenialEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimRtpEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("Claim Return To Provider Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimRtpEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimMedicalSuspendEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("\nClaim Medical Suspend Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimMedicalSuspendEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimLineItemRejectionEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("\nClaim Line Item Rejection Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimLineItemRejectionEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (!ReportGenerator.this.grouperOutput.getClaimLineItemDenialEdits().get(0).getEdit().trim().isEmpty()) {
                            this.add("\nClaim Line Item Denial Edits:\n");
                        }
                        for (Edit e : ReportGenerator.this.grouperOutput.getClaimLineItemDenialEdits()) {
                            if (e.getEdit().trim().isEmpty()) continue;
                            this.add(e.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (ReportGenerator.this.grouperInput.getPdxList().size() > 0) {
                            this.add("\nPrincipal Diagnosis:\n");
                        }
                        for (Diagnosis d : ReportGenerator.this.grouperInput.getPdxList()) {
                            this.add(d.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (ReportGenerator.this.grouperInput.getSdxList().size() > 0) {
                            this.add("\nSecondary Diagnosis:\n");
                        }
                        for (Diagnosis d : ReportGenerator.this.grouperInput.getSdxList()) {
                            this.add(d.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (ReportGenerator.this.grouperInput.getRvdxList().size() > 0) {
                            this.add("\nReason For Visit Diagnosis:\n");
                        }
                        for (Diagnosis d : ReportGenerator.this.grouperInput.getRvdxList()) {
                            this.add(d.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (ReportGenerator.this.grouperInput.getProcedures().size() > 0) {
                            this.add("\nProcedures:\n");
                        }
                        for (Procedure procedure : ReportGenerator.this.grouperInput.getProcedures()) {
                            this.add(procedure.toFormattedString(ReportGenerator.this.grouperInput.getFromDateDomainFormat()) + "\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Grouper Return Code:", ReportGenerator.this.grouperOutput.getReturnCode().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Overall Claim Disposition:", ReportGenerator.this.grouperOutput.getOverallClaimDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Claim Rejection Disposition:", ReportGenerator.this.grouperOutput.getClaimRejectionDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Claim Denial Disposition:", ReportGenerator.this.grouperOutput.getClaimDenialDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Claim Return To Provider Disposition:", ReportGenerator.this.grouperOutput.getClaimRTPDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Claim Suspension Disposition:", ReportGenerator.this.grouperOutput.getClaimSuspensionDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Line Item Rejection Disposition:", ReportGenerator.this.grouperOutput.getLineItemRejectionDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("Line Item Denial Disposition:", ReportGenerator.this.grouperOutput.getLineItemDenialDisposition().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                            this.add("\n");
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        if (Integer.parseInt(ReportGenerator.this.grouperOutput.getReturnCode().getValue().replace(" ", "")) == 0) {
                            this.add(StringUtils.cat("APC Buffer Return Flag:", ReportGenerator.this.grouperOutput.getBufferCompleted()).trim());
                            this.add("\n");
                        }
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add(StringUtils.cat("Claim Processing Flag:", ReportGenerator.this.grouperOutput.getClaimProcessedFlag().getValueAndDescription(ReportGenerator.this.grouperInput.getFromDateDomainFormat())).trim());
                        this.add("\n");
                    }
                });
                this.add(new ArrayList<String>(){
                    {
                        this.add("\n");
                        this.add(Constants._AMA_MESSAGE_LONG_);
                        this.add("\n");
                    }
                });
            }
        };
        for (ArrayList arrayList : values) {
            for (String v : arrayList) {
                this.sb.append(v);
            }
        }
    }

    public String getFormattedReport() {
        return this.sb.toString();
    }
}

